% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{st_normalize}
\alias{st_normalize}
\title{Normalize simple features}
\usage{
st_normalize(x, domain = st_bbox(x), ...)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{domain}{The domain \code{x} should be normalized from as a length 4
vector of the form \code{c(xmin, ymin, xmax, ymax)}. Defaults to the
bounding box of \code{x}}

\item{...}{ignored}
}
\description{
\code{st_normalize} transforms the coordinates in the input feature to fall
between 0 and 1. By default the current domain is set to the bounding box of
the input, but other domains can be used as well
}
\examples{
p1 = st_point(c(7,52))
st_normalize(p1, domain = c(0, 0, 10, 100))

p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = 4326)
sfc
sfc_norm <- st_normalize(sfc)
st_bbox(sfc_norm)

}
