% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efa.R
\docType{class}
\name{EFA-class}
\alias{EFA-class}
\alias{show,EFA-method}
\alias{summary,EFA-method}
\title{Class For Rotated Results from EFA}
\usage{
\S4method{show}{EFA}(object)

\S4method{summary}{EFA}(object, suppress = 0.1, sort = TRUE)
}
\arguments{
\item{object}{object of class \code{EFA}}

\item{suppress}{any standardized loadings less than the specified value
will not be printed to the screen}

\item{sort}{\code{logical}. If \code{TRUE} (default), factor loadings will
be sorted by their size in the console output}
}
\description{
This class contains the results of rotated exploratory factor analysis
}
\section{Slots}{

\describe{
\item{\code{loading}}{Rotated standardized factor loading matrix}

\item{\code{rotate}}{Rotation matrix}

\item{\code{gradRotate}}{gradient of the objective function at the rotated loadings}

\item{\code{convergence}}{Convergence status}

\item{\code{phi:}}{Factor correlation matrix. Will be an identity matrix if
orthogonal rotation is used.}

\item{\code{se}}{Standard errors of the rotated standardized factor loading matrix}

\item{\code{method}}{Method of rotation}

\item{\code{call}}{The command used to generate this object}
}}

\section{Objects from the Class}{
 Objects can be created via the
\code{\link{orthRotate}} or \code{\link{oblqRotate}} function.
}

\examples{

unrotated <- efaUnrotate(HolzingerSwineford1939, nf = 3,
                         varList = paste0("x", 1:9), estimator = "mlr")
summary(unrotated, std = TRUE)
lavInspect(unrotated, "std")

# Rotated by Quartimin
rotated <- oblqRotate(unrotated, method = "quartimin")
summary(rotated)

}
\seealso{
\code{\link{efaUnrotate}}; \code{\link{orthRotate}};
\code{\link{oblqRotate}}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
