% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual.R
\name{manual_rset}
\alias{manual_rset}
\title{Manual resampling}
\usage{
manual_rset(splits, ids)
}
\arguments{
\item{splits}{A list of \code{"rsplit"} objects. It is easiest to create these
using \code{\link[=make_splits]{make_splits()}}.}

\item{ids}{A character vector of ids. The length of \code{ids} must be the same
as the length of \code{splits}.}
}
\description{
\code{manual_rset()} is used for constructing the most minimal rset possible. It
can be useful when you have custom rsplit objects built from
\code{\link[=make_splits]{make_splits()}}, or when you want to create a new rset from splits
contained within an existing rset.
}
\examples{
df <- data.frame(x = c(1, 2, 3, 4, 5, 6))

# Create an rset from custom indices
indices <- list(
  list(analysis = c(1L, 2L), assessment = 3L),
  list(analysis = c(4L, 5L), assessment = 6L)
)

splits <- lapply(indices, make_splits, data = df)

manual_rset(splits, c("Split 1", "Split 2"))

# You can also use this to create an rset from a subset of an
# existing rset
resamples <- vfold_cv(mtcars)
best_split <- resamples[5, ]
manual_rset(best_split$splits, best_split$id)
}
