% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile.R
\name{step_percentile}
\alias{step_percentile}
\title{Percentile transformation}
\usage{
step_percentile(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  ref_dist = NULL,
  options = list(probs = (0:100)/100),
  outside = "none",
  skip = FALSE,
  id = rand_id("percentile")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{ref_dist}{The computed percentiles is stored here once this
preprocessing step has be trained by \code{\link[=prep]{prep()}}.}

\item{options}{A named list of options to pass to \code{\link[stats:quantile]{stats::quantile()}}.
See Details for more information.}

\item{outside}{A character, describing how interpolation is to take place
outside the interval \verb{[min(x), max(x)]}. \code{none} means nothing will happen
and values outside the range will be \code{NA}. \code{lower} means that new values
less than \code{min(x)} will be given the value \code{0}. \code{upper} means that new
values larger than \code{max(x)} will be given the value \code{1}. \code{both} will handle
both cases. Defaults to \code{none}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_percentile()} creates a \emph{specification} of a recipe step that replaces
the value of a variable with its percentile from the training set.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value}, \code{percentile} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{numeric, the value at the percentile}
\item{percentile}{numeric, the percentile as a percentage}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
) \%>\%
  step_percentile(carbon)

prepped_rec <- prep(rec)

prepped_rec \%>\%
  bake(biomass_te)

tidy(rec, 1)
tidy(prepped_rec, 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other individual transformation steps: 
\code{\link{step_BoxCox}()},
\code{\link{step_YeoJohnson}()},
\code{\link{step_bs}()},
\code{\link{step_harmonic}()},
\code{\link{step_hyperbolic}()},
\code{\link{step_inverse}()},
\code{\link{step_invlogit}()},
\code{\link{step_logit}()},
\code{\link{step_log}()},
\code{\link{step_mutate}()},
\code{\link{step_ns}()},
\code{\link{step_poly}()},
\code{\link{step_relu}()},
\code{\link{step_sqrt}()}
}
\concept{individual transformation steps}
