#' Fits a Principal Curve in Arbitrary Dimension
#'
#' @name princurve-package
#' @aliases princurve-package princurve
#' @docType package
#'
#' @import Rcpp
#'
#' @seealso \code{\link{principal_curve}}, \code{\link{project_to_curve}}
#'
#' @references
#'  Hastie, T. and Stuetzle, W.,
#'  \href{https://www.jstor.org/stable/2289936}{Principal Curves},
#'  JASA, Vol. 84, No. 406 (Jun., 1989), pp. 502-516,
#'  DOI: \href{https://doi.org/10.2307/2289936}{10.2307/2289936}
#'  (\href{https://web.stanford.edu/~hastie/Papers/principalcurves.pdf}{PDF}).
#'
#'  See also Banfield and Raftery (JASA, 1992).
#'
#' @keywords regression smooth nonparametric
#'
#' @useDynLib princurve
NULL



