% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_smooth.R
\name{pareto_smooth}
\alias{pareto_smooth}
\alias{pareto_smooth.rvar}
\alias{pareto_smooth.default}
\title{Pareto smoothing}
\usage{
pareto_smooth(x, ...)

\method{pareto_smooth}{rvar}(x, return_k = FALSE, extra_diags = FALSE, ...)

\method{pareto_smooth}{default}(
  x,
  tail = c("both", "right", "left"),
  r_eff = NULL,
  ndraws_tail = NULL,
  return_k = FALSE,
  extra_diags = FALSE,
  verbose = TRUE,
  are_log_weights = FALSE,
  ...
)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{return_k}{(logical) Should the Pareto khat be included in
output? If \code{TRUE}, output will be a list containing smoothed
draws and diagnostics, otherwise it will be a numeric of the
smoothed draws. Default is \code{FALSE}.}

\item{extra_diags}{(logical) Should extra Pareto khat diagnostics
be included in output? If \code{TRUE}, \code{min_ss}, \code{khat_threshold} and
\code{convergence_rate} for the estimated k value will be
returned. Default is \code{FALSE}.}

\item{tail}{(string) The tail to diagnose/smooth:
\itemize{
\item \code{"right"}: diagnose/smooth only the right (upper) tail
\item \code{"left"}: diagnose/smooth only the left (lower) tail
\item \code{"both"}: diagnose/smooth both tails and return the maximum k-hat value
}

The default is \code{"both"}.}

\item{r_eff}{(numeric) relative effective sample size estimate. If
\code{r_eff} is NULL, it will be calculated assuming the draws are
from MCMC. Default is NULL.}

\item{ndraws_tail}{(numeric) number of draws for the tail. If
\code{ndraws_tail} is not specified, it will be calculated as
ceiling(3 * sqrt(length(x) / r_eff)) if length(x) > 225 and
length(x) / 5 otherwise (see Appendix H in Vehtari et
al. (2024)).}

\item{verbose}{(logical) Should diagnostic messages be printed? If
\code{TRUE}, messages related to Pareto diagnostics will be
printed. Default is \code{FALSE}.}

\item{are_log_weights}{(logical) Are the draws log weights? Default is
\code{FALSE}. If \code{TRUE} computation will take into account that the
draws are log weights, and only right tail will be smoothed.}
}
\value{
Either a vector \code{x} of smoothed values or a named list
containing the vector \code{x} and a named list \code{diagnostics}
containing numeric values:
\itemize{
\item \code{khat}: estimated Pareto k shape parameter, and optionally
\item \code{min_ss}: minimum sample size for reliable Pareto smoothed
estimate
\item \code{khat_threshold}: sample size specific khat threshold for
reliable Pareto smoothed estimates
\item \code{convergence_rate}: Relative convergence rate for
Pareto smoothed estimates
}

If any of the draws is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or
\code{-Inf}, Pareto smoothing will not be performed, and the original
draws will be returned and and diagnostics will be \code{NA} (numeric).
}
\description{
Smooth the tail draws of x by replacing tail draws by order
statistics of a generalized Pareto distribution fit to the
tail(s). For further details see Vehtari et al. (2024).
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
pareto_smooth(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
pareto_smooth(d$Sigma)
}
\references{
Aki Vehtari, Daniel Simpson, Andrew Gelman, Yuling Yao and
Jonah Gabry (2024). Pareto Smoothed Importance Sampling.
\emph{Journal of Machine Learning Research}, 25(72):1-58.
\href{https://jmlr.org/papers/v25/19-556.html}{PDF}
}
\seealso{
\code{\link{pareto_khat}} for only calculating khat, and
\code{\link{pareto_diags}} for additional diagnostics.
}
