% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-m+.r
\name{rollbackward}
\alias{rollbackward}
\alias{rollback}
\alias{rollforward}
\title{Roll backward or forward a date the previous, current or next month}
\usage{
rollbackward(dates, roll_to_first = FALSE, preserve_hms = TRUE)

rollback(dates, roll_to_first = FALSE, preserve_hms = TRUE)

rollforward(dates, roll_to_first = FALSE, preserve_hms = TRUE)
}
\arguments{
\item{dates}{A POSIXct, POSIXlt or Date class object.}

\item{roll_to_first}{Rollback to the first day of the month instead of the
last day of the month}

\item{preserve_hms}{Retains the same hour, minute, and second information? If
FALSE, the new date will be at 00:00:00.}
}
\value{
A date-time object of class POSIXlt, POSIXct or Date, whose day has
been adjusted to the last day of the previous month, or to the first day of
the month.
}
\description{
\code{rollbackward()} changes a date to the last day of the previous month or to
the first day of the month. \code{rollforward()} rolls to the last day of the
current month or to the first day of the next month. Optionally, the new date
can retain the same hour, minute, and second information. \code{rollback()} is a
synonym for \code{rollbackward()}.
}
\examples{
date <- ymd("2010-03-03")
rollbackward(date)

dates <- date + months(0:2)
rollbackward(dates)

date <- ymd_hms("2010-03-03 12:44:22")
rollbackward(date)
rollbackward(date, roll_to_first = TRUE)
rollbackward(date, preserve_hms = FALSE)
rollbackward(date, roll_to_first = TRUE, preserve_hms = FALSE)
}
