% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elpd.R
\name{elpd}
\alias{elpd}
\alias{elpd.array}
\alias{elpd.matrix}
\title{Generic (expected) log-predictive density}
\usage{
elpd(x, ...)

\method{elpd}{array}(x, ...)

\method{elpd}{matrix}(x, ...)
}
\arguments{
\item{x}{A log-likelihood array or matrix. The \strong{Methods (by class)}
section, below, has detailed descriptions of how to specify the inputs for
each method.}

\item{...}{Currently ignored.}
}
\description{
The \code{elpd()} methods for arrays and matrices can compute the expected log
pointwise predictive density for a new dataset or the log pointwise
predictive density of the observed data (an overestimate of the elpd).
}
\details{
The \code{elpd()} function is an S3 generic and methods are provided for
3-D pointwise log-likelihood arrays and matrices.
}
\section{Methods (by class)}{
\itemize{
\item \code{array}: An \eqn{I} by \eqn{C} by \eqn{N} array, where \eqn{I}
is the number of MCMC iterations per chain, \eqn{C} is the number of
chains, and \eqn{N} is the number of data points.

\item \code{matrix}: An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size
of the posterior sample (with all chains merged) and \eqn{N} is the number
of data points.
}}

\examples{
# Calculate the lpd of the observed data
LLarr <- example_loglik_array()
elpd(LLarr)

}
\seealso{
The vignette \emph{Holdout validation and K-fold cross-validation of Stan
programs with the loo package} for demonstrations of using the \code{elpd()}
methods.
}
