% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routine_registration_linter.R
\name{routine_registration_linter}
\alias{routine_registration_linter}
\title{Identify unregistered native routines}
\usage{
routine_registration_linter()
}
\description{
It is preferable to register routines for efficiency and safety.
}
\examples{
# will produce lints
lint(
  text = '.Call("cpp_routine", PACKAGE = "mypkg")',
  linters = routine_registration_linter()
)

lint(
  text = '.Fortran("f_routine", PACKAGE = "mypkg")',
  linters = routine_registration_linter()
)

# okay
lint(
  text = ".Call(cpp_routine)",
  linters = routine_registration_linter()
)

lint(
  text = ".Fortran(f_routine)",
  linters = routine_registration_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://cran.r-project.org/doc/manuals/r-release/R-exts.html#Registering-native-routines}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=efficiency_linters]{efficiency}, \link[=robustness_linters]{robustness}
}
