% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-compare2.R
\name{dfSigma}
\alias{dfSigma}
\title{Degree of Freedom for the Chi-Square Test}
\usage{
dfSigma(contrast, score, vcov, rvcov, dVcov, dRvcov, keep.param, type)
}
\arguments{
\item{contrast}{[numeric vector] the linear combination of parameters to test}

\item{score}{[numeric matrix] the individual score for each parameter.}

\item{vcov}{[numeric matrix] the model-based variance-covariance matrix of the parameters.}

\item{rvcov}{[numeric matrix] the robust variance-covariance matrix of the parameters.}

\item{dVcov}{[numeric array] the first derivative of the model-based variance-covariance matrix of the parameters.}

\item{dRvcov}{[numeric array] the first derivative of the robust variance-covariance matrix of the parameters.}

\item{keep.param}{[character vector] the name of the parameters with non-zero first derivative of their variance parameter.}

\item{type}{[integer] 1 corresponds to the Satterthwaite approximation of the the degrees of freedom applied to the model-based variance,
2 to the Satterthwaite approximation of the the degrees of freedom applied to the robust variance,
3 to the approximation described in (Pan, 2002) section 2 and 3.1.}
}
\description{
Computation of the degrees of freedom of the chi-squared distribution
relative to the model-based variance
}
\references{
Wei Pan and Melanie M. Wall, Small-sample adjustments in using the sandwich variance estiamtor in generalized estimating equations. Statistics in medicine (2002) 21:1429-1441.
}
