% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_outer.R
\name{f21hyper}
\alias{f21hyper}
\title{Gaussian Hypergeometric Function F(a,b,c,z)}
\usage{
f21hyper(a, b, c, z)
}
\arguments{
\item{a}{The parameter \code{a} of the Gaussian hypergeometric function,
must be a positive scalar here}

\item{b}{The parameter \code{b} of the Gaussian hypergeometric function,
must be a positive scalar here}

\item{c}{The parameter \code{c} of the Gaussian hypergeometric function,
must be a positive scalar here}

\item{z}{The parameter \code{z} of the Gaussian hypergeometric function,
must be between -1 and 1 here}
}
\value{
The value of the Gaussian hypergeometric function \eqn{ F(a,b,c,z) }
}
\description{
Computes the value of a Gaussian hypergeometric function \eqn{ F(a,b,c,z) }
for \eqn{-1 \leq z \leq 1} and \eqn{a,b,c \geq 0}
}
\details{
The function \code{f21hyper} complements the analysis of the 'hyper-g prior'
introduced by Liang et al. (2008).\cr For parameter values, compare cf.
\url{https://en.wikipedia.org/wiki/Hypergeometric_function}.
}
\note{
This function is a simple wrapper function of sped-up code that is
intended for sporadic application by the user; it is neither efficient nor
general; for a more general version cf. the package '\code{hypergeo}'
}
\examples{

  
  f21hyper(30,1,20,.8) #returns about 165.8197
  
  f21hyper(30,10,20,0) #returns one
  
  f21hyper(10,15,20,-0.1) # returns about 0.4872972
}
\references{
Liang F., Paulo R., Molina G., Clyde M., Berger J.(2008):
Mixtures of g-priors for Bayesian variable selection. J. Am. Statist. Assoc.
103, p. 410-423

\url{https://en.wikipedia.org/wiki/Hypergeometric_function}
}
\seealso{
package \code{hypergeo} for a more proficient implementation.

Check \url{http://bms.zeugner.eu} for additional help.
}
\keyword{utilities}
