% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colWeightedSds,xgCMatrix-method}
\alias{colWeightedSds,xgCMatrix-method}
\alias{rowWeightedSds,xgCMatrix-method}
\title{Calculates the weighted standard deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colWeightedSds}{xgCMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  useNames = NA
)

\S4method{rowWeightedSds}{xgCMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  useNames = NA
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted standard deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedSds}
/ \code{matrixStats::colWeightedSds}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  w <- rnorm(n = 5, mean = 3)
  rowWeightedSds(mat, w = w[1:3])
  colWeightedSds(mat, w = w)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedVar]{rowWeightedSds}()} and
\code{matrixStats::\link[matrixStats:weightedVar]{colWeightedSds}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowSds} for the corresponding unweighted function.
}
}
