% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/101-getDrugPubChem.R
\name{getMolFromPubChem}
\alias{getMolFromPubChem}
\title{Retrieve Drug Molecules in MOL Format from the PubChem Database}
\usage{
getMolFromPubChem(id, parallel = 5)
}
\arguments{
\item{id}{A character vector, as the PubChem drug ID.}

\item{parallel}{An integer, the parallel parameter, indicates how many
processes the user would like to use for retrieving
the data (using RCurl), default is \code{5}.
For regular cases, we recommend a number less than \code{20}.}
}
\value{
A length of \code{id} character vector,
each element containing the corresponding drug molecule.
}
\description{
Retrieve Drug Molecules in MOL Format from the PubChem Database
}
\details{
This function retrieves drug molecules in MOL format from the
PubChem database.
}
\examples{
id = c('7847562', '7847563')  # Penicillamine
\donttest{
getMolFromPubChem(id)}
}
\seealso{
See \code{\link{getSmiFromPubChem}} for retrieving drug molecules
in SMILES format from the PubChem database.
}
