% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctCoverageBias.R
\name{correctCoverageBias}
\alias{correctCoverageBias}
\title{Correct for library-specific coverage biases}
\usage{
correctCoverageBias(
  coverage.file,
  interval.file,
  output.file = NULL,
  plot.bias = FALSE,
  plot.max.density = 50000,
  output.qc.file = NULL
)
}
\arguments{
\item{coverage.file}{Coverage file or coverage data parsed with the
\code{\link{readCoverageFile}} function.}

\item{interval.file}{File providing GC content for each exon in the coverage
files. First column in format CHR:START-END. Additional optional columns
provide gene symbols, mappability and replication timing. This file is
generated with the \code{\link{preprocessIntervals}} function.}

\item{output.file}{Optionally, write file with GC corrected coverage. Can be
read with the \code{\link{readCoverageFile}} function.}

\item{plot.bias}{Optionally, plot profiles of the pre-normalized and
post-normalized coverage. Provides a quick visual check of coverage bias.}

\item{plot.max.density}{By default, if the number of intervals in the
probe-set is > 50000, uses a kernel density estimate to plot the coverage
distribution. This uses the \code{stat_density} function from the ggplot2
package. Using this parameter, change the threshold at which density
estimation is applied. If the \code{plot.bias} parameter is set as
\code{FALSE}, this will be ignored.}

\item{output.qc.file}{Write miscellaneous coverage QC metrics to file.}
}
\description{
Takes as input coverage data and a mapping file for GC content and
optionally replication timing. Will then normalize coverage data for
GC-bias.  Plots the pre and post normalization GC profiles.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal.txt",
    package = "PureCN")
interval.file <- system.file("extdata", "example_intervals.txt",
    package = "PureCN")
coverage <- correctCoverageBias(normal.coverage.file, interval.file)

}
\seealso{
\code{\link{preprocessIntervals}}
}
\author{
Angad Singh, Markus Riester
}
