% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mofa.R
\name{run_mofa}
\alias{run_mofa}
\title{Train a MOFA model}
\usage{
run_mofa(object, outfile = NULL, save_data = TRUE, use_basilisk = FALSE)
}
\arguments{
\item{object}{an untrained \code{\link{MOFA}} object}

\item{outfile}{output file for the model (.hdf5 format). If \code{NULL}, a temporary file is created.}

\item{save_data}{logical indicating whether to save the training data in the hdf5 file. 
This is useful for some downstream analysis (mainly functions with the prefix \code{plot_data}), but it can take a lot of disk space.}

\item{use_basilisk}{use \code{basilisk} to automatically install a conda environment with mofapy2 and all dependencies? 
If \code{FALSE} (default), you should specify the right python binary when loading R with \code{reticulate::use_python(..., force=TRUE)}
or the right conda environment with \code{reticulate::use_condaenv(..., force=TRUE)}.}
}
\value{
a trained \code{\link{MOFA}} object
}
\description{
Function to train an untrained \code{\link{MOFA}} object.
}
\details{
This function is called once a MOFA object has been prepared (using \code{\link{prepare_mofa}})
In this step the R package calls the \code{mofapy2} Python package, where model training is performed. \cr
The interface with Python is done with the \code{\link{reticulate}} package. 
If you have several versions of Python installed and R is not detecting the correct one, 
you can change it using \code{reticulate::use_python} when loading the R session. 
Alternatively, you can let us install mofapy2 for you using \code{basilisk} if you set use_basilisk to \code{TRUE}
}
\examples{
# Load data (in data.frame format)
file <- system.file("extdata", "test_data.RData", package = "MOFA2")
load(file) 

# Create the MOFA object
MOFAmodel <- create_mofa(dt)

# Prepare the MOFA object with default options
MOFAmodel <- prepare_mofa(MOFAmodel)

# Run the MOFA model
\dontrun{ MOFAmodel <- run_mofa(MOFAmodel, use_basilisk = TRUE) }
}
