% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmDSprecision.R,
%   R/class_dmSQTLprecision.R
\docType{methods}
\name{plotPrecision}
\alias{plotPrecision}
\alias{plotPrecision,dmDSprecision-method}
\alias{plotPrecision,dmSQTLprecision-method}
\title{Precision versus mean expression plot}
\usage{
plotPrecision(x, ...)

\S4method{plotPrecision}{dmDSprecision}(x)

\S4method{plotPrecision}{dmSQTLprecision}(x)
}
\arguments{
\item{x}{\code{\linkS4class{dmDSprecision}} or 
\code{\linkS4class{dmSQTLprecision}} object.}

\item{...}{Other parameters that can be defined by methods using this 
generic.}
}
\value{
Normally in the differential analysis based on RNA-seq data, such 
  plot has dispersion parameter plotted on the y-axis. Here, the y-axis 
  represents precision since in the Dirichlet-multinomial model this is the 
  parameter that is directly estimated. It is important to keep in mind that
  the precision parameter (gamma0) is inverse proportional to dispersion 
  (theta): theta = 1 / (1 + gamma0). In RNA-seq data, we can typically
  observe a trend where the dispersion decreases (here, precision increases)
  for genes with higher mean expression.
}
\description{
Precision versus mean expression plot
}
\examples{
# --------------------------------------------------------------------------
# Create dmDSdata object 
# --------------------------------------------------------------------------
## Get kallisto transcript counts from the 'PasillaTranscriptExpr' package

library(PasillaTranscriptExpr)
\donttest{
data_dir  <- system.file("extdata", package = "PasillaTranscriptExpr")

## Load metadata
pasilla_metadata <- read.table(file.path(data_dir, "metadata.txt"), 
header = TRUE, as.is = TRUE)

## Load counts
pasilla_counts <- read.table(file.path(data_dir, "counts.txt"), 
header = TRUE, as.is = TRUE)

## Create a pasilla_samples data frame
pasilla_samples <- data.frame(sample_id = pasilla_metadata$SampleName, 
  group = pasilla_metadata$condition)
levels(pasilla_samples$group)

## Create a dmDSdata object
d <- dmDSdata(counts = pasilla_counts, samples = pasilla_samples)

## Use a subset of genes, which is defined in the following file
gene_id_subset <- readLines(file.path(data_dir, "gene_id_subset.txt"))

d <- d[names(d) \%in\% gene_id_subset, ]

# --------------------------------------------------------------------------
# Differential transcript usage analysis - simple two group comparison 
# --------------------------------------------------------------------------

## Filtering
## Check what is the minimal number of replicates per condition 
table(samples(d)$group)

d <- dmFilter(d, min_samps_gene_expr = 7, min_samps_feature_expr = 3,
  min_gene_expr = 10, min_feature_expr = 10)

plotData(d)

## Create the design matrix
design_full <- model.matrix(~ group, data = samples(d))

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d, design = design_full)

plotPrecision(d)

head(mean_expression(d))
common_precision(d)
head(genewise_precision(d))
}
}
\seealso{
\code{\link{plotData}}, \code{\link{plotProportions}},
  \code{\link{plotPValues}}
}
\author{
Malgorzata Nowicka
}
