/***************************************************************************
 *   Copyright (C) 2007-2010 by Vegeta   				   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QTGAIN_H
#define QTGAIN_H

#include <QtGui>
#include "ui_QtGain.h"
#include "Core.h"

class QtGain : public QMainWindow, private Core
{
    Q_OBJECT

public:
    QtGain(QWidget *parent = 0, Qt::WFlags flags = 0);
    ~QtGain();

private:
    Ui::QtGainClass ui;

    QTimer   *Timer;
    QProcess *myProcess;
    QAction  *actionAbout;
    QAction  *actionCancelOperation;
    QAction  *actionShowSettings;
    QAction  *actionQuit;

    void startupInitiations();
    void processOutput();
    void findFiles(const QString &dirName);
    void openDirectoryDialog();
    void loadSettings();
    void saveSettings();
    void ContextmenuSetModus(bool isIdle);
    void showErrors();

public slots:
    void processFiles();
    void showPreferencesDialog();
    void Quit();
    void cancelOperation(){Core::setOperationCanceled(true);}
    void showAboutDialog();
    void updateGUI();

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dropEvent(QDropEvent *event);
    void closeEvent(QCloseEvent *event);
};

#endif // QTGAIN_H
