/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "login2serverdlg.h"

#include <QGridLayout>

Login2ServerDlg::Login2ServerDlg(QStringList* ls, QStringList* ll, QWidget *parent, const QString& addr, const QString& nick)
 : QDialog(parent),
  m_lastServers(ls),
  m_lastLogins(ll),
  m_finished(false)
{
  QGridLayout* grid = new QGridLayout(this);

//   m_ipEdit    = new QLineEdit(addr, this);
//   m_loginEdit = new QLineEdit(nick, this);

  m_ipCmbx    = new QComboBox(this);
  m_loginCmbx = new QComboBox(this);

  m_loginBtn  = new QPushButton(this);
  m_abortBtn  = new QPushButton(this);
  m_ipLab     = new QLabel(this);
  m_loginLab  = new QLabel(this);
  m_descriptionLab = new QLabel(this);

  grid->addWidget(m_ipLab    , 0, 0);
  grid->addWidget(m_ipCmbx   , 0, 1);
  grid->addWidget(m_loginLab , 1, 0);
  grid->addWidget(m_loginCmbx, 1, 1);
  grid->addWidget(m_loginBtn , 2, 0, 1, 2);
  grid->addWidget(m_abortBtn , 2, 0, 1, 2);
  grid->addWidget(m_descriptionLab, 3, 0);

  grid->setColumnStretch(1, 1);

  grid->setColumnMinimumWidth(1, 150);

  m_ipCmbx   ->setEditable(true);
  m_loginCmbx->setEditable(true);

  m_ipCmbx   ->setDuplicatesEnabled(false);
  m_loginCmbx->setDuplicatesEnabled(false);

  foreach(QString s, (*m_lastServers))
//     m_ipCmbx->insertItem(0, s);
    m_ipCmbx->addItem(s);

  int idx;
  if((idx = m_ipCmbx->findText(addr)) >= 0)
    m_ipCmbx->removeItem(idx);

  m_ipCmbx->insertItem(0, addr);

  foreach(QString l, (*m_lastLogins))
//     m_loginCmbx->insertItem(0, l);
    m_loginCmbx->addItem(l);

  if((idx = m_loginCmbx->findText(nick)) >= 0)
    m_loginCmbx->removeItem(idx);

  m_loginCmbx->insertItem(0, nick);

  m_loginCmbx->setCurrentIndex(0);
  m_ipCmbx   ->setCurrentIndex(0);

  m_abortBtn->hide();
  m_descriptionLab->hide();

  retranslate();

  connect(m_loginBtn, SIGNAL(clicked()), this, SLOT(slot_login()));
  connect(m_abortBtn, SIGNAL(clicked()), this, SLOT(abort()));
}


Login2ServerDlg::~Login2ServerDlg()
{
  qDebug("[~Login2ServerDlg]");
}

void Login2ServerDlg::retranslate()
{
  m_ipLab   ->setText(tr("Server IP :"));
  m_loginLab->setText(tr("Nickname :"));
  m_loginBtn->setText(tr("Login"));
  m_abortBtn->setText(tr("Abort"));
  m_descriptionLab->setText("");
}

void Login2ServerDlg::slot_login()
{
  QString server = m_ipCmbx->lineEdit()->text();
  QString login  = m_loginCmbx->lineEdit()->text();

  m_descriptionLab->show();

  if(m_finished)
  {
    accept();
  }
  else
  {
    m_loginBtn->hide();
    m_abortBtn->show();

    m_descriptionLab->setText(tr("Connecting to server..."));

    emit wantLogin(QHostAddress(server), login);

    if(m_lastServers->contains(server))
      m_lastServers->removeAll(server);
    m_lastServers->prepend(server);

    if(m_lastLogins->contains(login))
      m_lastLogins->removeAll(login);
    m_lastLogins->prepend(login);

    QString last;
    int num;

    num = QChatSettings::settings()->intOption("LastServersNum");
    foreach(QString s, *m_lastServers)
    {
      num--;
      last += s;
      if(num < 0)
        break;
      last += "\n";
    }
    QChatSettings::settings()->setOption("LastServers", last);

    last.clear();
    num = QChatSettings::settings()->intOption("LastLoginsNum");
    foreach(QString s, *m_lastLogins)
    {
      num--;
      last += s;
      if(num < 0)
        break;
      last += "\n";
    }
    QChatSettings::settings()->setOption("LastLogins", last);
  }
}

void Login2ServerDlg::abort()
{
  m_loginBtn->show();
  m_abortBtn->hide();

  emit wantAbort();
}

void Login2ServerDlg::loginRejected(const QString& /*reason*/)
{
}

void Login2ServerDlg::loginAccepted(const QString &)
{
}

void Login2ServerDlg::loginFinished(int err, const QString & descr)
{
  if(!err)
  {
    if(!descr.isEmpty())
      m_descriptionLab->setText(descr);
    else
      m_descriptionLab->setText(tr("Login Accepted"));

    m_finished = true;
    m_loginBtn->setText(tr("Ok"));

    m_ipCmbx   ->setEnabled(false);
    m_loginCmbx->setEnabled(false);

    emit loginSuccessful();
  }
  else
    m_descriptionLab->setText(descr);

  m_loginBtn->show();
  m_abortBtn->hide();
}
