
# Release v0.8

We are pleased to announce the release of Screed v0.8. Screed is a database
engine capable of storing and retrieving short-read sequence data and is
designed to be fast and adaptable to different sequence file formats.

This version of Screed contains developer documentation for contributing to the
Screed project and a code of conduct for interacting with other contributors
and project maintainers. Documentation is available at
http://screed.readthedocs.org/en/v0.8/

## New items of note:

This release successfully installs and passes its unit tests on
Ubuntu 14.04 and the latest release of Mac OS X 10 "Yosemite". It
also passes the khmer acceptance tests as per the [eelpond testing
protocol.](https://github.com/dib-lab/literate-resting/blob/master/kp/README.txt)

This release of screed has renamed the 'accuracy' attribute of read records to
'quality;' this API change will need to be adopted by all users wanting to
upgrade to this version. Unlike the khmer project, Screed is not currently
under semantic versioning. It will be with the 1.0 release.

 - Screed now has automatic compression detection via magic bit sniffing
 for gzip and bzip2 compressed files (from @mr-c in dib-lab/khmer#432)
 - Screed now supports streaming of uncompressed FASTA and FASTQ formatted
 nucleotide sequence data. bzip2 compressed FASTA and FASTQ formatted
 nucleotide sequence data can also be streamed but not gzip compressed
 FASTA and FASTQ formatted nucleotide sequence data. (from @mr-c, see
 dib-lab/khmer#633)
 - Screed now has a Changelog, developer documentation and a code of conduct
 (from @ctb, @mr-c, @bocajnotnef in dib-lab/khmer#625)
 - Versions are now autogenerated using git tags via Versioneer (from
 @bocajnotnef in cadceb5)
 - Documentation is now autogenerated using Doxygen (from @mr-c in d8ed05b)

## Notable bugs fixed/issues closed:
 - A khmer script was not accepting reads on the stdin dib-lab/khmer#633
 by @mr-c
 - screed returning the wrong version and breaking dev installs
 dib-lab/khmer#803 by @mr-c


## Known Issues

These are all pre-existing

 - Screed records cannot be sliced requiring un-Pythonic techniques to achieve
 the same behavior. This will be included in a future release. This is being
 tracked in dib-lab/khmer#768
 - Screed self-tests do not use a temporary directory which causes
 tests run from package-based installs to fail. This is being tracked in
 dib-lab/khmer#748
 - Screed does not support gzip file streaming. This is an issue with Python
 2.x and will likely *not* be fixed in future releases. This is being tracked
 in dib-lab/khmer#700
 - Screed is overly tolerant of spaces in fast{a,q} which is against spec. This
 is being tracked in dib-lab/khmer#108

## Contributors

@bocajnotnef @mr-c @brtaylor92 @wrightmhw @kdmurray91 @luizirber @ctb

