#!/usr/bin/env bash

# This script will update the Version field in the spec which is set to 0 by
# default. Useful for local manual rpm builds where the Version needs to be set
# correctly. Run from the git root directory.

set -eo pipefail

# Script is run from git root directory
SPEC_FILE=rpm/podman.spec

LATEST_TAG=$(git tag --sort=creatordate | tail -1)
LATEST_VERSION=$(echo $LATEST_TAG | sed -e 's/^v//')

sed -i "s/^Version:.*/Version: $LATEST_VERSION/" $SPEC_FILE
