# generated by datamodel-codegen:
#   filename:  simple-star-wars.graphql
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from dataclasses import dataclass
from typing import List, Literal, Optional, TypeAlias

Boolean: TypeAlias = bool
"""
The `Boolean` scalar type represents `true` or `false`.
"""


ID: TypeAlias = str
"""
The `ID` scalar type represents a unique identifier, often used to refetch an object or as key for a cache. The ID type appears in a JSON response as a String; however, it is not intended to be human-readable. When expected as an input type, any string (such as `"4"`) or integer (such as `4`) input value will be accepted as an ID.
"""


Int: TypeAlias = int
"""
The `Int` scalar type represents non-fractional signed whole numeric values. Int can represent values between -(2^31) and 2^31 - 1.
"""


String: TypeAlias = str
"""
The `String` scalar type represents textual data, represented as UTF-8 character sequences. The String type is most often used by GraphQL to represent free-form human-readable text.
"""


@dataclass
class Film:
    characters: List[Person]
    characters_ids: List[ID]
    director: String
    episode_id: Int
    id: ID
    opening_crawl: String
    planets: List[Planet]
    planets_ids: List[ID]
    release_date: String
    species: List[Species]
    species_ids: List[ID]
    starships: List[Starship]
    starships_ids: List[ID]
    title: String
    vehicles: List[Vehicle]
    vehicles_ids: List[ID]
    producer: Optional[String] = None
    typename__: Optional[Literal['Film']] = 'Film'


@dataclass
class Person:
    films: List[Film]
    films_ids: List[ID]
    id: ID
    name: String
    species: List[Species]
    species_ids: List[ID]
    starships: List[Starship]
    starships_ids: List[ID]
    vehicles: List[Vehicle]
    vehicles_ids: List[ID]
    birth_year: Optional[String] = None
    eye_color: Optional[String] = None
    gender: Optional[String] = None
    hair_color: Optional[String] = None
    height: Optional[Int] = None
    homeworld: Optional[Planet] = None
    homeworld_id: Optional[ID] = None
    mass: Optional[Int] = None
    skin_color: Optional[String] = None
    typename__: Optional[Literal['Person']] = 'Person'


@dataclass
class Planet:
    films: List[Film]
    films_ids: List[ID]
    id: ID
    name: String
    residents: List[Person]
    residents_ids: List[ID]
    climate: Optional[String] = None
    diameter: Optional[String] = None
    gravity: Optional[String] = None
    orbital_period: Optional[String] = None
    population: Optional[String] = None
    rotation_period: Optional[String] = None
    surface_water: Optional[String] = None
    terrain: Optional[String] = None
    typename__: Optional[Literal['Planet']] = 'Planet'


@dataclass
class Species:
    films: List[Film]
    films_ids: List[ID]
    id: ID
    name: String
    people: List[Person]
    people_ids: List[ID]
    average_height: Optional[String] = None
    average_lifespan: Optional[String] = None
    classification: Optional[String] = None
    designation: Optional[String] = None
    eye_colors: Optional[String] = None
    hair_colors: Optional[String] = None
    language: Optional[String] = None
    skin_colors: Optional[String] = None
    typename__: Optional[Literal['Species']] = 'Species'


@dataclass
class Starship:
    films: List[Film]
    films_ids: List[ID]
    id: ID
    name: String
    pilots: List[Person]
    pilots_ids: List[ID]
    MGLT: Optional[String] = None
    cargo_capacity: Optional[String] = None
    consumables: Optional[String] = None
    cost_in_credits: Optional[String] = None
    crew: Optional[String] = None
    hyperdrive_rating: Optional[String] = None
    length: Optional[String] = None
    manufacturer: Optional[String] = None
    max_atmosphering_speed: Optional[String] = None
    model: Optional[String] = None
    passengers: Optional[String] = None
    starship_class: Optional[String] = None
    typename__: Optional[Literal['Starship']] = 'Starship'


@dataclass
class Vehicle:
    films: List[Film]
    films_ids: List[ID]
    id: ID
    name: String
    pilots: List[Person]
    pilots_ids: List[ID]
    cargo_capacity: Optional[String] = None
    consumables: Optional[String] = None
    cost_in_credits: Optional[String] = None
    crew: Optional[String] = None
    length: Optional[String] = None
    manufacturer: Optional[String] = None
    max_atmosphering_speed: Optional[String] = None
    model: Optional[String] = None
    passengers: Optional[String] = None
    vehicle_class: Optional[String] = None
    typename__: Optional[Literal['Vehicle']] = 'Vehicle'
