# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EmailTemplateParametersContractProperties(Model):
    """Email Template Parameter contract.

    :param name: Template parameter name.
    :type name: str
    :param title: Template parameter title.
    :type title: str
    :param description: Template parameter description.
    :type description: str
    """

    _validation = {
        'name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'title': {'max_length': 4096, 'min_length': 1},
        'description': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EmailTemplateParametersContractProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
