# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeployServicePackageToNodeDescription(Model):
    """Defines description for downloading packages associated with a service
    manifest to image cache on a Service Fabric node.
    .

    :param service_manifest_name: The name of service manifest whose packages
     need to be downloaded.
    :type service_manifest_name: str
    :param application_type_name:
    :type application_type_name: str
    :param application_type_version:
    :type application_type_version: str
    :param node_name:
    :type node_name: str
    :param package_sharing_policy:
    :type package_sharing_policy: list of :class:`PackageSharingPolicyInfo
     <azure.servicefabric.models.PackageSharingPolicyInfo>`
    """ 

    _validation = {
        'service_manifest_name': {'required': True},
        'application_type_name': {'required': True},
        'application_type_version': {'required': True},
        'node_name': {'required': True},
    }

    _attribute_map = {
        'service_manifest_name': {'key': 'ServiceManifestName', 'type': 'str'},
        'application_type_name': {'key': 'ApplicationTypeName', 'type': 'str'},
        'application_type_version': {'key': 'ApplicationTypeVersion', 'type': 'str'},
        'node_name': {'key': 'NodeName', 'type': 'str'},
        'package_sharing_policy': {'key': 'PackageSharingPolicy', 'type': '[PackageSharingPolicyInfo]'},
    }

    def __init__(self, service_manifest_name, application_type_name, application_type_version, node_name, package_sharing_policy=None):
        self.service_manifest_name = service_manifest_name
        self.application_type_name = application_type_name
        self.application_type_version = application_type_version
        self.node_name = node_name
        self.package_sharing_policy = package_sharing_policy
