# -*- coding: utf-8 -*-
import classes.level_controller as lc
import classes.game_driver as gd
import classes.extras as ex

import pygame

import classes.board
import random

class Board(gd.BoardGame):
    def __init__(self, mainloop, speaker, config,  screen_w, screen_h):
        self.level = lc.Level(self,mainloop,99,4)
        gd.BoardGame.__init__(self,mainloop,speaker,config,screen_w,screen_h,5,3)
        
        
    def create_game_objects(self, level = 1):
        #create non-movable objects

        white = ((255,255,255))
        if self.level.lvl == 1:
            choice = [x for x in range(0,21)]
            self.color_choice = [self.d["white"],self.d["black"],self.d["grey"],self.d["red"],self.d["orange"],self.d["yellow"],self.d["olive"],self.d["green"],self.d["sea green"],self.d["teal"],self.d["blue"],self.d["navy"],self.d["purple"],self.d["violet"],self.d["magenta"],self.d["indigo"],self.d["pink"],self.d["maroon"],self.d["brown"],self.d["aqua"],self.d["lime"]]
            #self.color_choice= ["white",    "black",      "grey",       "red",     "orange",  "yellow",   "olive",    "green",  "sea green","teal",     "blue",   "navy",   "purple",   "violet",     "magenta",  "indigo",  "pink"       "maroon",  "brown",     "aqua",      "lime" ]
            self.hue_choice = [[255,255,255],[2,2,2],      [140,140,140],[255,0,0],[255,138,0],[255,255,0],[181,219,3],[0,160,0],[41,131,82],[0,130,133],[0,0,255],[0,0,132],[132,0,132],[239,131,239],[255,0,255],[74,0,132],[255,20,138],[132,0,0], [140,69,16], [0,255,255], [0,255,0]]
            self.hue_choice2 =[[150,150,150],[100,100,100],[100,100,100],[200,0,0],[200,80,0], [200,200,0],[121,159,3],[0,100,0],[31,100,52],[0,90,90],  [0,0,200],[0,0,82], [92,0,92],  [189,81,189], [200,0,200],[44,0,82], [200,10,88], [100,0,0], [100,39,6],  [0,200,200], [0,200,0]]
            self.font_color  =[[0,0,0],      [225,225,225],[0,0,0],      [100,0,0],[100,40,0], [100,100,0],[60,80,3],  [0,50,0],[11,50,22], [0,40,40],  [0,0,100],[0,0,255],[255,0,255],[95,41,95],   [100,0,100],[140,0,255],[100,5,48],  [200,50,50],  [200,100,26],  [0,155,155], [0,155,0]]
            self.init_font_color = [[230,230,230],[2,2,2],      [140,140,140],[255,0,0],[255,138,0],[255,255,0],[181,219,3],[0,160,0],[41,131,82],[0,130,133],[0,0,255],[0,0,132],[132,0,132],[239,131,239],[255,0,255],[74,0,132],[255,20,138],[132,0,0], [140,69,16], [0,255,255], [0,255,0]]

        elif self.level.lvl == 2:
            choice = [x for x in range(0,13)]
            self.color_choice = [self.d["white"],self.d["black"],self.d["grey"],self.d["red"],self.d["orange"],self.d["yellow"],self.d["olive"],self.d["green"],self.d["blue"],self.d["navy"],self.d["purple"],self.d["pink"],self.d["brown"]]
            #self.color_choice= ["white",    "black",      "grey",      "red",     "orange",   "yellow",   "olive",    "green",  "blue",    "navy",   "purple",   "pink"]
            self.hue_choice = [[255,255,255],[2,2,2],      [140,140,140],[255,0,0],[255,138,0],[255,255,0],[181,219,3],[0,160,0],[0,0,255], [0,0,132],[132,0,132],[255,20,138],[140,69,16]]
            self.hue_choice2 =[[150,150,150],[100,100,100],[100,100,100],[200,0,0],[200,80,0], [200,200,0],[121,159,3],[0,100,0],[0,0,200], [0,0,82], [92,0,92],  [200,10,88],[100,39,6]]
            self.font_color  =[[0,0,0],      [225,225,225],[0,0,0],      [100,0,0],[100,40,0], [100,100,0],[60,80,3],  [0,50,0],[0,0,100], [0,0,255],[255,0,255],[100,5,48],[200,100,26]]
            self.init_font_color = [[0,0,0] for i in range(13)]
        elif self.level.lvl >= 3:
            choice = [x for x in range(0,21)]
            self.color_choice = [self.d["white"],self.d["black"],self.d["grey"],self.d["red"],self.d["orange"],self.d["yellow"],self.d["olive"],self.d["green"],self.d["sea green"],self.d["teal"],self.d["blue"],self.d["navy"],self.d["purple"],self.d["violet"],self.d["magenta"],self.d["indigo"],self.d["pink"],self.d["maroon"],self.d["brown"],self.d["aqua"],self.d["lime"]]
            #self.color_choice= ["white",    "black",      "grey",       "red",     "orange",  "yellow",   "olive",    "green",  "sea green","teal",     "blue",   "navy",   "purple",   "violet",     "magenta",  "indigo",  "pink"       "maroon",  "brown",     "aqua",      "lime" ]
            self.hue_choice = [[255,255,255],[2,2,2],      [140,140,140],[255,0,0],[255,138,0],[255,255,0],[181,219,3],[0,160,0],[41,131,82],[0,130,133],[0,0,255],[0,0,132],[132,0,132],[239,131,239],[255,0,255],[74,0,132],[255,20,138],[132,0,0], [140,69,16], [0,255,255], [0,255,0]]
            self.hue_choice2 =[[150,150,150],[100,100,100],[100,100,100],[200,0,0],[200,80,0], [200,200,0],[121,159,3],[0,100,0],[31,100,52],[0,90,90],  [0,0,200],[0,0,82], [92,0,92],  [189,81,189], [200,0,200],[44,0,82], [200,10,88], [100,0,0], [100,39,6],  [0,200,200], [0,200,0]]
            self.font_color  =[[0,0,0],      [225,225,225],[0,0,0],      [100,0,0],[100,40,0], [100,100,0],[60,80,3],  [0,50,0],[11,50,22], [0,40,40],  [0,0,100],[0,0,255],[255,0,255],[95,41,95],   [100,0,100],[140,0,255],[100,5,48],  [200,50,50],  [200,100,26],  [0,155,155], [0,155,0]]
            self.init_font_color = [[0,0,0] for i in range(21)]
        data = [5,3]
        
        if self.lang.lang in ["en_gb","en_us"]:
            font_size = 10
        else:
            font_size = 11
        #stretch width to fit the screen size
        max_x_count = self.get_x_count(data[1],even=False)
        if max_x_count > 5:
            data[0] = max_x_count
            
        self.data = data
        self.center = self.data[0] // 2
        self.vis_buttons = [1,1,1,1,1,1,1,0,0]
        self.mainloop.info.hide_buttonsa(self.vis_buttons)
        
        self.layout.update_layout(data[0],data[1])
        scale = self.layout.scale
        self.board.level_start(data[0],data[1],scale)
        shuffled = choice[:]
        random.shuffle(shuffled)
        self.chosen = shuffled[0:5]
        
        self.shuffled2 = self.chosen[:]
        random.shuffle(self.shuffled2)
        x = self.center - 2
        for i in range(5):
            self.board.add_door(x+i,0,1,1,classes.board.Door,self.color_choice[self.chosen[i]],white)
            self.board.add_unit(x+i,2,1,1,classes.board.Letter,self.color_choice[self.shuffled2[i]],white,"",font_size)
            font_color = self.init_font_color[self.shuffled2[i]]
            if self.level.lvl == 1:
                self.board.ships[i].font_color = font_color
            elif self.level.lvl == 4:
                self.board.ships[i].readable = False

        for each in self.board.ships:
            self.board.all_sprites_list.move_to_front(each) 
            each.highlight = False
            each.outline_highlight = True
            each.set_outline([180,180,250],1)
            
        for each in self.board.units:
            each.outline = False
            each.show_value = False

        #splash polygon - unscalled - size 200x200
        lines = [[135, 128],[133, 132],[135, 137],[157, 157],[158, 161],[155, 165],[150, 166],[146, 163],[133, 140],[129, 138],[125, 139],
            [122, 142],[122, 144],[128, 157],[128, 159],[126, 161],[123, 161],[121, 160],[114, 147],[112, 145],[107, 145],[104, 148],
            [104, 154],[110, 179],[111, 186],[110, 192],[105, 194],[100, 193],[98, 188],[98, 180],[101, 154],[100, 148],[96, 146],
            [93, 147],[92, 149],[88, 163],[86, 165],[83, 165],[80, 164],[80, 161],[80, 158],[83, 147],[82, 143],[73, 139],
            [65, 143],[55, 167],[52, 174],[48, 179],[42, 178],[37, 174],[38, 169],[43, 163],[57, 151],[63, 144],[67, 137],
            [66, 129],[60, 126],[51, 138],[47, 141],[44, 142],[40, 140],[38, 136],[40, 134],[44, 131],[57, 124],[56, 117],
            [51, 114],[43, 120],[40, 122],[38, 124],[36, 124],[34, 122],[34, 119],[36, 117],[50, 111],[52, 108],[53, 102],
            [51, 98],[46, 96],[38, 97],[11, 103],[5, 103],[3, 99],[4, 94],[10, 92],[36, 94],[44, 94],[50, 91],
            [53, 87],[52, 83],[46, 81],[21, 79],[14, 78],[9, 76],[8, 73],[10, 71],[15, 71],[22, 72],[45, 77],
            [51, 77],[53, 74],[52, 69],[40, 60],[39, 57],[39, 55],[41, 53],[44, 53],[47, 54],[55, 59],[58, 59],
            [61, 58],[62, 55],[61, 52],[54, 43],[54, 41],[55, 38],[58, 37],[61, 39],[71, 51],[74, 52],[80, 50],
            [81, 46],[80, 40],[77, 32],[66, 18],[62, 12],[61, 6],[65, 3],[70, 2],[74, 6],[76, 13],[79, 30],
            [81, 37],[86, 42],[91, 43],[95, 41],[95, 39],[93, 28],[93, 25],[93, 23],[96, 22],[99, 22],[100, 24],
            [100, 28],[99, 39],[101, 41],[103, 42],[106, 42],[108, 40],[111, 29],[112, 26],[114, 25],[117, 24],[119, 26],
            [120, 29],[119, 33],[116, 45],[117, 48],[119, 50],[122, 50],[135, 33],[137, 31],[140, 31],[142, 34],[142, 37],
            [133, 53],[133, 56],[134, 59],[137, 59],[141, 56],[155, 40],[160, 36],[164, 35],[169, 38],[170, 42],[168, 46],
            [163, 50],[146, 59],[144, 62],[145, 66],[149, 67],[160, 64],[162, 63],[164, 64],[165, 66],[165, 69],[164, 71],
            [150, 77],[148, 79],[148, 84],[150, 88],[155, 89],[173, 81],[179, 79],[183, 79],[185, 83],[186, 90],[184, 93],
            [180, 95],[175, 94],[158, 95],[154, 99],[153, 103],[156, 106],[163, 108],[185, 113],[190, 115],[191, 118],[189, 122],
            [184, 121],[163, 111],[156, 109],[151, 110],[147, 115],[145, 120],[146, 124],[151, 128],[163, 135],[168, 139],[171, 142],
            [171, 146],[167, 146],[162, 144],[158, 140],[149, 132],[144, 128],[140, 127]]
        size = self.board.units[0].grid_w*self.board.scale     
        #new point = size * orig_point / 200
        self.scaled_lines = [[int(size * each[0] / 200.0), int(size * each[1] / 200.0)] for each in lines]
        for i in range(5):
            #h = random.randrange(0, 255)
            color1 = self.hue_choice[self.chosen[i]] #ex.hsv_to_rgb(h,s,v)
            color2 = self.hue_choice2[self.chosen[i]] #ex.hsv_to_rgb(h,255,255)
            canvas = pygame.Surface([size, size-1])
            canvas.fill(self.board.units[i].initcolor)
            self.draw_splash(canvas,size,color1,color2)#data[7](data, canvas, i)
            self.board.units[i].painting = canvas.copy()
            
    def draw_splash(self,canvas,size,color,outline_color):
        pygame.draw.polygon(canvas, color, self.scaled_lines,0)
        pygame.draw.aalines(canvas, outline_color, True, self.scaled_lines)
            
    def handle(self,event):
        gd.BoardGame.handle(self, event) #send event handling up
        if event.type == pygame.MOUSEMOTION:
            if self.drag and self.mouse_entered_new:
                self.swap_font_color()

    def after_keydown_move(self):
        #in case somebody uses keyboard to move the labels
        self.swap_font_color()
        
    def swap_font_color(self):
        active_ship = self.board.ships[self.board.active_ship]
        if active_ship.grid_y == 0:
            active_ship.initcolor = self.hue_choice[self.chosen[active_ship.grid_x]]
            active_ship.color = active_ship.initcolor
            #background 'door'
            #bgd = self.hue_choice[self.chosen[active_ship.grid_x]]
            #if bgd in [[2,2,2],[0,0,132],[132,0,132],[74,0,132]]:
            active_ship.font_color = self.font_color[self.chosen[active_ship.grid_x]] #(255,85,85,0)
            #else:
            #    active_ship.font_color = (0,0,0,0)
        else:
            active_ship.initcolor = [255,255,255]
            active_ship.color = active_ship.initcolor
            if self.level.lvl == 1:
                active_ship.font_color = self.init_font_color[self.shuffled2[self.board.active_ship]]
            else:
                active_ship.font_color = (0,0,0,0)
        active_ship.image.set_colorkey(active_ship.initcolor)
        active_ship.update_me = True
        
    def update(self,game):
        game.fill((255,255,255))
        gd.BoardGame.update(self, game) #rest of painting done by parent

    def check_result(self):
        if self.changed_since_check:
            #checking copied from number sorting game and re-done
            if self.board.grid[0][self.center-2:self.center+3] == [1,1,1,1,1]: #self.solution_grid:
                ships = []
                units = []
                #collect value and x position on the grid from ships list
                for i in range(5):
                    ships.append([self.board.ships[i].grid_x, self.board.ships[i].value])
                    units.append([self.board.units[i].grid_x, self.board.units[i].value])
                #ships_sorted = sorted(ships)
                ships.sort()
                units.sort()
                correct = True
                for i in range(5):
                    if i < 4:
                        if ships[i][1] != units[i][1]:
                            correct = False
                if correct == True:
                    self.level.next_board()
                else:
                    self.say(self.d["Sorry! It is wrong."])
                    self.level.try_again()
                    self.changed_since_check = False
            else:
                self.level.try_again(True)