# Copyright 2004-2008 Roman Yakovenko.
# Distributed under the Boost Software License, Version 1.0. (See
# accompanying file LICENSE_1_0.txt or copy at
# http://www.boost.org/LICENSE_1_0.txt)

import unittest
import autoconfig
import parser_test_case

from pygccxml import utils
from pygccxml import parser
from pygccxml import declarations

class tester_t( parser_test_case.parser_test_case_t ):
    def __init__(self, *args ):
        parser_test_case.parser_test_case_t.__init__( self, *args )
        self.header = 'plain_c.c'
        self.global_ns = None
        
    def setUp(self):
        if not self.global_ns:
            decls = parser.parse( [self.header], self.config )
            self.global_ns = declarations.get_global_namespace( decls )
            self.global_ns.init_optimizer()
            
    def test( self ):                
        self.global_ns.free_fun( 'hello_sum' )
        self.global_ns.free_fun( 'hello_print' )
        declarations.print_declarations( self.global_ns )
        f = self.global_ns.free_fun( 'do_smth' )
        for arg in f.arguments:
            print arg.type.decl_string
        
def create_suite():
    suite = unittest.TestSuite()        
    suite.addTest( unittest.makeSuite(tester_t))
    return suite

def run_suite():
    unittest.TextTestRunner(verbosity=2).run( create_suite() )

if __name__ == "__main__":
    run_suite()
