# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Resource types

* [`zfs`](#zfs): Manage zfs. Create destroy and set properties on zfs instances.
* [`zpool`](#zpool): Manage zpools. Create and delete zpools. The provider WILL NOT SYNC, only report differences.

## Resource types

### <a name="zfs"></a>`zfs`

**Autorequires:** If Puppet is managing the zpool at the root of this zfs
instance, the zfs resource will autorequire it. If Puppet is managing any
parent zfs instances, the zfs resource will autorequire them.

#### Examples

##### Using zfs.

```puppet
zfs { 'tstpool':
  ensure => present,
}
```

#### Properties

The following properties are available in the `zfs` type.

##### `aclinherit`

The aclinherit property. Valid values are `discard`, `noallow`, `restricted`, `passthrough`, `passthrough-x`.

##### `aclmode`

The aclmode property. Valid values are `discard`, `groupmask`, `passthrough`.

##### `acltype`

The acltype propery. Valid values are 'noacl' and 'posixacl'. Only supported on Linux.

##### `atime`

The atime property. Valid values are `on`, `off`.

##### `canmount`

The canmount property. Valid values are `on`, `off`, `noauto`.

##### `checksum`

The checksum property. Valid values are `on`, `off`, `fletcher2`, `fletcher4`, `sha256`.

##### `compression`

The compression property. Valid values are `on`, `off`, `lzjb`, `gzip`, `gzip-[1-9]`, `zle`.

##### `copies`

The copies property. Valid values are `1`, `2`, `3`.

##### `dedup`

The dedup property. Valid values are `on`, `off`.

##### `defaultuserquota`

The defaultuserquota property. Valid values are `<size>`, `none`.

##### `devices`

The devices property. Valid values are `on`, `off`.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

##### `exec`

The exec property. Valid values are `on`, `off`.

##### `logbias`

The logbias property. Valid values are `latency`, `throughput`.

##### `mountpoint`

The mountpoint property. Valid values are `<path>`, `legacy`, `none`.

##### `nbmand`

The nbmand property. Valid values are `on`, `off`.

##### `overlay`

The overlay property. Valid values are `on`, `off`.

##### `primarycache`

The primarycache property. Valid values are `all`, `none`, `metadata`.

##### `quota`

The quota property. Valid values are `<size>`, `none`.

##### `readonly`

The readonly property. Valid values are `on`, `off`.

##### `recordsize`

The recordsize property. Valid values are powers of two between 512 and 128k.

##### `refquota`

The refquota property. Valid values are `<size>`, `none`.

##### `refreservation`

The refreservation property. Valid values are `<size>`, `none`.

##### `relatime`

The relatime property. Valid values are `on`, `off`. Only supported on Linux

##### `reservation`

The reservation property. Valid values are `<size>`, `none`.

##### `secondarycache`

The secondarycache property. Valid values are `all`, `none`, `metadata`.

##### `setuid`

The setuid property. Valid values are `on`, `off`.

##### `shareiscsi`

The shareiscsi property. Valid values are `on`, `off`, `type=<type>`.

##### `sharenfs`

The sharenfs property. Valid values are `on`, `off`, share(1M) options

##### `sharesmb`

The sharesmb property. Valid values are `on`, `off`, sharemgr(1M) options

##### `snapdir`

The snapdir property. Valid values are `hidden`, `visible`.

##### `sync`

The sync property. Valid values are `standard`, `always`, `disabled`.

##### `version`

The version property. Valid values are `1`, `2`, `3`, `4`, `current`.

##### `volsize`

The volsize property. Valid values are `<size>`

##### `vscan`

The vscan property. Valid values are `on`, `off`.

##### `xattr`

The xattr property. Valid values are `on`, `off`.

##### `zoned`

The zoned property. Valid values are `on`, `off`.

#### Parameters

The following parameters are available in the `zfs` type.

* [`name`](#-zfs--name)
* [`provider`](#-zfs--provider)

##### <a name="-zfs--name"></a>`name`

namevar

The full name for this filesystem (including the zpool).

##### <a name="-zfs--provider"></a>`provider`

The specific backend to use for this `zfs` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

### <a name="zpool"></a>`zpool`

Supports vdevs with mirrors, raidz, logs, spares, and cache.

#### Examples

##### Using zpool.

```puppet
zpool { 'tstpool':
  ensure => present,
  disk   => '/ztstpool/dsk',
}
```

#### Properties

The following properties are available in the `zpool` type.

##### `ashift`

The Alignment Shift for the vdevs in the given pool.

##### `autoexpand`

The autoexpand setting for the given pool. Valid values are `on` or `off`

##### `cache`

Cache disks for this pool.

##### `disk`

The disk(s) for this pool. Can be an array or a space separated string.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

##### `failmode`

The failmode setting for the given pool. Valid values are `wait`, `continue` or `panic`

##### `log`

Log disks for this pool. This type does not currently support mirroring of log disks.

##### `mirror`

List of all the devices to mirror for this pool. Each mirror should be a
space separated string:

    mirror => [\"disk1 disk2\", \"disk3 disk4\"],

##### `raidz`

List of all the devices to raid for this pool. Should be an array of
space separated strings:

    raidz => [\"disk1 disk2\", \"disk3 disk4\"],

##### `spare`

Spare disk(s) for this pool.

#### Parameters

The following parameters are available in the `zpool` type.

* [`pool`](#-zpool--pool)
* [`provider`](#-zpool--provider)
* [`raid_parity`](#-zpool--raid_parity)

##### <a name="-zpool--pool"></a>`pool`

namevar

The name for this pool.

##### <a name="-zpool--provider"></a>`provider`

The specific backend to use for this `zpool` resource. You will seldom need to specify this --- Puppet will usually
discover the appropriate provider for your platform.

##### <a name="-zpool--raid_parity"></a>`raid_parity`

Determines parity when using the `raidz` parameter.

