#!perl -w
use v5.10.1;
my $v = $ENV{VERSION} // die 'VERSION unset';
my $f = './lib/PublicInbox.pm';
if (-d ($ENV{GIT_DIR} // '.git') || -f '.git') {
	chomp(my $gv = `git describe --match "v[0-9]*" HEAD`);
	if ($? == 0) {
		substr($gv, 0, 1, ''); # remove "v"
		system(qw(git update-index -q --refresh));
		if (my @n = `git diff-index --name-only HEAD --`) {
			$gv .= '-dirty';
		}
		$v = $gv;
	}
}
$v =~ tr/-/./;
if (-f $f && do $f && (eval('$PublicInbox::VERSION') // 'undef') eq $v) {
	exit
}
my $tmp = "$f.tmp.$$";
open my $fh, '>', $tmp  or die "open($tmp): $!";
print $fh <<EOM or die "print($tmp): $!";
# this file is generated by $0
package PublicInbox;
our \$VERSION = '$v';
1;
EOM
close $fh or die "close($tmp): $!";
rename($tmp, $f) or die "rename($tmp, $f): $!";
