/*
            Copyright Oliver Kowalke 2009.
   Distributed under the Boost Software License, Version 1.0.
      (See accompanying file LICENSE_1_0.txt or copy at
          http://www.boost.org/LICENSE_1_0.txt)
*/

/*******************************************************************
 *                                                                 *
 *  -------------------------------------------------------------  *
 *  |  0  |  1  |  2  |  3  |  4  |  5  |  6  |  7  |  8  |  9  |  *
 *  -------------------------------------------------------------  *
 *  |  0  |  4  |   8 |  12 |  16 |  20 |  24 |  28 |  32 |  36 |  *
 *  -------------------------------------------------------------  *
 *  |    R13    |    R14    |    R15    |    R16    |    R17    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  10 |  11 |  12 |  13 |  14 |  15 |  16 |  17 |  18 |  19 |  *
 *  -------------------------------------------------------------  *
 *  |  40 |  44 |  48 |  52 |  56 |  60 |  64 |  68 |  72 |  76 |  *
 *  -------------------------------------------------------------  *
 *  |    R18    |    R19    |    R20    |    R21    |    R22    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  20 |  21 |  22 |  23 |  24 |  25 |  26 |  27 |  28 |  29 |  *
 *  -------------------------------------------------------------  *
 *  |  80 |  84 |  88 |  92 |  96 | 100 | 104 | 108 | 112 | 116 |  *
 *  -------------------------------------------------------------  *
 *  |    R23    |    R24    |    R25    |    R26    |    R27    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  30 |  31 |  32 |  33 |  34 |  35 |  36 |  37 |  38 |  39 |  *
 *  -------------------------------------------------------------  *
 *  | 120 | 124 | 128 | 132 | 136 | 140 | 144 | 148 | 152 | 156 |  *
 *  -------------------------------------------------------------  *
 *  |    R28    |    R29    |    R30    |    R31    |     SP    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  40 |  41 |  42 |  43 |  44 |  45 |                       |  *
 *  -------------------------------------------------------------  *
 *  | 160 | 164 | 168 | 172 | 176 | 180 |                       |  *
 *  -------------------------------------------------------------  *
 *  |    CR     |    LR     |     PC    |                       |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  46 |  47 |  48 |  49 |                                   |  *
 *  -------------------------------------------------------------  *
 *  | 184 | 188 | 192 | 196 |                                   |  *
 *  -------------------------------------------------------------  *
 *  |    sp     |    size   |                                   |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  50 |  51 |  52 |  53 |  54 |  55 |  56 |  57 |  58 |  59 |  *
 *  -------------------------------------------------------------  *
 *  | 200 | 204 | 208 | 212 | 216 | 220 | 224 | 228 | 232 | 236 |  *
 *  -------------------------------------------------------------  *
 *  |    F14    |    F15    |    F16    |    F17    |    F18    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  60 |  61 |  62 |  63 |  64 |  65 |  66 |  67 |  68 |  69 |  *
 *  -------------------------------------------------------------  *
 *  | 240 | 244 | 248 | 252 | 256 | 260 | 264 | 268 | 272 | 276 |  *
 *  -------------------------------------------------------------  *
 *  |    F19    |    F20    |    F21    |    F22    |    F23    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  70 |  71 |  72 |  73 |  74 |  75 |  76 |  77 |  78 |  79 |  *
 *  -------------------------------------------------------------  *
 *  | 280 | 284 | 288 | 292 | 296 | 300 | 304 | 308 | 312 | 316 |  *
 *  -------------------------------------------------------------  *
 *  |    F24    |    F25    |    F26    |    F27    |    F28    |  *
 *  -------------------------------------------------------------  *
 *  -------------------------------------------------------------  *
 *  |  80 |  81 |  82 |  83 |  84 |  85 |  86 |  87 |           |  *
 *  -------------------------------------------------------------  *
 *  | 320 | 324 | 328 | 332 | 336 | 340 | 344 | 348 |           |  *
 *  -------------------------------------------------------------  *
 *  |    F29    |    F30    |    F31    |   fpscr   |           |  *
 *  -------------------------------------------------------------  *
 *                                                                 *
 * *****************************************************************/

.section ".text"
.align 2
.globl make_fcontext
.section ".opd","aw"
.align 3
make_fcontext:
.quad .make_fcontext,.TOC.@tocbase,0
.previous
.size make_fcontext,24
.type .make_fcontext,@function
.globl .make_fcontext
.make_fcontext:
    mflr    %r6                 # save return address into R6

    mr      %r0, %r3
    subi    %r3, %r3, 352       # reserve space for fcontext_t at top of context stack

    # call align_stack, R3 contains address at 16 byte boundary after return
    # == pointer to fcontext_t and address of context stack
    rlwinm  %r3, %r3, 0, 0, 59

    std     %r0, 184(%r3)       # save address of context stack (base) in fcontext_t
    std     %r4, 192(%r3)       # save context stack size in fcontext_t
    std     %r5, 176(%r3)       # save address of context function in fcontext_t

    subf    %r0, %r3, 64        # 64 bytes on stack for parameter area (== 8 registers)
    std     %r0, 152(%r3)       # save the stack base

    mflr    %r0                 # load LR
    bl      1f                  # jump to label 1
1:
    mflr    %r4                      # load LR into R4
    addi    %r4, %r4, finish - 1b    # compute abs address of label finish
    mtlr    %r0                      # restore LR
    std     %r4, 168(%r3)            # save address of finish as return address for context function
                                     # entered after context function returns

    mtlr    %r6                 # restore return address from R6

    blr

finish:
    # SP points to same address as SP on entry of context function
    mflr    %r0                 # save return address into R0
    stw     %r0, 8(%r1)         # save return address on stack, set up stack frame
    stwu    %r1, -32(%r1)       # allocate stack space, SP % 16 == 0

    li      %r3,  0             # set return value to zero
    bl      _exit@plt           # exit application
.size .make_fcontext, .-.make_fcontext
