/* ftest.cpp: test routine for f_strtod,  the "fast" version of strtod( ).

Copyright (C) 2015, Project Pluto

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.    */

#ifndef __STDC_LIMIT_MACROS
   #define __STDC_LIMIT_MACROS
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ctype.h>

double fast_strtod( const char *iptr, char **endptr);
long double fast_strtold( const char *iptr, char **endptr);



/* Test:  0.491254745145081187E-10         */
/* Test:   0.954953510577925806E-10       */
/* Test:   0.127748118910414607E-13       */
/* Test: 2.981823180648087E+05            */
/* Test: 298182.3180648087            */
/* Test: 3.141592653589793                                          */
/* Test:   -2718281828314159265358979323845                         */
/* Test:   0.0000000000000000000000000000092653589793238450021256   */
/* Test:   92653589793238450021256   */
/* Test:   92653589793238450021256e-52   */
/* Test: -3141592653589793238462643383e-4                           */
/* Test:    junk                                                    */
/* Test:    .                                                       */
/* Test:    e412                                                   */
/* Test:    1e-4096                                                 */
/* Test:    1.41421358e-4950                                                 */
/* Test:    1.41421358e-4949                                                 */
/* Test:    1.41421358e-4945                                                 */
/* Test:    3.1415926535897932384626433832795028841971693993751058209749445923      */
/* Test:    3.1415926535897932384626433832795028841971693993751058209749445923e-4900*/
/* Test:   3.518437208883201171875E+013         */
/* Test:    2.2250738585072012e-308             */
/* Test:0.05065376864981896               */
/*        922337203685477580.80000000000000000        */
/* Test:  .451533215303220532                         */
/* Test:  .464961562509960965                         */
/* Test:  .448278224147506272                         */
/* Test:  .306880572457317885                         */
/* Test:  .618011014061885010                         */
/* Test:  .440552550113019555                         */
/* Test:  .488648477655791644                         */
/* Test:  .325161100776830161                         */
/* Test:  .140129945971314129                         */
/* Test:  .788293086385992290                         */
/* Test:  .008390235246219392                         */
/* Test:  .737746821657699748                         */
/* Test:  .428992319995180993                         */
/* Test:  .907599420231179594                         */
/* Test:  .247116889298627118                         */
/* Test:  .009008046030807000                         */
/* Test:  .578355849381466358                         */
/* Test:  .640469011344893460                         */
/* Test:  .775210855745855218                         */
/* Test:  .491803086364382800                         */
/* Test:  .344010346179003013                         */
/* Test:  .781100370482549103                         */
/* Test:  .038010540706860015                         */
/* Test:  .253532828474506538                         */
/* Test:  .530348560438369345                         */
/* Test:  .749665828622198668                         */
/* Test:  .950354857133938358                         */
/* Test:  .222985980300939989                         */
/* Test:  .901999234192828992                         */
/* Test:  .812869837321831868                         */
/* Test:  .323917174539848911                         */
/* Test:  .468619498574377614                         */
/* Test:  .706348776581847347                         */
/* Test:  .442273877839887278                         */
/* Test:  .654504816972116508                         */
/* Test:  .262680812819800688                         */
/* Test:  .713593409927296594                         */
/* Test:  .053837126528110831                         */
/* Test:  .551835854922126838                         */
/* Test:  .393171029095105170                         */
/* Test:  .656842261653584842                         */
/* Test:  .401915033329052910                         */
/* Test:  .302965868573063968                         */
/* Test:  .594922086951320920                         */
/* Test:  .181707305220814703                         */
/* Test:  .245951032965874950                         */
/* Test:  .290199872128026198                         */
/* Test:  .197685563134331685                         */
/* Test:  .414625509497388625                         */
/* Test:  .490830347206308833                         */
/* Test:  .693692791335831697                         */
/* Test:  .684721529818739725                         */
/* Test:  .196801970547078809                         */
/* Test:  .672558640513340556                         */
/* Test:  .867439321475658433                         */
/* Test:  .238520860842282528                         */
/* Test:  .387981736675923987                         */
/* Test:  .738157347698666153                         */
/* Test:  .486769895394818768                         */
/* Test:  .509506979606151509                         */
/* Test:  .713453682915448456                         */
/* Test:  .175206083175607200                         */
/* Test:  .716991367761410993                         */
/* Test:  .424765514537295765                         */
/* Test:  .486336829838654338                         */
/* Test:  .704986401368489984                         */
/* Test:  .550484503965428485                         */
/* Test:  .551819328395586813                         */
/* Test:  .931871315497875873                         */
/* Test:  .326229426890078224                         */
/* Test:  .209009676675549006                         */
/* Test:  .487212991463397219                         */
/* Test:  .044627433856544624                         */
/* Test:  .906693576732150695                         */
/* Test:  .859369959738614369                         */
/* Test:  .919968202496415962                         */
/* Test:  .964911819589279918                         */
/* Test:  .634609933167997609                         */
/* Test:  .110660389248514663                         */
/* Test:  .827904469931978904                         */
/* Test:  .758021092000868020                         */
/* Test:  .867280732172360287                         */
/* Test:  .098335986103225339                         */
/* Test:  .853104405549185104                         */
/* Test:  .476485724169401487                         */
/* Test:  .880499576625548495                         */
/* Test:  .929309706838757307                         */
/* Test:  .398833170485195831                         */
/* Test:  .785594234301190592                         */
/* Test:  .065913022418731910                         */
/* Test:  .993704597344271705                         */
/* Test:  .260107497670825104                         */
/* Test:  .883450181240245451                         */
/* Test:  .232112212385754112                         */
/* Test:  .533353067653930350                         */
/* Test:  .852369821143168368                         */
/* Test:  .164645075428513640                         */
/* Test:  .862108084090570100                         */
/* Test:  .907027101521916021                         */
/* Test:  .191837063886571830                         */
/* Test:  .344264602262859266                         */
/* Test:  .710260953800199269                         */
/* Test:  .326796096713108790                         */
/* Test:  .199955852483006958                         */
/* Test:  .741270705883551277                         */
/* Test:  .354201674701821206                         */
/* Test:  .319759180628416751                         */
/* Test:  .630375530768250375                         */
/* Test:  .820746006821064740                         */
/* Test:  .087025218727461022                         */
/* Test:  .160706557690342705                         */
/* Test:  .560788640292016786                         */
/* Test:  .071287486650477284                         */
/* Test:  .642404783935626407                         */
/* Test:  .688120376744585123                         */
/* Test:  .618329467009867324                         */
/* Test:  .832534032286185530                         */
/* Test:  .656715754110326717                         */
/* Test:  .070246895534485248                         */
/* Test:  .741022361920119023                         */
/* Test:  .369111679067095116                         */
/* Test:  .852796640861350796                         */
/* Test:  .836488822737059488                         */
/* Test:  .010576613251063576                         */
/* Test:  .065476740671872477                         */
/* Test:  .824819456922015814                         */
/* Test:  .516424248659106422                         */
/* Test:  .914621885272922628                         */
/* Test:  .541679123791507671                         */
/* Test:  .046605203571914602                         */
/* Test:  .491684260069294682                         */
/* Test:  .677290061472642290                         */
/* Test:  .364538594988306535                         */
/* Test:  .192263793495309267                         */
/* Test:  .740127516825761125                         */
/* Test:  .049245083889189240                         */
/* Test:  .933592753637808597                         */
/* Test:  .597284227664329282                         */
/* Test:  .450629078124513620                         */
/* Test:  .029756924317341759                         */
/* Test:  .453144846674813148                         */
/* Test:  .782864682718687866                         */
/* Test:  .245519430725509514                         */
/* Test:  .409936702464908937                         */
/* Test:  .470393732391774397                         */
/* Test:  .275788482184492784                         */
/* Test:  .184001209521575002                         */
/* Test:  .232703241476115702                         */
/* Test:  .149407275976608402                         */
/* Test:  .162444829962797448                         */
/* Test:  .169616875329944618                         */
/* Test:  .216331915434644339                         */
/* Test:  .012379704891437377                         */
/* Test:  .054854080567413850                         */
/* Test:  .529926188031042921                         */
/* Test:  .188200593595994205                         */
/* Test:  .657938929153429939                         */
/* Test:  .584223637962860226                         */
/* Test:  .428700030905577700                         */
/* Test:  .869179479346098174                         */
/* Test:  .996614596459619615                         */
/* Test:  .077541575471948545                         */
/* Test:  .045522905112881529                         */
/* Test:  .782907527394166905                         */
/* Test:  .574377147805743371                         */
/* Test:  .459817746506084817                         */
/* Test:  .342695523355995695                         */
/* Test:  .093864120572507861                         */
/* Test:  .343765141791932761                         */
/* Test:  .645138053807447130                         */
/* Test:  .607238736744184237                         */
/* Test:  .737008051722183000                         */
/* Test:  .015113102964820111                         */
/* Test:  .746937017429087930                         */
/* Test:  .561911807018392918                         */
/* Test:  .081390752310469397                         */
/* Test:  .438651882387960658                         */
/* Test:  .718594649155884596                         */
/* Test:  .670843257839567842                         */
/* Test:  .035259771324394257                         */
/* Test:  .483743595941295745                         */
/* Test:  .830232998359653239                         */
/* Test:  .003266612331973266                         */
/* Test:  .129669537515738665                         */
/* Test:  .865123196178848121                         */
/* Test:  .031187945306833189                         */
/* Test:  .948254455287925254                         */
/* Test:  .398378149945751371                         */
/* Test:  .946060636815711066                         */
/* Test:  42758960.6528169586                         */
/* Test:  48728235.4844372283                         */
/* Test:  73797398.8145027979                         */
/* Test:  62615344.8986936154                         */
/* Test:  16728423.0603879282                         */
/* Test:  03695389.5602192958                         */
/* Test:  58026855.4181008265                         */
/* Test:  41773846.9161556734                         */
/* Test:  66237155.4224901375                         */
/* Test:  01476056.2732566765                         */
/* Test:  17932564.4647152326                         */
/* Test:  84685748.3218824854                         */
/* Test:  71258554.3593142585                         */
/* Test:  52653135.0562013533                         */
/* Test:  19620477.2798326207                         */
/* Test:  84847727.7585165472                         */
/* Test:  98412776.0187902127                         */
/* Test:  66582958.3364762825                         */
/* Test:  13694649.2048676944                         */
/* Test:  27483801.5850335830                         */
/* Test:  10455716.2407512551                         */
/* Test:  76781859.7845203815                         */
/* Test:  70861082.8979052618                         */
/* Test:  37526980.7676009268                         */
/* Test:  28001325.6639948012                         */
/* Test:  62058267.8508583586                         */
/* Test:  04617585.9945511178                         */
/* Test:  26077025.7320213772                         */
/* Test:  69006897.4658059069                         */
/* Test:  19413317.1759869131                         */
/* Test:  00988597.9533445889                         */
/* Test:  32498040.8013047984                         */
/* Test:  71247677.9305766477                         */
/* Test:  23044791.3150889449                         */
/* Test:  48804070.3212497047                         */
/* Test:  87222317.7735417221                         */
/* Test:  60914877.4225224147                         */
/* Test:  68230468.8510254306                         */
/* Test:  89772975.6153922727                         */
/* Test:  37717037.4716097173                         */
/* Test:  69547363.9856516476                         */
/* Test:  67357102.1024533570                         */
/* Test:  28803225.8831386032                         */
/* Test:  40776595.2732297769                         */
/* Test:  90211927.3838417112                         */
/* Test:  96530013.4671190301                         */
/* Test:  16784646.8910626844                         */
/* Test:  40130773.7361599307                         */
/* Test:  46158477.9522383587                         */
/* Test:  72500848.8344316004                         */
/* Test:  45348876.9920074487                         */
/* Test:  52541904.6054268410                         */
/* Test:  60629094.4784437299                         */
/* Test:  67731074.3728841317                         */
/* Test:  36484460.2596011846                         */
/* Test:  17875936.7508511753                         */
/* Test:  98464794.0378022649                         */
/* Test:  46005261.0289992056                         */
/* Test:  97750028.5511855502                         */
/* Test:  36469424.1104863692                         */
/* Test:  87301762.8507389016                         */
/* Test:  11288419.6378683881                         */
/* Test:  74686589.2591720868                         */
/* Test:  33228551.3018226285                         */
/* Test:  71686767.0736872866                         */
/* Test:  42746811.1633251461                         */
/* Test:  16748663.9824969486                         */
/* Test:  57991327.0283358912                         */
/* Test:  23995760.9124697956                         */
/* Test:  61944026.2142066442                         */
/* Test:  71565962.0009257656                         */
/* Test:  13270762.9826740706                         */
/* Test:  83738345.1950650384                         */
/* Test:  00314891.7583750149                         */
/* Test:  65436266.3661085366                         */
/* Test:  84000849.4146559004                         */
/* Test:  34950961.8031312506                         */
/* Test:  26223548.7919473234                         */
/* Test:  25311318.6943163111                         */
/* Test:  41328227.5566385282                         */
/* Test:  73754173.0776718547                         */
/* Test:  41474413.3156708741                         */
/* Test:  17688515.6622966881                         */
/* Test:  99134742.6633117344                         */
/* Test:  08697556.9927728975                         */
/* Test:  65981681.3354337818                         */
/* Test:  21065407.9552778650                         */
/* Test:  17108369.3679936086                         */
/* Test:  41504620.5433445042                         */
/* Test:  34481111.6207103811                         */
/* Test:  58288342.3828174884                         */
/* Test:  02535943.9457647354                         */
/* Test:  51243734.8549926433                         */
/* Test:  39352257.2261539525                         */
/* Test:  92799266.9959148996                         */
/* Test:  35335852.5602329355                         */
/* Test:  23899100.7291420990                         */
/* Test:  51426304.6054915260                         */
/* Test:  97871540.3189017714                         */
/* Test:  89476756.4107145765                         */
/* Test:  77392350.4652864925                         */
/* Test:  44382154.8734949825                         */
/* Test:  73842640.9375968424                         */
/* Test:  66199197.9944678999                         */
/* Test:  25016749.8567957164                         */
/* Test:  01999999.5012315999                         */
/* Test:  56486623.3501263862                         */
/* Test:  66569738.9899660693                         */
/* Test:  49771166.6748349716                         */
/* Test:  62483037.2398303833                         */
/* Test:  59017185.5899522178                         */
/* Test:  26498616.9018634981                         */
/* Test:  88248335.5807974483                         */
/* Test:  30091458.9896220915                         */
/* Test:  69484260.2868686846                         */
/* Test:  06103219.3021653031                         */
/* Test:  95158531.0547422583                         */
/* Test:  34322483.6175282228                         */
/* Test:  91956194.4918940569                         */
/* Test:  87011501.7986629110                         */
/* Test:  12152098.8899923529                         */
/* Test:  15751970.7844750517                         */
/* Test:  23959130.6002612593                         */
/* Test:  31861653.0131547615                         */
/* Test:  69132574.4046451327                         */
/* Test:  63395204.5205022950                         */
/* Test:  72596369.7731397966                         */
/* Test:  31141904.0099025410                         */
/* Test:  44851390.1010975519                         */
/* Test:  73951280.3909957518                         */
/* Test:  07334567.0308198346                         */
/* Test:  92467534.5770844673                         */
/* Test:  43377429.6215631772                         */
/* Test:  69167365.2350443676                         */
/* Test:  82506440.9409610064                         */
/* Test:  98700086.8895113008                         */
/* Test:  85862588.2784860628                         */
/* Test:  91705528.9536970052                         */
/* Test:  06989086.4027626898                         */
/* Test:  88669460.9727358696                         */
/* Test:  42909313.7708354091                         */
/* Test:  93600766.4754789006                         */
/* Test:  96277443.2206543774                         */
/* Test:  46106694.5686756069                         */
/* Test:  00682651.3240782825                         */
/* Test:  52984182.2612417848                         */
/* Test:  11467071.6947582677                         */
/* Test:  86265161.3057225656                         */
/* Test:  31740266.7566747406                         */
/* Test:  35020910.2679414201                         */
/* Test:  79612457.3684495125                         */
/* Test:  67627343.0314325274                         */
/* Test:  87346086.0203201468                         */
/* Test:  07507072.6792639077                         */
/* Test:  76325738.0459718253                         */
/* Test:  38725678.9124493257                         */
/* Test:  94139868.8111911396                         */
/* Test:  02937276.3278802377                         */
/* Test:  54838088.4881886388                         */
/* Test:  19797635.0496575973                         */
/* Test:  88452138.2021718523                         */
/* Test:  33368856.0160473685                         */
/* Test:  96856014.6173787561                         */
/* Test:  08025088.5861644258                         */
/* Test:  65272032.2417313723                         */
/* Test:  04825012.2488809251                         */
/* Test:  80924003.9599447240                         */
/* Test:  62283315.5794756831                         */
/* Test:  19626454.4214407265                         */
/* Test:  49929090.0629168299                         */
/* Test:  01681256.7175853815                         */
/* Test:  72552848.6956703524                         */
/* Test:  77064335.6212257643                         */
/* Test:  85777198.8351203779                         */
/* Test:  35640580.8679198408                         */
/* Test:  69655971.7831764557                         */
/* Test:  44475212.9812138751                         */
/* Test:  21729816.0174275291                         */
/* Test:  02170118.7192677701                         */
/* Test:  13627605.7020034270                         */
/* Test:  92950624.5189555502                         */
/* Test:  71269822.0804910692                         */
/* Test:  86432490.6607981329                         */
/* Test:  71776219.1344986761                         */
/* Test:  08383009.5264532830                         */
/* Test:  98278599.1812277789                         */
/* Test:  43224229.1512519242                         */
/* Test:  86223423.4598559232                         */
/* Test:  35825464.6664557256                         */
/* Test:  49404061.9871251046                         */
/* Test:  92345353.7749650455                         */
/* Test:  62580047.7211489804                         */
/* Test:  95843139.3680703433                         */
/* Test:  37916919.9286558161                         */
/* Test:  60812695.1227312129                         */
/* Test:  43102151.0365901025                         */
/* Test:  64022092.0707067229                         */
/* Test:  76648972.9953745487                         */
/* Test:  66174463.6294170746                         */
/* Test:  82585390.0614827859                         */
/* Test:  43644863.2550652446                         */
/* Test:  80428796.3358058289                         */
/* Test:  68025062.4845015256                         */
/* Test:  40162997.1372483629                         */
/* Test:  54758828.1900041582                         */
/* Test:  87311612.2337297111                         */
/* Test:  29529650.1713163295                         */
/* Test:  55203716.4000062031                         */
/* Test:  46034816.9047845341                         */
/* Test:  75003063.8984099036                         */
/* Test:  82011470.4500617117                         */
/* Test:  07544241.5222731444                         */
/* Test:  07721235.3541111213                         */
/* Test:  50502241.6556576024                         */
/* Test:  59980524.3243487802                         */
/* Test:  64728470.0974523287                         */
/* Test:  34583822.0090311832                         */
/* Test:  88287475.9549941877                         */
/* Test:  81216589.5397081168                         */
/* Test:  07918367.8881973186                         */
/* Test:  30400543.5788398004                         */
/* Test:  95708918.9157016081                         */
/* Test:  46584212.3216451841                         */
/* Test:  86542685.1129675428                         */
/* Test:  13968205.6001875680                         */
/* Test:  21912482.0450137128                         */
/* Test:  07733313.5881896331                         */
/* Test:  33008727.8710397082                         */
/* Test:  76070667.4377232706                         */
/* Test:  33274207.3054460740                         */
/* Test:  13391841.1546400914                         */
/* Test:  20207970.2575468077                         */
/* Test:  83571785.2413508718                         */
/* Test:  15683774.7972278837                         */
/* Test:  69096672.6571254967                         */
/* Test:  95443403.6816861430                         */
/* Test:  74606094.9050413069                         */
/* Test:  35618686.4847306188                         */
/* Test:  70171765.2278656716                         */
/* Test:  63773307.2574272730                         */
/* Test:  82969188.5056290698                         */
/* Test:  96986454.8081149865                         */
/* Test:  72685271.4142232857                         */
/* Test:  76515410.7312117151                         */
/* Test:  16773839.1518996733                         */
/* Test:  75010886.1099772108                         */
/* Test:  23587987.8420730878                         */
/* Test:  68345367.4527086456                         */
/* Test:  38867532.5551235673                         */
/* Test:  13818835.1865382183                         */
/* Test:  24233518.7291013331                         */
/* Test:  09960218.8144096601                         */
/* Test:  95825805.4015061250                         */
/* Test:  08351556.3458717515                         */
/* Test:  78926042.5171601264                         */
/* Test:  65233705.8365702330                         */
/* Test:  83592494.3195685929                         */
/* Test:  78106788.0622919068                         */
/* Test:  95119655.5420777195                         */
/* Test:  18006456.4676503065                         */
/* Test:  82409894.6221373099                         */
/* Test:  66318979.9350899187                         */
/* Test:  63619243.8141537194                         */
/* Test:  65101955.4316501015                         */
/* Test:  60809036.6128295093                         */
/* Test:  61285883.0781015858                         */
/* Test:  35620579.8845310207                         */
/* Test:  70002190.0971493029                         */
/* Test:  21953740.8092579534                         */
/* Test:  74803691.7590376039                         */
/* Test:  20349862.3518765496                         */
/* Test:  21403735.0167758033                         */
/* Test:  56727347.5717515274                         */
/* Test:  26724243.4031865244                         */
/* Test:  02541805.6515771410                         */
/* Test:  53238558.7944985385                         */
/* Test:  98325372.7879706257                         */
/* Test:  53623275.7222470237                         */
/* Test:  99498371.6496799987                         */
/* Test:  83015412.7257727151                         */
/* Test:  73108031.4453343083                         */
/* Test:  16632004.0816687320                         */
/* Test:  78122714.6628443221                         */
/* Test:  78171461.8106925716                         */
/* Test:  30160812.1403013601                         */
/* Test:  89331515.3946580311                         */
/* Test:  61104485.2169097048                         */
/* Test:  93400546.6413728004                         */
/* Test:  36532670.8936756327                         */
/* Test:  43117905.5663855170                         */
/* Test:  67605993.5651077059                         */
/* Test:  56224246.6486404244                         */
/* Test:  02343850.0515011435                         */
/* Test:  67996948.7474368964                         */
/* Test:  59668144.7691693684                         */
/* Test:  43263602.4752026630                         */
/* Test:  20513973.6661153137                         */
/* Test:  57807743.9958643074                         */
/* Test:  23146691.6388460469                         */
/* Test:  49559818.0958759591                         */
/* Test:  01689297.8996065899                         */
/* Test:  00388565.2936032886                         */
/* Test:  71937363.6628847376                         */
/* Test:  51718097.6949008189                         */
/* Test:  74474260.5084214746                         */
/* Test:  20847807.5674391470                         */
/* Test:  63991279.7020448917                         */
/* Test:  46018028.5338968182                         */
/* Test:  98561322.7723380612                         */
/* Test:  88583982.3304201838                         */
/* Test:  99156215.1303587561                         */
/* Test:  68535240.6728153354                         */
/* Test:  42380777.5366714807                         */
/* Test:  02763020.2627582632                         */
/* Test:  25559519.2472667591                         */
/* Test:  09530695.6259333309                         */
/* Test:  23880317.6921743801                         */
/* Test:  01933437.9558784333                         */
/* Test:  33649099.1557664499                         */
/* Test:  04847625.1514183472                         */
/* Test:  98963870.7156677637                         */
/* Test:  13539480.7499794398                         */
/* Test:  82829458.4715099295                         */
/* Test:  27384073.7334872847                         */
/* Test:  70026752.2097541265                         */
/* Test:  55334694.5100463349                         */
/* Test:  50910186.5325977108                         */
/* Test:  84618530.8362381183                         */
/* Test:  96713067.4653537136                         */
/* Test:  11086417.3022931861                         */
/* Test:  93697401.7540389970                         */
/* Test:  34557185.9895235578                         */
/* Test:  96627203.9280743270                         */
/* Test:  00661288.6271133618                         */
/* Test:  79171055.7377794715                         */
/* Test:  84669785.3567740698                         */
/* Test:  35049801.4019177490                         */
/* Test:  99532100.7623309320                         */
/* Test:  41276275.7423747767                         */
/* Test:  07281478.6802854817                         */
/* Test:  91347495.1029571479                         */
/* Test:  94049291.2421087499                         */
/* Test:  40394509.0985978940                         */
/* Test:  53131349.2216957314                         */
/* Test:  32904260.7272178046                         */
/* Test:  60125418.3322701251                         */
/* Test:  42106778.8568549067                         */
/* Test:  96056751.7983191565                         */
/* Test:  52722046.8073873224                         */
/* Test:  11412373.8341662127                         */
/* Test:  76767212.7543520671                         */
/* Test:  76007989.5168205078                         */
/* Test:  97645602.8301809450                         */
/* Test:  34794937.6668525943                         */
/* Test:  94635089.7585429358                         */
/* Test:  89732791.3478048329                         */
/* Test:  09247193.6813079479                         */
/* Test:  77031374.3498650317                         */
/* Test:  94953262.7987833536                         */
/* Test:  99183412.2800916831                         */
/* Test:  37580004.3436199800                         */
/* Test:  80867456.0598716675                         */
/* Test:  01590314.7837713901                         */
/* Test:  92735537.1917317353                         */
/* Test:  43799834.2695313993                         */
/* Test:  27311724.4537018112                         */
/* Test:  08090706.6694848900                         */
/* Test:  62010873.7572779107                         */
/* Test:  55514816.0578881141                         */
/* Test:  10794794.1623019949                         */
/* Test:  87973567.2854392736                         */
/* Test:  40095489.8312726958                         */
/* Test:  53722480.5307698228                         */
/* Test:  17082961.1101419826                         */
/* Test:  04622535.3641359223                         */
/* Test:  97950533.8108874503                         */
/* Test:  47128779.4706998287                         */
/* Test:  25818519.0743966181                         */
/* Test:  22151661.8732142516                         */
/* Test:  56241287.0206795418                         */
/* Test:  68847148.8445231474                         */
/* Test:  48347414.1821230471                         */
/* Test:  46024960.9766062246                         */
/* Test:  01979540.1579401794                         */
/* Test:  51212945.3972549124                         */
/* Test:  00195836.2965861953                         */
/* Test:  45219745.7998205194                         */
/* Test:  35934764.6519250346                         */
/* Test:  70952996.7421513529                         */
/* Test:  71457694.3146187579                         */
/* Test:  65572198.6106849729                         */
/* Test:  48089357.0419076895                         */
/* Test:  05130880.1572059308                         */
/* Test:  97934040.3471812344                         */
/* Test:  46601419.6006750011                         */
/* Test:  28931698.4962737319                         */
/* Test:  67657074.0614377577                         */
/* Test:  01928279.3146789287                         */
/* Test:  43250486.4579233508                         */
/* Test:  81446242.1460675464                         */
/* Test:  74116966.8172524166                         */
/* Test:  98820539.5124008203                         */
/* Test:  26414693.8027842149                         */
/* Test:  57877420.8654806772                         */
/* Test:  05596625.7611576962                         */
/* Test:  28018022.4181488182                         */
/* Test:  11784837.8070280843                         */
/* Test:  90283434.8361210833                         */
/* Test:  63888879.4960386887                         */
/* Test:  41510789.8586151108                         */
/* Test:  91348384.7599753488                         */
/* Test:  66404728.3446576042                         */
/* Test:  69121844.7074947214                         */
/* Test:  35148644.7718133484                         */
/* Test:  05591602.3227259910                         */
/* Test:  50691713.5098308911                         */
/* Test:  90140432.6149925403                         */
/* Test:  55772166.6438873726                         */
/* Test:  41847196.0553103479                         */
/* Test:  65082224.7651458822                         */
/* Test:  21595302.8899180950                         */
/* Test:  76990539.1542383903                         */
/* Test:  58353009.8373575530                         */
/* Test:  73810109.1471825100                         */
/* Test:  13010258.5825399105                         */
/* Test:  94022703.6599350220                         */
/* Test:  19570203.5902335700                         */
/* Test:  60517508.0160538170                         */
/* Test:  42889374.3073697897                         */
/* Test:  68642717.2072083421                         */
/* Test:  75675974.7171801757                         */
/* Test:  05008601.7006458080                         */
/* Test:  36695525.2555381952                         */
/* Test:  89197855.1728904975                         */
/* Test:  64288498.8866181889                         */
/* Test:  37652749.9224008524                         */
/* Test:  95357925.1315261572                         */
/* Test:  41480028.4719471802                         */
/* Test:  70854404.8177921540                         */
/* Test:  90257556.2682619575                         */
/* Test:  83602724.6839579022                         */
/* Test:  77798223.0265776982                         */
/* Test:  92642244.4998752424                         */
/* Test:  72346559.3593616465                         */
/* Test:  16884502.1832821840                         */
/* Test:  96090480.5489458908                         */
/* Test:  41486817.9805560861                         */
/* Test:  07363511.7373120631                         */
/* Test:  57401458.5588128015                         */
/* Test:  91190589.6458554908                         */
/* Test:  33610291.4626206109                         */
/* Test:  36753610.1621281531                         */
/* Test:  92255319.5199075551                         */
/* Test:  21765767.0176045656                         */
/* Test:  28746256.5331762465                         */
/* Test:  46185065.0383395856                         */
/* Test:  35754572.1255375547                         */
/* Test:  74452366.2923399526                         */
/* Test:  20192440.0607861924                         */
/* Test:  44285269.9545594856                         */
/* Test:  03281740.7425179814                         */
/* Test:  61876287.5081877768                         */
/* Test:  39689922.9196557892                         */
/* Test:  12798481.5052591988                         */
/* Test:  46684047.2008912844                         */
/* Test:  23531495.2373308319                         */
/* Test:  97274936.4559601743                         */
/* Test:  77754329.8216831542                         */
/* Test:  94086760.0695181866                         */
/* Test:  11204280.7066776048                         */
/* Test:  28166943.6352254664                         */
/* Test:  80069582.4255049698                         */
/* Test:  87467806.1693235670                         */
/* Test:  39560913.4369328601                         */
/* Test:  87261990.7825680619                         */
/* Test:  53569714.5106264691                         */
/* Test:  04829531.6012860293                         */
/* Test:  10590320.4355536902                         */
/* Test:  97969122.8478917692                         */
/* Test:  84012775.2768033127                         */
/* Test:  88881703.8274203810                         */
/* Test:  56871479.2720308717                         */
/* Test:  27820665.2774880206                         */
/* Test:  86480862.1623045806                         */
/* Test:  49472272.5868982727                         */
/* Test:  50760270.0450727607                         */
/* Test:  34872669.8510781726                         */
/* Test:  05013506.5740908130                         */
/* Test:  42810061.2165386106                         */
/* Test:  55179030.7853664793                         */
/* Test:  58601431.5039153013                         */
/* Test:  75696171.1166016967                         */
/* Test:  36923339.1860959233                         */
/* Test:  63059063.7487597596                         */
/* Test:  06735948.0121219354                         */
/* Test:  89180703.7315879800                         */
/* Test:  34312104.5680586120                         */
/* Test:  54172520.4819824722                         */
/* Test:  83318761.4655202186                         */
/* Test:  81975745.2729940754                         */
/* Test:  60128222.1796738282                         */
/* Test:  59516412.5926225161                         */
/* Test:  96127397.9296664279                         */
/* Test:  98652078.1363231527                         */
/* Test:  23139663.9151781396                         */
/* Test:  62550725.9803664502                         */
/* Test:  98682668.6076169826                         */
/* Test:  21602676.0208827027                         */
/* Test:  16020683.6292707208                         */
/* Test:  88906404.9794906060                         */
/* Test:  75402254.9514138025                         */
/* Test:  47389238.2832568893                         */
/* Test:  32013397.6742994139                         */
/* Test:  48537054.7949764375                         */
/* Test:  60430535.6666225303                         */
/* Test:  77570715.5136792701                         */
/* Test:  07550962.6870730506                         */
/* Test:  59104407.3194210040                         */
/* Test:  98267227.5287970672                         */
/* Test:  78978375.5563084787                         */
/* Test:  01825367.5678378256                         */
/* Test:  93565136.9965163653                         */
/* Test:  25413176.5369316137                         */
/* Test:  48547613.5203333471                         */
/* Test:  57815001.1904328150                         */
/* Test:  05679552.6956646795                         */
/* Test:  88244188.1239352448                         */
/* Test:  27453889.4490085538                         */
/* Test:  70024599.5639277249                         */
/* Test:  42090800.6715670900                         */
/* Test:  52035534.1172783353                         */
/* Test:  20045083.3411754458                         */
/* Test:  78845388.5955914458                         */
/* Test:  46183617.0996175831                         */
/* Test:  23572714.0205616721                         */
/* Test:  11450917.0008444501                         */
/* Test:  60214246.7100606144                         */
/* Test:  77608729.9669770082                         */
/* Test:  30286565.9113880866                         */
/* Test:  07237314.5736819371                         */
/* Test:  94593682.2543364938                         */
/* Test:  07076096.6605878769                         */
/* Test:  21847016.9737946471                         */
/* Test:  79889619.3868286891                         */
/* Test:  62814576.3082796147                         */
/* Test:  40020936.8702360203                         */
/* Test:  94161714.3946854611                         */
/* Test:  82475002.7412118750                         */
/* Test:  58578322.4593667782                         */
/* Test:  39569769.5694753696                         */
/* Test:  55929608.0389890290                         */
/* Test:  50957918.4385185571                         */
/* Test:  19510241.3748821104                         */
/* Test:  23652587.6058580528                         */
/* Test:  53534568.1566448346                         */
/* Test:  54281177.4736006817                         */
/* Test:  97503332.8021563033                         */
/* Test:  38336592.0247571369                         */
/* Test:  65738818.8726635381                         */
/* Test:  77411218.1456735111                         */
/* Test:  50919928.7147091192                         */
/* Test:  88112405.2842333120                         */
/* Test:  27434157.7180829345                         */
/* Test:  54239512.7267174391                         */
/* Test:  55598945.0753219984                         */
/* Test:  17862181.5036839628                         */
/* Test:  91513605.6821614130                         */
/* Test:  96242356.9771557425                         */
/* Test:  51979155.6576395795                         */
/* Test:  10297682.3122502978                         */
/* Test:  34519659.4494546195                         */
/* Test:  33012094.2657346129                         */
/* Test:  12215915.3848886151                         */
/* Test:  82924262.5310087246                         */
/* Test:  61328094.9310769289                         */
/* Test:  54220847.0959735204                         */
/* Test:  84521872.4097155217                         */
/* Test:  99954867.6781867546                         */
/* Test:  06667902.3259332670                         */
/* Test:  73609834.7506453093                         */
/* Test:  97954671.5021290547                         */
/* Test:  91294327.7108955942                         */
/* Test:  13593723.2672503932                         */
/* Test:  62567503.7982292670                         */
/* Test:  24021856.2288319215                         */
/* Test:  58561274.9058479617                         */
/* Test:  64793954.4256766935                         */
/* Test:  21311606.8185041110                         */
/* Test:  90265424.5202824652                         */
/* Test:  71110817.2043295101                         */
/* Test:  49473933.4766541733                         */
/* Test:  09091473.3048790917                         */
/* Test:  38039673.9644832397                         */
/* Test:  90963748.9861904634                         */
/* Test:  51403667.3656445036                         */
/* Test:  95902323.5139982022                         */
/* Test:  79265985.4606935658                         */
/* Test:  28926904.0121785260                         */
/* Test:  21866145.2460791664                         */
/* Test:  29873906.6746455730                         */
/* Test:  60198674.4436953987                         */
/* Test:  53825417.5376493251                         */
/* Test:  07706429.5129305062                         */
/* Test:  31482774.5370348827                         */
/* Test:  72450847.5885661504                         */
/* Test:  08544322.3719610442                         */
/* Test:  12967340.3429281674                         */
/* Test:  10849412.2986559491                         */
/* Test:  70108105.6583179080                         */
/* Test:  72431798.3397101319                         */
/* Test:  84941188.6717945418                         */
/* Test:  94470511.2471327701                         */
/* Test:  87003078.4594168037                         */
/* Test:  30744383.7066162448                         */
/* Test:  40116812.7390475161                         */
/* Test:  82961052.5027797615                         */
/* Test:  59514192.8479709149                         */
/* Test:  54719214.4736575191                         */
/* Test:  98744306.1758523440                         */
/* Test:  90148776.8426117487                         */
/* Test:  01393824.4624559932                         */
/* Test:  55365925.6397398652                         */
/* Test:  97398545.9633032984                         */
/* Test:  02515221.8283814152                         */
/* Test:  30115500.6668248150                         */
/* Test:  80793809.4189550930                         */
/* Test:  34865233.9061028653                         */
/* Test:  88681997.1650217819                         */
/* Test:  60670480.5472742708                         */
/* Test:  70784424.7503163842                         */
/* Test:  34890263.5098266906                         */
/* Test:  83570257.3966637705                         */
/* Test:  57567764.6625883676                         */
/* Test:  03450586.7292478508                         */
/* Test:  06934432.5034133343                         */
/* Test:  21701848.8616123014                         */
/* Test:  85432680.8391501328                         */
/* Test:  61773325.4096692732                         */
/* Test:  74397907.8995798970                         */
/* Test:  99776320.1946220762                         */
/* Test:  40088615.7307674881                         */
/* Test:  24991438.8105954913                         */
/* Test:  82611238.4713696113                         */
/* Test:  97146097.5067496469                         */
/* Test:  62110044.5489781104                         */
/* Test:  82453942.6888296534                         */
/* Test:  94461601.5146322610                         */
/* Test:  35637988.9072113378                         */
/* Test:  33359069.1111680596                         */
/* Test:  41108651.1908747085                         */
/* Test:  23113346.4058398134                         */
/* Test:  71941596.3043640419                         */
/* Test:  09293761.4941609936                         */
/* Test:  07499902.9735663990                         */
/* Test:  25698325.6338567982                         */
/* Test:  37315749.5417183154                         */
/* Test:  07326802.0924388260                         */
/* Test:  58510646.8810998104                         */
/* Test:  09290293.3873439909                         */
/* Test:  43860895.8856395609                         */
/* Test:  15196865.9505733966                         */
/* Test:  49002344.5979855024                         */
/* Test:  52392800.4234138920                         */
/* Test:  69942883.5369360428                         */
/* Test:  94434112.3393122341                         */
/* Test:  33835864.6907136356                         */
/* Test:  15061336.8647127613                         */
/* Test:  31658500.1732991580                         */
/* Test:  80171060.3476052716                         */
/* Test:  72199976.3354040997                         */
/* Test:  08668346.0413202684                         */
/* Test:  00832630.2736937323                         */
/* Test:  09203924.7254423032                         */
/* Test:  17049540.8233985494                         */
/* Test:  83885932.1031593853                         */
/* Test:  17948904.7408159480                         */
/* Test:  24533519.2604018331                         */
/* Test:  05037500.0131069370                         */
/* Test:  70025908.3923408250                         */
/* Test:  08330620.5253702302                         */
/* Test:  22053693.3404912539                         */
/* Test:  21791508.5069920910                         */
/* Test:  76000163.4531822006                         */
/* Test:  62531671.4848974317                         */
/* Test:  04430374.5229722307                         */
/* Test:  69807163.9533609076                         */
/* Test:  47936087.5864990368                         */
/* Test:  76739002.6254471390                         */
/* Test:  53048396.8654085489                         */
/* Test:  64517689.9678657178                         */
/* Test:  80229458.8797187295                         */
/* Test:  31112611.4517505121                         */
/* Test:  18652044.8637011524                         */
/* Test:  99038116.1382254381                         */
/* Test:  80190484.3128708908                         */
/* Test:  36174255.6727265745                         */
/* Test:  26117370.6185221177                         */
/* Test:  50620496.4015124209                         */
/* Test:  21934740.0173404344                         */
/* Test:  71958820.8422091582                         */
/* Test:  86401543.3970306014                         */
/* Test:  02736590.2313451369                         */
/* Test:  80879334.9380529793                         */
/* Test:  18044586.9159544448                         */
/* Test:  16889154.1640033895                         */
/* Test:  29588982.9487633888                         */
/* Test:  31477824.0358655772                         */
/* Test:  80925352.1610416255                         */
/* Test:  79889303.95415988902980925352161041642             */
/* Test:  66187536.46077458735479889303954159829             */
/* Test:  40680038.87472108036966187536460774554             */
/* Test:  84181563.05155798167340680038874721069             */
/* Test:  41216282741688803             */
/* Test:  94090444733890388             */
/* Test:  86859199085804106             */
/* Test:  28432276898257536             */
/* Test:  92240587310776267             */
/* Test:  68331535770732210             */
/* Test:  18889530438663948             */
/* Test:  71316423974119147             */
/* Test:  33165190698254365             */
/* Test:  33169719266335407             */
/* Test:  45577744024258227             */
/* Test:  36855227386165157             */
/* Test:  63807748954208354             */
/* Test:  38763526364797762             */
/* Test:  47497934082870841             */
/* Test:  98593416977169723             */
/* Test:  96936633165909702             */
/* Test:  56893519977384321             */
/* Test:  33282482727687412             */
/* Test:  88467847202455396             */
/* Test:  07640037455838344             */
/* Test:  35737018384503161             */
/* Test:  11429463703984788             */
/* Test:  43565675718015351             */
/* Test:  29579675409941242             */
/* Test:  77219081209017459             */
/* Test:  91635875939795719             */
/* Test:  51143904667284201             */
/* Test:  74139753498100025             */
/* Test:  08316595595705234             */
/* Test:  33166207277863924             */
/* Test:  76454063412774742             */
/* Test:  11564280419149209             */
/* Test:  33129654118099938             */
/* Test:  15232047640825241             */
/* Test:  77013046087814918             */
/* Test:  14554453366557651             */
/* Test:  57909512368644900             */
/* Test:  01953825802997167             */
/* Test:  56090745075017190             */
/* Test:  40744600961370159             */
/* Test:  43371759361343742             */
/* Test:  60944463897495771             */
/* Test:  67438672649626996             */
/* Test:  28650566929737131             */
/* Test:  22521847642911430             */
/* Test:  60731658310572878             */
/* Test:  30604630106740127             */
/* Test:  98849827370715504             */
/* Test:  11561074457483178             */
/* Test:  70380505784914327             */
/* Test:  20318170329276852             */
/* Test:  99186847619053120             */
/* Test:  75425483044027741             */
/* Test:  24605436158643168             */
/* Test:  23708957431783095             */
/* Test:  43755813267851784             */
/* Test:  89589490699204632             */
/* Test:  35263102814648795             */
/* Test:  34566848943129580             */
/* Test:  17102229317404571             */
/* Test:  98478122048392458             */
/* Test:  81158592726913037             */
/* Test:  54051490574101990             */
/* Test:  37553874507465612             */
/* Test:  38333990647806782             */
/* Test:  16091167436612208             */
/* Test:  35007755581190758             */
/* Test:  61834017065940650             */
/* Test:  62323882072901915             */
/* Test:  95198912925807799             */
/* Test:  90255732576059744             */
/* Test:  41980098200736671             */
/* Test:  32395326270455493             */
/* Test:  71027711539852634             */
/* Test:  30747346100556672             */
/* Test:  78767636152422815             */
/* Test:  24103839876861732             */
/* Test:  44442775910694143             */
/* Test:  09803168516358984             */
/* Test:  11811938953230938             */
/* Test:  19802091229805718             */
/* Test:  57450406404196874             */
/* Test:  16609137079892777             */
/* Test:  54362344762401849             */
/* Test:  01266194026252454             */
/* Test:  95804478066555054             */
/* Test:  39659848876500248             */
/* Test:  33607619727746640             */
/* Test:  56299648242826672             */
/* Test:  32802539340199544             */
/* Test:  54174974518636976             */
/* Test:  20533267949436351             */
/* Test:  31969537082305033             */
/* Test:  81351174427133754             */
/* Test:  94832929816968892             */
/* Test:  62634214798292520             */
/* Test:  0.89836527173301706             */
/* Test:  1.00000005960464477550 */
/* Test:     1.00000000000000011113   */
/* Test:    1e+5096                                                 */
/* Test:    1e+4996                                                 */
/* Test:    1e+4596                                                 */
/* Test:    1e-5096                                                 */
/* Test:    1e+4996                                                 */
/* Test:    1e+4596                                                 */
/* Test:    1e+4095                                                 */
/* Test:    1e+2047                                                 */
/* Test:    1e+1023                                                 */
/* Test:    1e+511                                                  */
/* Test:    1e+127                                                  */
/* Test:    1e+63                                                   */
/* Test:    1e+99                                                    */
/* Test:    1e+98                                                   */
/* Test:    1e+97                                                   */
/* Test:    1e+96                                                   */
/* Test:    1e+95                                                   */
/* Test:    1e+94                                                   */
/* Test:    1e+93                                                   */
/* Test:    1e+92                                                   */
/* Test:    1e+91                                                   */
/* Test:    1e+90                                                   */
/* Test:    1e+89                                                   */
/* Test:    1e+88                                                   */
/* Test:    1e+87                                                   */
/* Test:    1e+86                                                   */
/* Test:    1e+85                                                   */
/* Test:    1e+84                                                   */
/* Test:    1e+83                                                   */
/* Test:    1e+82                                                   */
/* Test:    1e+81                                                   */
/* Test:    1e+80                                                   */
/* Test:    1e+79                                                   */
/* Test:    1e+78                                                   */
/* Test:    1e+77                                                   */
/* Test:    1e+76                                                   */
/* Test:    1e+75                                                   */
/* Test:    1e+74                                                   */
/* Test:    1e+73                                                   */
/* Test:    1e+72                                                   */
/* Test:    1e+71                                                   */
/* Test:    1e+70                                                   */
/* Test:    1e+69                                                   */
/* Test:    1e+68                                                   */
/* Test:    1e+67                                                   */
/* Test:    1e+66                                                   */
/* Test:    1e+65                                                   */
/* Test:    1e+64                                                   */
/* Test:    1e+63                                                   */
/* Test:    1e+62                                                   */
/* Test:    1e+61                                                   */
/* Test:    1e+60                                                   */
/* Test:    1e+59                                                   */
/* Test:    1e+58                                                   */
/* Test:    1e+57                                                   */
/* Test:    1e+56                                                   */
/* Test:    1e+55                                                   */
/* Test:    1e+54                                                   */
/* Test:    1e+53                                                   */
/* Test:    1e+52                                                   */
/* Test:    1e+51                                                   */
/* Test:    1e+50                                                   */
/* Test:    1e+49                                                   */
/* Test:    1e+48                                                   */
/* Test:    1e+47                                                   */
/* Test:    1e+46                                                   */
/* Test:    1e+45                                                   */
/* Test:    1e+44                                                   */
/* Test:    1e+43                                                   */
/* Test:    1e+42                                                   */
/* Test:    1e+41                                                   */
/* Test:    1e+40                                                   */
/* Test:    1e+39                                                   */
/* Test:    1e+38                                                   */
/* Test:    1e+37                                                   */
/* Test:    1e+36                                                   */
/* Test:    1e+35                                                   */
/* Test:    1e+34                                                   */
/* Test:    1e+33                                                   */
/* Test:    1e+32                                                   */
/* Test:    1e+31                                                   */
/* Test:    1e+30                                                   */
/* Test:    1e+29                                                   */
/* Test:    1e+28                                                   */
/* Test:    1e+27                                                   */
/* Test:    1e+26                                                   */
/* Test:    1e+25                                                   */
/* Test:    1e+24                                                   */
/* Test:    1e+23                                                   */
/* Test:    1e+22                                                   */
/* Test:    1e+21                                                   */
/* Test:    1e+20                                                   */
/* Test:    1e+19                                                   */
/* Test:    1e+18                                                   */
/* Test:    1e+17                                                   */
/* Test:    1e+16                                                   */
/* Test:    1e+15                                                   */
/* Test:    1e+14                                                   */
/* Test:    1e+13                                                   */
/* Test:    1e+12                                                   */
/* Test:    1e+11                                                   */
/* Test:    1e+10                                                   */
/* Test:    1e+09                                                   */
/* Test:    1e+08                                                   */
/* Test:    1e+07                                                   */
/* Test:    1e+06                                                   */
/* Test:    1e+05                                                   */
/* Test:    1e-5096                                                 */
/* Test:    1e-4996                                                 */
/* Test:    1e-4596                                                 */
/* Test:    1e-5096                                                 */
/* Test:    1e-4996                                                 */
/* Test:    1e-4596                                                 */
/* Test:    1e-4095                                                 */
/* Test:    1e-2047                                                 */
/* Test:    1e-1023                                                 */
/* Test:    1e-511                                                  */
/* Test:    1e-127                                                  */
/* Test:    1e-63                                                   */
/* Test:    1e-99                                                    */
/* Test:    1e-98                                                   */
/* Test:    1e-97                                                   */
/* Test:    1e-96                                                   */
/* Test:    1e-95                                                   */
/* Test:    1e-94                                                   */
/* Test:    1e-93                                                   */
/* Test:    1e-92                                                   */
/* Test:    1e-91                                                   */
/* Test:    1e-90                                                   */
/* Test:    1e-89                                                   */
/* Test:    1e-88                                                   */
/* Test:    1e-87                                                   */
/* Test:    1e-86                                                   */
/* Test:    1e-85                                                   */
/* Test:    1e-84                                                   */
/* Test:    1e-83                                                   */
/* Test:    1e-82                                                   */
/* Test:    1e-81                                                   */
/* Test:    1e-80                                                   */
/* Test:    1e-79                                                   */
/* Test:    1e-78                                                   */
/* Test:    1e-77                                                   */
/* Test:    1e-76                                                   */
/* Test:    1e-75                                                   */
/* Test:    1e-74                                                   */
/* Test:    1e-73                                                   */
/* Test:    1e-72                                                   */
/* Test:    1e-71                                                   */
/* Test:    1e-70                                                   */
/* Test:    1e-69                                                   */
/* Test:    1e-68                                                   */
/* Test:    1e-67                                                   */
/* Test:    1e-66                                                   */
/* Test:    1e-65                                                   */
/* Test:    1e-64                                                   */
/* Test:    1e-63                                                   */
/* Test:    1e-62                                                   */
/* Test:    1e-61                                                   */
/* Test:    1e-60                                                   */
/* Test:    1e-59                                                   */
/* Test:    1e-58                                                   */
/* Test:    1e-57                                                   */
/* Test:    1e-56                                                   */
/* Test:    1e-55                                                   */
/* Test:    1e-54                                                   */
/* Test:    1e-53                                                   */
/* Test:    1e-52                                                   */
/* Test:    1e-51                                                   */
/* Test:    1e-50                                                   */
/* Test:    1e-49                                                   */
/* Test:    1e-48                                                   */
/* Test:    1e-47                                                   */
/* Test:    1e-46                                                   */
/* Test:    1e-45                                                   */
/* Test:    1e-44                                                   */
/* Test:    1e-43                                                   */
/* Test:    1e-42                                                   */
/* Test:    1e-41                                                   */
/* Test:    1e-40                                                   */
/* Test:    1e-39                                                   */
/* Test:    1e-38                                                   */
/* Test:    1e-37                                                   */
/* Test:    1e-36                                                   */
/* Test:    1e-35                                                   */
/* Test:    1e-34                                                   */
/* Test:    1e-33                                                   */
/* Test:    1e-32                                                   */
/* Test:    1e-31                                                   */
/* Test:    1e-30                                                   */
/* Test:    1e-29                                                   */
/* Test:    1e-28                                                   */
/* Test:    1e-27                                                   */
/* Test:    1e-26                                                   */
/* Test:    1e-25                                                   */
/* Test:    1e-24                                                   */
/* Test:    1e-23                                                   */
/* Test:    1e-22                                                   */
/* Test:    1e-21                                                   */
/* Test:    1e-20                                                   */
/* Test:    1e-19                                                   */
/* Test:    1e-18                                                   */
/* Test:    1e-17                                                   */
/* Test:    1e-16                                                   */
/* Test:    1e-15                                                   */
/* Test:    1e-14                                                   */
/* Test:    1e-13                                                   */
/* Test:    1e-12                                                   */
/* Test:    1e-11                                                   */
/* Test:    1e-10                                                   */
/* Test:    1e-09                                                   */
/* Test:    1e-08                                                   */
/* Test:    1e-07                                                   */
/* Test:    1e-06                                                   */
/* Test:    1e-05                                                   */
/* Test:    1e004                                                   */
/* Test:    1e3                                                     */
/* Test:    1e02                                                    */
/* Test:    1e                                                      */
/* Test:    1e-                                                    */
/* Test:    .37e-5                                                 */
/* Test:   -1.7891445e+013                                          */
/* Test:    -.37e-5                                                 */
/* Test:    -.37123456789123456789023453q                           */

static int check_fast_strtod( const char *buff, bool show_all)
{
   char *endptr, *endptr1;
   const long double tval = fast_strtold( buff, &endptr);
   const long double tval1 =     strtold( buff, &endptr1);

   if( tval != tval1)
      printf( "FAST_STRTOD DISAGREES WITH STRTOD!!!!\n");
   if( endptr != endptr1)
      printf( "FAST_STRTOD READ A DIFFERENT NUMBER OF BYTES THAN STRTOD!!!!\n");
   if( tval != tval1 || endptr != endptr1 || show_all)
      {
      printf( "Input string: %s", buff);
#ifdef __DMC__
      printf( "   new:  %.37lf %d %.15la\n",
                      (double)tval, (int)(endptr - buff),   (double)tval);
      printf( "   old:  %.37lf %d %.15la\n",
                      (double)tval1, (int)(endptr1 - buff), (double)tval1);
#else
      printf( "   new:  %.37Lg %d %.15La\n", tval, (int)(endptr - buff),   tval);
      printf( "   old:  %.37Lg %d %.15La\n", tval1, (int)(endptr1 - buff), tval1);
#endif
      }
   return( 0);
}

int main( const int argc, const char **argv)
{
   FILE *ifile = fopen( "ftest.cpp", "rb");
   char buff[100];
   bool show_all = false;
   int i;

   for( i = 1; i < argc; i++)
      if( argv[i][0] == '-')
         switch( argv[i][1])
            {
            case 'a':
               show_all = true;
               break;
            default:
               printf( "Unknown option '%s'\n", argv[i]);
               return( -1);
            }

   printf( "sizeof( long double) = %d\n", (int)sizeof( long double));
   while( fgets( buff, sizeof( buff), ifile))
      if( !memcmp( buff + 1, "* Test:", 7))
         check_fast_strtod( buff + 8, show_all);
   fclose( ifile);
   return( 0);
}
