use Wx;
use strict;

# Custom source
use Wx qw/wxCP_DEFAULT_STYLE wxCP_NO_TLW_RESIZE/;

use Wx qw( wxDefaultSize wxDefaultPosition wxNullAnimation wxNullFont wxBLACK );
use Wx qw( wxID_OK wxID_APPLY wxID_SAVE wxID_SAVEAS wxID_CANCEL wxID_YES wxID_NO wxID_EXIT wxID_ABOUT wxID_HELP );
use Wx qw( wxVERTICAL wxHORIZONTAL wxALL wxLEFT wxRIGHT wxTOP wxBOTTOM wxCENTRE wxGROW );
use Wx qw( wxALIGN_RIGHT wxALIGN_BOTTOM wxALIGN_CENTER wxALIGN_CENTER_VERTICAL wxALIGN_CENTER_HORIZONTAL wxALIGN_LEFT wxALIGN_TOP);
use Wx qw( wxST_NO_AUTORESIZE );

# Bitmap functions

use Wx qw( wxNullBitmap wxBITMAP_TYPE_PNG );

# Window functions

use vars qw($DEFAULT_PHOTO_CAPTION); $DEFAULT_PHOTO_CAPTION = 10000;
use vars qw($GS_DEFAULT_PHOTO_CAPTION); $GS_DEFAULT_PHOTO_CAPTION = 10001;
use vars qw($PHOTO_CAPTION_PREFIX); $PHOTO_CAPTION_PREFIX = 10002;
use vars qw($GS_PHOTO_CAPTION_PREFIX); $GS_PHOTO_CAPTION_PREFIX = 10003;
use vars qw($DEFAULT_AUTHOR); $DEFAULT_AUTHOR = 10004;
use vars qw($GS_DEFAULT_AUTHOR); $GS_DEFAULT_AUTHOR = 10005;
use vars qw($GS_AUTO_ROTATE); $GS_AUTO_ROTATE = 10006;

sub GS_photo_properties {
    my( $parent ) = $_[0];
    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item2 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $item1 ) = Wx::StaticBoxSizer->new( $item2, wxVERTICAL );
    $parent->{sb_photo_properties} = $item1;
    
    my( $item3 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item4 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item5 ) = Wx::StaticText->new( $parent, $main::DEFAULT_PHOTO_CAPTION, "text", wxDefaultPosition, wxDefaultSize, wxST_NO_AUTORESIZE );
    $item4->AddWindow( $item5, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5 );

    my( $item6 ) = Wx::Choice->new( $parent, $main::GS_DEFAULT_PHOTO_CAPTION, wxDefaultPosition, [190,-1], [], 0 );
    $item4->AddWindow( $item6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item3->Add( $item4, 0, 0, 5 );

    my( $item7 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item8 ) = Wx::StaticText->new( $parent, $main::PHOTO_CAPTION_PREFIX, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item8, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5 );

    my( $item9 ) = Wx::TextCtrl->new( $parent, $main::GS_PHOTO_CAPTION_PREFIX, "", wxDefaultPosition, [100,-1], 0 );
    $item7->AddWindow( $item9, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item3->Add( $item7, 0, 0, 5 );

    my( $item10 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item11 ) = Wx::StaticText->new( $parent, $main::DEFAULT_AUTHOR, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item10->AddWindow( $item11, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5 );

    my( $item12 ) = Wx::TextCtrl->new( $parent, $main::GS_DEFAULT_AUTHOR, "", wxDefaultPosition, [200,-1], 0 );
    $item10->AddWindow( $item12, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item3->Add( $item10, 0, 0, 5 );

    my( $item13 ) = Wx::CheckBox->new( $parent, $main::GS_AUTO_ROTATE, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item3->AddWindow( $item13, 0, wxALIGN_BOTTOM|wxALL, 5 );

    $item1->Add( $item3, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item0->Add( $item1, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $set_size ) = @_ >= 3 ? $_[2] : 1;
    my( $call_fit ) = @_ >= 2 ? $_[1] : 1;
    if( $set_size == 1 ) {
         $_[0]->SetSizer( $item0 );
         
         if( $call_fit == 1 ) {
             $item0->SetSizeHints( $_[0] );
         }
    }
    
    $item0;
}

use vars qw($GS_THUMBNAIL); $GS_THUMBNAIL = 10007;
use vars qw($CPANE_THUMBNAIL); $CPANE_THUMBNAIL = 10008;
use vars qw($THUMBNAIL_SIZE); $THUMBNAIL_SIZE = 10009;
use vars qw($GS_THUMBNAIL_SIZE); $GS_THUMBNAIL_SIZE = 10010;
use vars qw($THUMBNAIL_JPEG_QUALITY); $THUMBNAIL_JPEG_QUALITY = 10011;
use vars qw($GS_THUMBNAIL_JPEG_QUALITY); $GS_THUMBNAIL_JPEG_QUALITY = 10012;
use vars qw($GS_SITE_IMG); $GS_SITE_IMG = 10013;
use vars qw($GS_CREATE_RESIZED); $GS_CREATE_RESIZED = 10014;
use vars qw($CPANE_RESIZE); $CPANE_RESIZE = 10015;
use vars qw($SITE_IMG_WIDTH); $SITE_IMG_WIDTH = 10016;
use vars qw($GS_SITE_IMG_WIDTH); $GS_SITE_IMG_WIDTH = 10017;
use vars qw($SITE_IMG_HEIGHT); $SITE_IMG_HEIGHT = 10018;
use vars qw($GS_SITE_IMG_HEIGHT); $GS_SITE_IMG_HEIGHT = 10019;
use vars qw($SITE_IMG_JPEG_QUALITY); $SITE_IMG_JPEG_QUALITY = 10020;
use vars qw($GS_SITE_IMG_JPEG_QUALITY); $GS_SITE_IMG_JPEG_QUALITY = 10021;
use vars qw($CPANE_RESIZE_ADVANCED); $CPANE_RESIZE_ADVANCED = 10022;
use vars qw($SITE_IMG_FILTER); $SITE_IMG_FILTER = 10023;
use vars qw($GS_SITE_IMG_FILTER); $GS_SITE_IMG_FILTER = 10024;
use vars qw($SITE_IMG_BLUR); $SITE_IMG_BLUR = 10025;
use vars qw($GS_SITE_IMG_BLUR); $GS_SITE_IMG_BLUR = 10026;
use vars qw($SITE_IMG_INTERLACE); $SITE_IMG_INTERLACE = 10027;
use vars qw($GS_SITE_IMG_INTERLACE); $GS_SITE_IMG_INTERLACE = 10028;
use vars qw($GS_HD); $GS_HD = 10029;
use vars qw($GS_HD_UPLOAD); $GS_HD_UPLOAD = 10030;
use vars qw($CPANE_HD); $CPANE_HD = 10031;
use vars qw($HD_IMG_WIDTH); $HD_IMG_WIDTH = 10032;
use vars qw($GS_HD_IMG_WIDTH); $GS_HD_IMG_WIDTH = 10033;
use vars qw($HD_IMG_HEIGHT); $HD_IMG_HEIGHT = 10034;
use vars qw($GS_HD_IMG_HEIGHT); $GS_HD_IMG_HEIGHT = 10035;
use vars qw($HD_IMG_JPEG_QUALITY); $HD_IMG_JPEG_QUALITY = 10036;
use vars qw($GS_HD_IMG_JPEG_QUALITY); $GS_HD_IMG_JPEG_QUALITY = 10037;
use vars qw($CPANE_HD_ADVANCED); $CPANE_HD_ADVANCED = 10038;
use vars qw($HD_IMG_FILTER); $HD_IMG_FILTER = 10039;
use vars qw($GS_HD_IMG_FILTER); $GS_HD_IMG_FILTER = 10040;
use vars qw($HD_IMG_BLUR); $HD_IMG_BLUR = 10041;
use vars qw($GS_HD_IMG_BLUR); $GS_HD_IMG_BLUR = 10042;
use vars qw($HD_IMG_INTERLACE); $HD_IMG_INTERLACE = 10043;
use vars qw($GS_HD_IMG_INTERLACE); $GS_HD_IMG_INTERLACE = 10044;
use vars qw($GS_THUMBNAIL_SHAPE); $GS_THUMBNAIL_SHAPE = 10045;

sub GS_photo_preparation {
    my( $parent ) = $_[0];
    my( $topsizer ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $sb ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $sb_th ) = Wx::StaticBoxSizer->new( $sb, wxVERTICAL );
    $parent->{sb_thumbnail} = $sb_th;
    
    my( $stxt_th ) = Wx::StaticText->new( $parent, $main::GS_THUMBNAIL, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $sb_th->AddWindow( $stxt_th, 0, wxALL, 5 );

    my( $bh_th ) = Wx::BoxSizer->new( wxHORIZONTAL );
    
    my( $ch_th ) = Wx::Choice->new( $parent, $main::GS_THUMBNAIL_SHAPE, wxDefaultPosition, [250,-1], [], 0 );
    $bh_th->AddWindow( $ch_th, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5 );


    my( $cp_th_option ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_THUMBNAIL, "Options", wxDefaultPosition, [300,-1], 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $cp_th_option->GetPane();
    
    my( $item5 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item6 ) = Wx::StaticText->new( $parent, $main::THUMBNAIL_SIZE, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item5->AddWindow( $item6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item7 ) = Wx::TextCtrl->new( $parent, $main::GS_THUMBNAIL_SIZE, "", wxDefaultPosition, [80,-1], 0 );
    $item5->AddWindow( $item7, 0, wxALIGN_CENTER|wxALL, 5 );

    my( $item8 ) = Wx::StaticText->new( $parent, $main::THUMBNAIL_JPEG_QUALITY, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item5->AddWindow( $item8, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item9 ) = Wx::TextCtrl->new( $parent, $main::GS_THUMBNAIL_JPEG_QUALITY, "", wxDefaultPosition, [80,-1], 0 );
    $item5->AddWindow( $item9, 0, wxALIGN_CENTER|wxALL, 5 );

    $parent->SetSizer( $item5 );
    $parent = $oldparent;
    
    #$sbsizer->AddWindow( $cp_th_options, 0, wxALL, 5 );
    $sb_th->Add( $bh_th, 0, wxALIGN_CENTER_VERTICAL, 5 );
    $bh_th->AddWindow( $cp_th_option, 0, wxALL, 5 );

    $topsizer->Add( $sb_th, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item11 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $sb_web ) = Wx::StaticBoxSizer->new( $item11, wxVERTICAL );
    $parent->{sb_web_sized_photo} = $sb_web;
    
    my( $stxt_web ) = Wx::StaticText->new( $parent, $main::GS_SITE_IMG, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $sb_web->AddWindow( $stxt_web, 0, wxALIGN_LEFT|wxALIGN_TOP|wxALL, 5 );

    my( $bh_web ) = Wx::BoxSizer->new( wxHORIZONTAL );
    
    my( $ch_web ) = Wx::Choice->new( $parent, $main::GS_CREATE_RESIZED, wxDefaultPosition, [250,-1], [], 0 );
    $bh_web->AddWindow( $ch_web, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5 );

    my( $cp_web_option ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_RESIZE, "Options", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $cp_web_option->GetPane();
    
    my( $item16 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item17 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_WIDTH, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item17, 0, wxALL, 5 );

    my( $item18 ) = Wx::TextCtrl->new( $parent, $main::GS_SITE_IMG_WIDTH, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item18, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item19 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_HEIGHT, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item19, 0, wxALL, 5 );

    my( $item20 ) = Wx::TextCtrl->new( $parent, $main::GS_SITE_IMG_HEIGHT, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item20, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item21 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_JPEG_QUALITY, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item21, 0, wxALL, 5 );

    my( $item22 ) = Wx::TextCtrl->new( $parent, $main::GS_SITE_IMG_JPEG_QUALITY, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item16->AddWindow( $item22, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $parent->SetSizer( $item16 );
    $parent = $oldparent;
    
    $bh_web->AddWindow( $cp_web_option, 0, wxALL, 5 );

    my( $cp_web_adv ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_RESIZE_ADVANCED, "Advanced", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $cp_web_adv->GetPane();
    
    my( $item24 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item25 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_FILTER, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item24->AddWindow( $item25, 0, wxALL, 5 );

    my( $item26 ) = Wx::Choice->new( $parent, $main::GS_SITE_IMG_FILTER, wxDefaultPosition, [100,-1], [], 0 );
    $item24->AddWindow( $item26, 0, wxALIGN_CENTER|wxALL, 5 );

    my( $item27 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_BLUR, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item24->AddWindow( $item27, 0, wxALL, 5 );

    my( $item28 ) = Wx::TextCtrl->new( $parent, $main::GS_SITE_IMG_BLUR, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item24->AddWindow( $item28, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item29 ) = Wx::StaticText->new( $parent, $main::SITE_IMG_INTERLACE, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item24->AddWindow( $item29, 0, wxALL, 5 );

    my( $item30 ) = Wx::Choice->new( $parent, $main::GS_SITE_IMG_INTERLACE, wxDefaultPosition, [100,-1], [], 0 );
    $item24->AddWindow( $item30, 0, wxALIGN_CENTER|wxALL, 5 );

    $parent->SetSizer( $item24 );
    $parent = $oldparent;
    
    $bh_web->AddWindow( $cp_web_adv, 0, wxALL, 5 );

    $sb_web->Add( $bh_web, 0, wxALIGN_CENTER_VERTICAL, 5 );

    $topsizer->Add( $sb_web, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item32 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $item31 ) = Wx::StaticBoxSizer->new( $item32, wxVERTICAL );
    
    my( $item33 ) = Wx::StaticText->new( $parent, $main::GS_HD, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item31->AddWindow( $item33, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item34 ) = Wx::BoxSizer->new( wxHORIZONTAL );
    $parent->{sb_high_definition_photo} = $item34;
    
    my( $item35 ) = Wx::Choice->new( $parent, $main::GS_HD_UPLOAD, wxDefaultPosition, [250,-1], [], 0 );
    $item34->AddWindow( $item35, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5 );

    my( $item36 ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_HD, "Options", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $item36->GetPane();
    
    my( $item37 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item38 ) = Wx::StaticText->new( $parent, $main::HD_IMG_WIDTH, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item38, 0, wxALL, 5 );

    my( $item39 ) = Wx::TextCtrl->new( $parent, $main::GS_HD_IMG_WIDTH, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item39, 0, wxALIGN_CENTER|wxALL, 5 );

    my( $item40 ) = Wx::StaticText->new( $parent, $main::HD_IMG_HEIGHT, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item40, 0, wxALL, 5 );

    my( $item41 ) = Wx::TextCtrl->new( $parent, $main::GS_HD_IMG_HEIGHT, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item41, 0, wxALIGN_CENTER|wxALL, 5 );

    my( $item42 ) = Wx::StaticText->new( $parent, $main::HD_IMG_JPEG_QUALITY, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item42, 0, wxALL, 5 );

    my( $item43 ) = Wx::TextCtrl->new( $parent, $main::GS_HD_IMG_JPEG_QUALITY, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item37->AddWindow( $item43, 0, wxALIGN_CENTER|wxALL, 5 );

    $parent->SetSizer( $item37 );
    $parent = $oldparent;
    
    $item34->AddWindow( $item36, 0, wxALL, 5 );

    my( $item44 ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_HD_ADVANCED, "Advanced", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $item44->GetPane();
    
    my( $item45 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item46 ) = Wx::StaticText->new( $parent, $main::HD_IMG_FILTER, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item45->AddWindow( $item46, 0, wxALL, 5 );

    my( $item47 ) = Wx::Choice->new( $parent, $main::GS_HD_IMG_FILTER, wxDefaultPosition, [100,-1], [], 0 );
    $item45->AddWindow( $item47, 0, wxALL, 5 );

    my( $item48 ) = Wx::StaticText->new( $parent, $main::HD_IMG_BLUR, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item45->AddWindow( $item48, 0, wxALL, 5 );

    my( $item49 ) = Wx::TextCtrl->new( $parent, $main::GS_HD_IMG_BLUR, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item45->AddWindow( $item49, 0, wxALL, 5 );

    my( $item50 ) = Wx::StaticText->new( $parent, $main::HD_IMG_INTERLACE, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item45->AddWindow( $item50, 0, wxALL, 5 );

    my( $item51 ) = Wx::Choice->new( $parent, $main::GS_HD_IMG_INTERLACE, wxDefaultPosition, [100,-1], [], 0 );
    $item45->AddWindow( $item51, 0, wxALL, 5 );

    $parent->SetSizer( $item45 );
    $parent = $oldparent;
    
    $item34->AddWindow( $item44, 0, wxALL, 5 );

    $item31->Add( $item34, 0, wxALIGN_CENTER_VERTICAL, 5 );

    $topsizer->Add( $item31, 0, wxALIGN_LEFT|wxALL, 5 );

    my( $set_size ) = @_ >= 3 ? $_[2] : 1;
    my( $call_fit ) = @_ >= 2 ? $_[1] : 1;
    if( $set_size == 1 ) {
         $_[0]->SetSizer( $topsizer );
         
         if( $call_fit == 1 ) {
             $topsizer->SetSizeHints( $_[0] );
         }
    }
    
    $topsizer;
}

use vars qw($GS_WMARK_ACTIVATE); $GS_WMARK_ACTIVATE = 10046;
use vars qw($GS_WMARK_ACTIVATE_HD); $GS_WMARK_ACTIVATE_HD = 10047;
use vars qw($CPANE_WATERMARK); $CPANE_WATERMARK = 10048;
use vars qw($WMARK_TEXT); $WMARK_TEXT = 10049;
use vars qw($GS_WMARK_TEXT); $GS_WMARK_TEXT = 10050;
use vars qw($WMARK_TEXT_SIZE); $WMARK_TEXT_SIZE = 10051;
use vars qw($GS_WMARK_TEXT_SIZE); $GS_WMARK_TEXT_SIZE = 10052;
use vars qw($WMARK_COLOR); $WMARK_COLOR = 10053;
use vars qw($GS_WMARK_COLOR); $GS_WMARK_COLOR = 10054;
use vars qw($WMARK_POSITION); $WMARK_POSITION = 10055;
use vars qw($GS_WMARK_POSITION); $GS_WMARK_POSITION = 10056;
use vars qw($WMARK_MARGIN_TOP); $WMARK_MARGIN_TOP = 10057;
use vars qw($GS_WMARK_MARGIN_TOP); $GS_WMARK_MARGIN_TOP = 10058;
use vars qw($WMARK_MARGIN_LEFT); $WMARK_MARGIN_LEFT = 10059;
use vars qw($GS_WMARK_MARGIN_LEFT); $GS_WMARK_MARGIN_LEFT = 10060;

sub GS_photo_watermark {
    my( $parent ) = $_[0];
    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item2 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $item1 ) = Wx::StaticBoxSizer->new( $item2, wxHORIZONTAL );
    $parent->{sb_watermark} = $item1;
    
    my( $item3 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item4 ) = Wx::CheckBox->new( $parent, $main::GS_WMARK_ACTIVATE, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item3->AddWindow( $item4, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item5 ) = Wx::CheckBox->new( $parent, $main::GS_WMARK_ACTIVATE_HD, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item3->AddWindow( $item5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item1->Add( $item3, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5 );

    my( $item6 ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_WATERMARK, "Options", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $item6->GetPane();
    
    my( $item7 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item8 ) = Wx::StaticText->new( $parent, $main::WMARK_TEXT, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item8, 0, wxALL, 5 );

    my( $item9 ) = Wx::TextCtrl->new( $parent, $main::GS_WMARK_TEXT, "", wxDefaultPosition, [200,-1], 0 );
    $item7->AddWindow( $item9, 0, wxALL, 5 );

    my( $item10 ) = Wx::StaticText->new( $parent, $main::WMARK_TEXT_SIZE, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item10, 0, wxALL, 5 );

    my( $item11 ) = Wx::SpinCtrl->new( $parent, $main::GS_WMARK_TEXT_SIZE, "0", wxDefaultPosition, [50,-1], 0, 0, 100, 0 );
    $item7->AddWindow( $item11, 0, wxALL, 5 );

    my( $item12 ) = Wx::StaticText->new( $parent, $main::WMARK_COLOR, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item12, 0, wxALL, 5 );

    my( $item13 ) = Wx::Choice->new( $parent, $main::GS_WMARK_COLOR, wxDefaultPosition, [100,-1], [], 0 );
    $item7->AddWindow( $item13, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $item14 ) = Wx::StaticText->new( $parent, $main::WMARK_POSITION, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item14, 0, wxALL, 5 );

    my( $item15 ) = Wx::Choice->new( $parent, $main::GS_WMARK_POSITION, wxDefaultPosition, [100,-1], [], 0 );
    $item7->AddWindow( $item15, 0, wxALL, 5 );

    my( $item16 ) = Wx::StaticText->new( $parent, $main::WMARK_MARGIN_TOP, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item16, 0, wxALL, 5 );

    my( $item17 ) = Wx::SpinCtrl->new( $parent, $main::GS_WMARK_MARGIN_TOP, "0", wxDefaultPosition, [100,-1], 0, 0, 100, 0 );
    $item7->AddWindow( $item17, 0, wxALL, 5 );

    my( $item18 ) = Wx::StaticText->new( $parent, $main::WMARK_MARGIN_LEFT, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item7->AddWindow( $item18, 0, wxALL, 5 );

    my( $item19 ) = Wx::SpinCtrl->new( $parent, $main::GS_WMARK_MARGIN_LEFT, "0", wxDefaultPosition, [100,-1], 0, 0, 100, 0 );
    $item7->AddWindow( $item19, 0, wxALL, 5 );

    $parent->SetSizer( $item7 );
    $parent = $oldparent;
    
    $item1->AddWindow( $item6, 0, wxALL, 5 );

    $item0->Add( $item1, 0, wxALIGN_CENTER_VERTICAL, 5 );

    my( $set_size ) = @_ >= 3 ? $_[2] : 1;
    my( $call_fit ) = @_ >= 2 ? $_[1] : 1;
    if( $set_size == 1 ) {
         $_[0]->SetSizer( $item0 );
         
         if( $call_fit == 1 ) {
             $item0->SetSizeHints( $_[0] );
         }
    }
    
    $item0;
}

use vars qw($GS_REMOVE_UPLOADED_FROM_SELECTION); $GS_REMOVE_UPLOADED_FROM_SELECTION = 10070;
use vars qw($CPANE_TRANSFERT_ADVANCED); $CPANE_TRANSFERT_ADVANCED = 10071;
use vars qw($CHUNK_SIZE); $CHUNK_SIZE = 10072;
use vars qw($GS_CHUNK_SIZE); $GS_CHUNK_SIZE = 10073;

sub GS_photo_transfer {
    my( $parent ) = $_[0];
    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item2 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $item1 ) = Wx::StaticBoxSizer->new( $item2, wxHORIZONTAL );
    $parent->{sb_transfert} = $item1;
    
    my( $item3 ) = Wx::CheckBox->new( $parent, $main::GS_REMOVE_UPLOADED_FROM_SELECTION, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item1->AddWindow( $item3, 0, wxALIGN_CENTER|wxALL, 5 );

    my( $item4 ) = Wx::CollapsiblePane->new( $parent, $main::CPANE_TRANSFERT_ADVANCED, "Options", wxDefaultPosition, wxDefaultSize, 0|wxCP_DEFAULT_STYLE );
    my( $oldparent ) = $parent;
    $parent = $item4->GetPane();
    
    my( $item5 ) = Wx::FlexGridSizer->new( 0, 2, 0, 0 );
    
    my( $item6 ) = Wx::StaticText->new( $parent, $main::CHUNK_SIZE, "text", wxDefaultPosition, wxDefaultSize, 0 );
    $item5->AddWindow( $item6, 0, wxALL, 5 );

    my( $item7 ) = Wx::TextCtrl->new( $parent, $main::GS_CHUNK_SIZE, "", wxDefaultPosition, wxDefaultSize, 0 );
    $item5->AddWindow( $item7, 0, wxALL, 5 );

    $parent->SetSizer( $item5 );
    $parent = $oldparent;
    
    $item1->AddWindow( $item4, 0, wxALL, 5 );

    $item0->Add( $item1, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    my( $set_size ) = @_ >= 3 ? $_[2] : 1;
    my( $call_fit ) = @_ >= 2 ? $_[1] : 1;
    if( $set_size == 1 ) {
         $_[0]->SetSizer( $item0 );
         
         if( $call_fit == 1 ) {
             $item0->SetSizeHints( $_[0] );
         }
    }
    
    $item0;
}


use vars qw($LANGUAGE); $LANGUAGE = 10064;
use vars qw($GS_LANGUAGE); $GS_LANGUAGE = 10065;

sub GS_language {
    my( $parent ) = $_[0];
    my( $item0 ) = Wx::BoxSizer->new( wxVERTICAL );
    
    my( $item2 ) = Wx::StaticBox->new( $parent, -1, "" );
    my( $item1 ) = Wx::StaticBoxSizer->new( $item2, wxVERTICAL );
    $parent->{sb_language} = $item1;
    
    my( $item5 ) = Wx::StaticText->new( $parent, $main::LANGUAGE, "", wxDefaultPosition, wxDefaultSize, wxST_NO_AUTORESIZE );
    $item1->AddWindow( $item5, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxTOP, 5 );

    my( $item6 ) = Wx::Choice->new( $parent, $main::GS_LANGUAGE, wxDefaultPosition, [200,-1], [], 0 );
    $item1->AddWindow( $item6, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $item0->Add( $item1, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5 );

    $_[0]->SetSizer( $item0 );
    $item0->SetSizeHints( $_[0] );
    
    $item0;
}
