/*	test_Message

PIRL CVS ID: test_Message.java,v 1.3 2012/04/16 06:11:36 castalia Exp

Unit test for the PIRL.Messenger.Message class.


Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Messenger.*;
import	PIRL.PVL.*;
import	PIRL.Utilities.Checker;

import	java.nio.ByteBuffer;


public class test_Message
{

public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_Message:\n"
	+"    " + Message.ID);

Checker
	checker = new Checker ();

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

int
	exit_status = 0;
String
	parameters_string =
		"Server = PIRL\n" +
		"GROUP = PIRL\n" +
		"	Type = MySQL\n" +
		"	Host = localhost\n" +
		"END_GROUP\n" +
		"END";
try
	{
	if (checker.Verbose)
		System.out.println
			("--- Constructing an empty Message");
	Message
		message = new Message ();

	if (checker.Verbose)
		System.out.println
			("--- parameters_string:\n"
			+ parameters_string);
	if (checker.Verbose)
		System.out.println
			("--- Content (ByteBuffer.wrap (parameters_string.getBytes ()))");
	message.Content (ByteBuffer.wrap (parameters_string.getBytes ()));
	checker.Check ("Content set from ByteBuffer",
		parameters_string, message.Description ());

	String
		name = ".yp.*",
		expected = "MySQL";
	checker.Check ("Matching (\"" + name + "\")",
		expected, message.Matching (name));
	}
catch (Exception exception)
	{
	System.out.println
		("\n"
		+"Exception: " + exception + '\n'
		+"    " + exception.getMessage ());
	exit_status = 1;
	}
System.out.println
	("\n"
	+"Checks: " + checker.Checks_Total + '\n'
	+"Passed: " + checker.Checks_Passed);
System.exit (exit_status);
}

}
