/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_DEFS_H__
#define __PGM_GLES_DEFS_H__

G_BEGIN_DECLS

/* OpenGL ES feature flags */

#define PGM_GLES_FEAT_TEXTURE_FORMAT_BGRA (1L << 0)

/* OpenGL ES constant definitions */

#define PGM_GLES_FALSE 0x0000
#define PGM_GLES_TRUE  0x0001

#define PGM_GLES_NO_ERROR          0x0000
#define PGM_GLES_INVALID_OPERATION 0x0502

#define PGM_GLES_VENDOR     0x1F00
#define PGM_GLES_RENDERER   0x1F01
#define PGM_GLES_VERSION    0x1F02
#define PGM_GLES_EXTENSIONS 0x1F03

#define PGM_GLES_UNSIGNED_BYTE  0x1401
#define PGM_GLES_UNSIGNED_SHORT 0x1403

#define PGM_GLES_MODELVIEW  0x1700
#define PGM_GLES_PROJECTION 0x1701

#define PGM_GLES_SHORT  0x1402
#define PGM_GLES_INT    0x1404
#define PGM_GLES_FLOAT  0x1406
#define PGM_GLES_DOUBLE 0x140A

#define PGM_GLES_COLOR_BUFFER_BIT 0x00004000

#define PGM_GLES_POINTS         0x0000
#define PGM_GLES_LINES          0x0001
#define PGM_GLES_LINE_LOOP      0x0002
#define PGM_GLES_LINE_STRIP     0x0003
#define PGM_GLES_TRIANGLES      0x0004
#define PGM_GLES_TRIANGLE_STRIP 0x0005
#define PGM_GLES_TRIANGLE_FAN   0x0006

#define PGM_GLES_FRONT 0x0404
#define PGM_GLES_BACK  0x0405

#define PGM_GLES_VERTEX_ARRAY        0x8074
#define PGM_GLES_COLOR_ARRAY         0x8076
#define PGM_GLES_TEXTURE_COORD_ARRAY 0x8078

#define PGM_GLES_CULL_FACE 0x0B44

#define PGM_GLES_POINT_SMOOTH 0x0B10
#define PGM_GLES_LINE_SMOOTH  0x0B20

#define PGM_GLES_MAX_TEXTURE_SIZE  0x0D33
#define PGM_GLES_MAX_VIEWPORT_DIMS 0x0D3A

#define PGM_GLES_TEXTURE_2D         0x0DE1
#define PGM_GLES_PROXY_TEXTURE_2D   0x8064
#define PGM_GLES_TEXTURE_WRAP_S     0x2802
#define PGM_GLES_TEXTURE_WRAP_T     0x2803
#define PGM_GLES_TEXTURE_MAG_FILTER 0x2800
#define PGM_GLES_TEXTURE_MIN_FILTER 0x2801

#define PGM_GLES_NEAREST       0x2600
#define PGM_GLES_LINEAR        0x2601
#define PGM_GLES_CLAMP         0x2900
#define PGM_GLES_REPEAT        0x2901
#define PGM_GLES_CLAMP_TO_EDGE 0x812F

#define PGM_GLES_NEAREST_MIPMAP_NEAREST 0x2700
#define PGM_GLES_LINEAR_MIPMAP_NEAREST  0x2701
#define PGM_GLES_NEAREST_MIPMAP_LINEAR  0x2702
#define PGM_GLES_LINEAR_MIPMAP_LINEAR   0x2703

#define PGM_GLES_TEXTURE   0x1702
#define PGM_GLES_SRC_COLOR 0x0300

#define PGM_GLES_ALPHA           0x1906
#define PGM_GLES_RGB             0x1907
#define PGM_GLES_RGBA            0x1908
#define PGM_GLES_LUMINANCE       0x1909
#define PGM_GLES_LUMINANCE_ALPHA 0x190A
#define PGM_GLES_BGRA            0x80E1

#define PGM_GLES_MODELVIEW_MATRIX  0x0BA6
#define PGM_GLES_PROJECTION_MATRIX 0x0BA7
#define PGM_GLES_TEXTURE_MATRIX    0x0BA8

#define PGM_GLES_ZERO                0x0000
#define PGM_GLES_ONE                 0x0001
#define PGM_GLES_SRC_COLOR           0x0300
#define PGM_GLES_ONE_MINUS_SRC_COLOR 0x0301
#define PGM_GLES_SRC_ALPHA           0x0302
#define PGM_GLES_ONE_MINUS_SRC_ALPHA 0x0303
#define PGM_GLES_DST_ALPHA           0x0304
#define PGM_GLES_ONE_MINUS_DST_ALPHA 0x0305
#define PGM_GLES_DST_COLOR           0x0306
#define PGM_GLES_ONE_MINUS_DST_COLOR 0x0307
#define PGM_GLES_SRC_ALPHA_SATURATE  0x0308

#define PGM_GLES_DEPTH_TEST          0x0B71
#define PGM_GLES_BLEND               0x0BE2

#define PGM_GLES_PACK_ALIGNMENT   0x0D05
#define PGM_GLES_UNPACK_ALIGNMENT 0x0CF5

#define PGM_GLES_PERSPECTIVE_CORRECTION_HINT 0x0C50
#define PGM_GLES_FASTEST                     0x1101
#define PGM_GLES_NICEST                      0x1102

#define PGM_GLES_TEXTURE0          0x84C0
#define PGM_GLES_TEXTURE1          0x84C1
#define PGM_GLES_TEXTURE2          0x84C2
#define PGM_GLES_ACTIVE_TEXTURE    0x84E0
#define PGM_GLES_MAX_TEXTURE_UNITS 0x84E2

/* OpenGL ES type definitions */

typedef unsigned int   PgmGlesEnum;
typedef unsigned char  PgmGlesBoolean;
typedef void           PgmGlesVoid;
typedef int            PgmGlesInt;
typedef unsigned int   PgmGlesUint;
typedef int            PgmGlesSizei;
typedef float          PgmGlesFloat;
typedef unsigned short PgmGlesUshort;
typedef short          PgmGlesShort;
typedef unsigned int   PgmGlesBitfield;
typedef float          PgmGlesClampf;
typedef unsigned char  PgmGlesUbyte;

/* OpenGL ES function definitions */

typedef PgmGlesVoid   (*pgm_gles_enable)               (PgmGlesEnum cap);
typedef PgmGlesVoid   (*pgm_gles_disable)              (PgmGlesEnum cap);
typedef PgmGlesEnum   (*pgm_gles_get_error)            (PgmGlesVoid);
typedef PgmGlesUbyte* (*pgm_gles_get_string)           (PgmGlesEnum name);
typedef PgmGlesVoid   (*pgm_gles_enable_client_state)  (PgmGlesEnum cap);
typedef PgmGlesVoid   (*pgm_gles_disable_client_state) (PgmGlesEnum cap);
typedef PgmGlesVoid   (*pgm_gles_vertex_pointer)       (PgmGlesInt size,
                                                        PgmGlesEnum type,
                                                        PgmGlesSizei stride,
                                                        const PgmGlesVoid *ptr);
typedef PgmGlesVoid   (*pgm_gles_color_pointer)        (PgmGlesInt size,
                                                        PgmGlesEnum type,
                                                        PgmGlesSizei stride,
                                                        const PgmGlesVoid *ptr);
typedef PgmGlesVoid   (*pgm_gles_tex_coord_pointer)    (PgmGlesInt size,
                                                        PgmGlesEnum type,
                                                        PgmGlesSizei stride,
                                                        const PgmGlesVoid *ptr);
typedef PgmGlesVoid   (*pgm_gles_draw_arrays)          (PgmGlesEnum mode,
                                                        PgmGlesInt first,
                                                        PgmGlesSizei count);
typedef PgmGlesVoid   (*pgm_gles_draw_elements)        (PgmGlesEnum mode,
                                                        PgmGlesSizei count,
                                                        PgmGlesEnum type,
                                                        const PgmGlesVoid *indices);
typedef PgmGlesVoid   (*pgm_gles_color_4f)             (PgmGlesUshort red,
                                                        PgmGlesUshort green,
                                                        PgmGlesUshort blue,
                                                        PgmGlesUshort alpha);
typedef PgmGlesVoid   (*pgm_gles_color_4fv)            (const PgmGlesFloat *v);
typedef PgmGlesVoid   (*pgm_gles_blend_func)           (PgmGlesEnum sfactor,
                                                        PgmGlesEnum dfactor);
typedef PgmGlesVoid   (*pgm_gles_clear)                (PgmGlesBitfield mask);
typedef PgmGlesVoid   (*pgm_gles_clear_color)          (PgmGlesClampf red,
                                                        PgmGlesClampf green,
                                                        PgmGlesClampf blue,
                                                        PgmGlesClampf alpha);
typedef PgmGlesVoid   (*pgm_gles_matrix_mode)          (PgmGlesEnum mode);
typedef PgmGlesVoid   (*pgm_gles_push_matrix)          (PgmGlesVoid);
typedef PgmGlesVoid   (*pgm_gles_pop_matrix)           (PgmGlesVoid);
typedef PgmGlesVoid   (*pgm_gles_load_identity)        (PgmGlesVoid);
typedef PgmGlesVoid   (*pgm_gles_load_matrix_f)        (const PgmGlesFloat *m);
typedef PgmGlesVoid   (*pgm_gles_viewport)             (PgmGlesInt x,
                                                        PgmGlesInt y,
                                                        PgmGlesSizei width,
                                                        PgmGlesSizei height);
typedef PgmGlesVoid   (*pgm_gles_flush)                (PgmGlesVoid);
typedef PgmGlesVoid   (*pgm_gles_finish)               (PgmGlesVoid);
typedef PgmGlesVoid   (*pgm_gles_frustum_f)            (PgmGlesFloat left,
                                                        PgmGlesFloat right,
                                                        PgmGlesFloat bottom,
                                                        PgmGlesFloat top,
                                                        PgmGlesFloat near_val,
                                                        PgmGlesFloat far_val);
typedef PgmGlesVoid   (*pgm_gles_ortho_f)              (PgmGlesFloat left,
                                                        PgmGlesFloat right,
                                                        PgmGlesFloat bottom,
                                                        PgmGlesFloat top,
                                                        PgmGlesFloat near_val,
                                                        PgmGlesFloat far_val);
typedef PgmGlesVoid   (*pgm_gles_scale_f)              (PgmGlesFloat x,
                                                        PgmGlesFloat y,
                                                        PgmGlesFloat z);
typedef PgmGlesVoid   (*pgm_gles_translate_f)          (PgmGlesFloat x,
                                                        PgmGlesFloat y,
                                                        PgmGlesFloat z);
typedef PgmGlesVoid   (*pgm_gles_rotate_f)             (PgmGlesFloat angle,
                                                        PgmGlesFloat x,
                                                        PgmGlesFloat y,
                                                        PgmGlesFloat z);
typedef PgmGlesVoid   (*pgm_gles_hint)                 (PgmGlesEnum target,
                                                        PgmGlesEnum mode);
typedef PgmGlesVoid   (*pgm_gles_shade_model)          (PgmGlesEnum mode);
typedef PgmGlesVoid   (*pgm_gles_read_pixels)          (PgmGlesInt x,
                                                        PgmGlesInt y,
                                                        PgmGlesSizei width,
                                                        PgmGlesSizei height,
                                                        PgmGlesEnum format,
                                                        PgmGlesEnum type,
                                                        PgmGlesVoid *pixels);
typedef PgmGlesVoid   (*pgm_gles_gen_textures)         (PgmGlesSizei n,
                                                        PgmGlesUint *textures);
typedef PgmGlesVoid   (*pgm_gles_delete_textures)      (PgmGlesSizei n,
                                                        const PgmGlesUint *textures);
typedef PgmGlesVoid   (*pgm_gles_active_texture)       (PgmGlesEnum texture);
typedef PgmGlesVoid   (*pgm_gles_bind_texture)         (PgmGlesEnum target,
                                                        PgmGlesUint texture);
typedef PgmGlesVoid   (*pgm_gles_tex_image_2d)         (PgmGlesEnum target,
                                                        PgmGlesInt level,
                                                        PgmGlesInt internal_format,
                                                        PgmGlesSizei width,
                                                        PgmGlesSizei height,
                                                        PgmGlesInt border,
                                                        PgmGlesEnum format,
                                                        PgmGlesEnum type,
                                                        const PgmGlesVoid *pixels);
typedef PgmGlesVoid   (*pgm_gles_tex_sub_image_2d)     (PgmGlesEnum target,
                                                        PgmGlesInt level,
                                                        PgmGlesInt xoffset,
                                                        PgmGlesInt yoffset,
                                                        PgmGlesSizei width,
                                                        PgmGlesSizei height,
                                                        PgmGlesEnum format,
                                                        PgmGlesEnum type,
                                                        const PgmGlesVoid *pixels);
typedef PgmGlesVoid   (*pgm_gles_tex_parameter_i)      (PgmGlesEnum target,
                                                        PgmGlesEnum pname,
                                                        PgmGlesInt param);
typedef PgmGlesVoid   (*pgm_gles_get_integer_v)        (PgmGlesEnum pname,
                                                        PgmGlesInt *params);
typedef PgmGlesVoid   (*pgm_gles_get_float_v)          (PgmGlesEnum pname,
                                                        PgmGlesFloat *params);

G_BEGIN_DECLS

#endif /* __PGM_GLES_DEFS_H__ */
