/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment imaging example
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pgm/imaging/pgmimaging.h>

int
main (int argc,
      char *argv[])
{
  GdkPixbuf *src, *dst;

  /* Argument check */
  if (argc != 2)
    {
      g_print ("usage: %s imagepath\n", argv[0]);
      return -1;
    }

  g_type_init ();

  src = gdk_pixbuf_new_from_file (argv[1], NULL);
  dst = pgm_imaging_linear_alpha_gradient (src, 0.0f, 0.0f, 1.0f,
                                           0.0f, 1.0f, 0.0f);
  gdk_pixbuf_save (dst, "linear-alpha-gradient.png", "png", NULL, NULL);

  g_object_unref (src);
  g_object_unref (dst);

  return 0;
}
