#
# $Id$
#
# - Find pcre2
# Find the native PCRE2 includes and library
#
#  PCRE2_INCLUDE_DIRS - where to find pcre2.h, etc.
#  PCRE2_LIBRARIES    - List of libraries when using pcre2.
#  PCRE2_FOUND        - True if pcre2 found.


IF (PCRE2_INCLUDE_DIRS)
	# Already in cache, be silent
	SET(PCRE2_FIND_QUIETLY TRUE)
ENDIF (PCRE2_INCLUDE_DIRS)

FIND_PATH(PCRE2_INCLUDE_DIR pcre2.h)

#NOTE For PCRE2 with PCRE2_CODE_UNIT_WIDTH = 8
SET(PCRE2_NAMES pcre2-8)
FIND_LIBRARY(PCRE2_LIBRARY NAMES ${PCRE2_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set PCRE2_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(PCRE2 DEFAULT_MSG PCRE2_LIBRARY PCRE2_INCLUDE_DIR)

IF(PCRE2_FOUND)
	SET( PCRE2_LIBRARIES ${PCRE2_LIBRARY} )
	SET( PCRE2_INCLUDE_DIRS ${PCRE2_INCLUDE_DIR} )
ELSE(PCRE2_FOUND)
	SET( PCRE2_LIBRARIES )
	SET( PCRE2_INCLUDE_DIRS )
ENDIF(PCRE2_FOUND)

MARK_AS_ADVANCED( PCRE2_LIBRARIES PCRE2_INCLUDE_DIRS )
