case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting mkcmds.sh (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >mkcmds.sh <<!GROK!THIS!
$startsh
echo=$echo
n=$n
c="$c"
!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>mkcmds.sh <<'!NO!SUBS!'
#
# Make various tables and header files.
# We run this from the utils directory.
#
if [ -f "../nocmds" ]; then
  $echo "Not building"
  exit
fi

case $1 in
 patches)
if [ -d ../patches ]; then
  $echo "Rebuilding list of installed Patches"
  for bu in ../patches/*; do
    case $bu in
      *~) ;; # Ignore these
      *)
          name=`grep "^# Patch name:" $bu | sed 's/[^:]*://'`
          ver=`grep "^# Patch version:" $bu | sed 's/[^:]*://'`
          name=`$echo $name`
          ver=`$echo $ver`
          if [ "X$name" != "X" ]; then
            if [ "X$ver" != "X" ]; then
              pat="${pat}${name}(${ver}) "
            else
              pat="${pat}${name} "
            fi
          fi
        ;;
    esac
  done
  pat=`$echo $pat`
fi

rm -f ../hdrs/temp.$$.h
rm -f ../src/temp.$$.c

$echo "/* AUTOGENERATED FILE. DO NOT EDIT */" > ../hdrs/temp.$$.h
$echo "#ifndef _PATCH_H" >> ../hdrs/temp.$$.h
$echo "#define _PATCH_H" >> ../hdrs/temp.$$.h
if [ "X$pat" = "X" ]; then
  $echo "#undef PATCHES" >> ../hdrs/temp.$$.h
else
  $echo "#define PATCHES \"$pat\"" >> ../hdrs/temp.$$.h
fi
$echo "#endif /* _PATCH_H */" >> ../hdrs/temp.$$.h
cmp -s ../hdrs/patches.h ../hdrs/temp.$$.h
cmpstat=$?
if [ $cmpstat -eq 0 ]; then
    rm -f ../hdrs/temp.$$.h
else
    mv -f ../hdrs/temp.$$.h ../hdrs/patches.h
fi

;;
switches)

$echo "Rebuilding command switch file"
snum=1
$echo "/* AUTOGENERATED FILE. DO NOT EDIT */" > ../src/temp.$$.c
$echo "/* AUTOGENERATED FILE. DO NOT EDIT */" > ../hdrs/temp.$$.h
$echo "SWITCH_VALUE switch_list[] = {" >> ../src/temp.$$.c
for s in `cat ../src/SWITCHES | sort`; do
  $echo "#define SWITCH_$s $snum" >> ../hdrs/temp.$$.h
  $echo $n "  {$c"			 >> ../src/temp.$$.c
  $echo $n "\"$s\", SWITCH_$s$c"	 >> ../src/temp.$$.c
  $echo $n "}$c"			 >> ../src/temp.$$.c
  $echo ","			 >> ../src/temp.$$.c
  $echo $n "."
  snum=`expr $snum + 1`
done
$echo "  {NULL, 0}" >> ../src/temp.$$.c
$echo "};" >> ../src/temp.$$.c
$echo ""

# NUM_BYTES from command.h * 8.
if [ $snum -gt 160 ]; then
    $echo "You have too many switches defined!"
fi

mv -f ../hdrs/temp.$$.h ../hdrs/switches.h
mv -f ../src/temp.$$.c ../src/switchinc.c

;;
commands)

$echo "Rebuilding command prototype file"
$echo "/* AUTOGENERATED FILE. DO NOT EDIT */" > ../hdrs/temp.$$.h
for c in `grep "^COMMAND *(" ../src/*.c | grep -v cmd_local_silly | cut -f2 -d\( | cut -f1 -d\) | sort | uniq`; do
  $echo >>../hdrs/temp.$$.h "COMMAND_PROTO($c);"
  $echo $n "."
done
$echo ""
cmp -s ../hdrs/cmds.h ../hdrs/temp.$$.h
cmpstat=$?
if [ $cmpstat -eq 0 ]; then
    rm -f ../hdrs/temp.$$.h
else
    mv -f ../hdrs/temp.$$.h ../hdrs/cmds.h
fi

;;
functions)

$echo "Rebuilding function prototype file"
$echo "/* AUTOGENERATED FILE. DO NOT EDIT */" > ../hdrs/temp.$$.h
for c in `grep "^FUNCTION *(" ../src/*.c | grep -v local_fun_silly | cut -f2 -d\( | cut -f1 -d\) | sort | uniq`; do
  $echo >>../hdrs/temp.$$.h "FUNCTION_PROTO($c);"
  $echo $n "."
done
$echo ""
cmp -s ../hdrs/funs.h ../hdrs/temp.$$.h
cmpstat=$?
if [ $cmpstat -eq 0 ]; then
    rm -f ../hdrs/temp.$$.h
else
    mv -f ../hdrs/temp.$$.h ../hdrs/funs.h
fi
;;
esac
!NO!SUBS!
chmod 755 mkcmds.sh
$eunicefix mkcmds.sh
