#region PDFsharp - A .NET library for processing PDF
//
// Authors:
//   Stefan Lange (mailto:Stefan.Lange@pdfsharp.com)
//
// Copyright (c) 2005-2009 empira Software GmbH, Cologne (Germany)
//
// http://www.pdfsharp.com
// http://sourceforge.net/projects/pdfsharp
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
// DEALINGS IN THE SOFTWARE.
#endregion

namespace PdfSharp.Drawing
{
  /// <summary>
  /// Specifies how the content of an existing PDF page and new content is combined.
  /// </summary>
  public enum XGraphicsPdfPageOptions
  {
    /// <summary>
    /// The new content is inserted behind the old content and any subsequent drawing in done above the existing graphic.
    /// </summary>
    Append,

    /// <summary>
    /// The new content is inserted before the old content and any subsequent drawing in done beneath the existing graphic.
    /// </summary>
    Prepend,

    /// <summary>
    /// The new content entirely replaces the old content and any subsequent drawing in done on a blank page.
    /// </summary>
    Replace,

#if MIGRADOC
    /// <summary>
    /// Just a flag to aktivate an internal hack.
    /// </summary>
    PDFlibHack = 0xF000,
#endif
  }
}
