/*
 * window_main_permission.h
 * Copyright (C) Martin Singer 2009-2013 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __PDFCHAIN_WINDOW_MAIN_PERMISSION_H__
#define __PDFCHAIN_WINDOW_MAIN_PERMISSION_H__

#include "pdfchain.h"


/*** Expander : Permission ****************************************************/

class
cExpander_Permission : public Gtk::Expander
{
	public:

		         cExpander_Permission();
		virtual ~cExpander_Permission();

		void clear();
		Glib::ustring createCommand();

	protected:

		Gtk::HBox             mHBox_Permission;
		Gtk::VBox             mVBox_Passwords,
		                      mVBox_Encryption;
		Gtk::Table            mTable_Allow;
		Gtk::Frame            mFrame_PasswordUser,
		                      mFrame_PasswordOwner,
		                      mFrame_Encryption,
		                      mFrame_Allow;
		Gtk::Label            mLabel_Permission,
		                      mLabel_PasswordUser,
		                      mLabel_PasswordOwner,
		                      mLabel_Encryption,
		                      mLabel_Allow;
		Gtk::CheckButton      mCButton_Printing,
		                      mCButton_DegradedPrinting,
		                      mCButton_ModifyContents,
		                      mCButton_Assembly,
		                      mCButton_CopyContents,
		                      mCButton_Screenreaders,
		                      mCButton_ModifyAnnotations,
		                      mCButton_FillIn;
		Gtk::RadioButton      mRButton_EncryptNone,
		                      mRButton_Encrypt40Bit,
		                      mRButton_Encrypt128Bit;
		Gtk::Entry            mEntry_PasswordUser,
		                      mEntry_PasswordOwner;
		Gtk::RadioButtonGroup mRBGroup_Encrypt;
		Gtk::Alignment        mAlign_PasswordUser,
		                      mAlign_PasswordOwner,
		                      mAlign_Encryption,
		                      mAlign_Allow;

		void init();

		void onEntryIcon_PasswordOwner_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_PasswordOwner.set_text("");
			return;
		}

		void onEntryIcon_PasswordUser_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_PasswordUser.set_text("");
			return;
		}
};


#endif
