# Changes of Note

- PDAL's Travis CI configuration is now based on Alpine Linux.
- PDAL is now built into containers with Alpine linux in addition to Ubuntu linux. [Tags](https://hub.docker.com/r/pdal/pdal/tags/) exist for each release, starting with 1.4, as well as the master branch.
- Pipeline tag names can now contain capital letters.  They can also contain underscores after the first character.
- Replace `filters.programmable` and `filters.predicate` with the more general `filters.python`.
- Add support for Matlab with `filters.matlab`(#1661).
- Remove the `approximate` option from `filters.pmf` and add an `exponential` option.p
- Placed base64 encoded VLR data in a subnode of the VLR itself with the key "data" rather than duplicate the VLR node itself (#1648).
- XML pipelines are no longer supported (#1666).
- The number of proprietary dimensions in `readers.text` was expanded from 255 to 4095 (#1657).
- API hooks have been added to support the use of PDAL with JVM languages such as Java or Scala.
- Added support for LASzip 1.4 and switch to use the new LASzip API. (#1205). LASzip support in PDAL will require LASzip.org release 3.1.0 or greater.
- The cpd kernel has been replaced with `filters.cpd`.
- No more warnings about ReturnNumber or NumberOfReturns for LAS permuations (#1682).
- The KernelFactory class has been removed.  Its functionality has been moved to StageFactory.
- Built-in eigen support has changed from version 3.2.8 to 3.3.4 (#1681).

# Enhancements

- API users can now create synonyms for existing arguments to a stage.
- `filters.splitter` can now create buffered tiles with the `buffer` option.
- `writers.ply`can now be made to write faces of an existing mesh (created with `filters.greedyprojection` or `filters.poisson`) if the `faces` option is used.  An option `dims` has also been added that allows specification of the dimensions to be written as PLY elements.  The writer also now supports streaming mode.
- `readers.text` is now automatically invoked for .csv files.
- PDAL_PLUGIN_INSTALL_PATH can now be set via override when building PDAL from source.
- Changed the use of null devices to eliminate potentially running out of file descriptors on Windows.
- `filters.randomize` can now be created by the stage factory (#1598).
- Provide the ability to specify a viewpoint and normal orientation in `filters.normal` (#1638).
- `readers.las` now provides the `ignore_vlr` option to allow named VLRs to be dropped when read (#1651).
- Allow `writers.gdal` to write output rasters of type other than double (#1497).
- `filters.sqlite` is now invoked automatically for .gpkg files.
- `filters.colorinterp` can now be used in streaming mode in some cases (#1675).
- Pointers can now be stored as metadata.
- `filters.ferry` can now create new dimensions without copying data (#1694).

## Documentation

- Remove some leftover references to the `classify` and `extract` options that were removed from `filters.ground` in the last release.
- Add a note about running pgpointcloud tests.
- Added a tutorial on filtering data with python.
- Remove lingering XML pipeline examples and replace with JSON.
- Many updates and corrections to the workshop.
- Added to the FAQs and entry about why a stage might not be found.
- Added information to stage docs to indicate whether or not they were buit-in rather than plugins (#1612).
- Added information to stage docs to indicate when they are streamable (#1606).

# New filters

- `filters.greedyprojection` - Performs triangulation of points (surface reconstruction) based on the greedy projection algorithm.
- `filters.poisson` - Performs triangulation of points (surface reconstruction) based on the algorithm of Kazhdan.
- `filters.head` - Passes through only the first N points.
- `filters.tail` - Passes through only the last N points.
- `filters.cpd` - Calculates and applies a transformation to align two datasets using the [Coherent Point Drift](https://sites.google.com/site/myronenko/research/cpd) registration algorithm.
- `filters.icp` - Calculates and applies a transformation to align two datasets using the [Iterative Closest Point](http://docs.pointclouds.org/trunk/classpcl_1_1_iterative_closest_point.html) registration algorithm.
- `filters.voxelcenternearestneighbor` - Finds points closest to the center of a voxel (#1597).
- `filters.voxelcentroidnearestneighbor` - Finds points closest to the controid of points in a voxel (#1597).
- `filters.python` - Replaces `filters.predicate` and `filters.programmable`.
- `filters.matlab` - Provides support for matlab manipulation of PDAL points and metadata (#1661).

# New readers
- Add `readers.osg` to support Open Scene Graph format.
- Add `readers.matlab` to support reading data from a user-defined Matlab array struct. The same structure is written by `writers.matlab`.

# Bug fixes
- Fixed a case where`kernels.tindex` would unconditionally set the spatial reference on a feature from the `a_srs` option.  The spatial reference stored in `a_srs` is now only used if explicitly set or no spatial reference was present.
- Fixed a case where 'writers.gdal` could fail to check for an out-of-bounds point, potentially leading to a crash.
- Fix an error in 'filters.cluster' where the points wouldn't properly be placed in the first cluster because the starting cluster number was incorrect.
- Fixed an error in freeing OGR features that could cause a crash when running "pdal density".
- Fix potential memory leaks when creating OGRSpatialReference objects.
- Make sure the `global_encoding` option is initialized to 0 in `writers.las` (#1595).
- Fix eigen::computeCovariance to compute the correct sample covariance.
- In some cases, the `filters.crop` would attempt to treat a 2D bounding box as 3D, yeilding a NULL bounding box and an error in behavior (#1626).
- Fixed potential crash when using PDAL with multiple threads by providing locking for gdal::ErrorHandler (#1637)
- Made sure that an uncompressed LAS file would be properly read even if the `compression` option was provided.
- Throw an exception instead of crash when attempting to access a non-existent color ramp. (#1688)



