//=======================================================================
// out.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "global.h"
#include "paco/common.h"	// str2num()
#include <string>
#include <iostream>

// Used to determine the screen width
#if HAVE_STRUCT_WINSIZE
#	if HAVE_TERMIOS_H
#		include <termios.h>
#	endif
#	if HAVE_SYS_IOCTL_H
#		include <sys/ioctl.h>
#	endif
#	ifndef TIOCGWINSZ
#		define TIOCGWINSZ 0x5413
#	endif
#endif

using std::string;
using std::cerr;
using namespace Paco;


Out::Out()
:
	mVerbosity(QUIET)
{ }


// [static]
int Out::screenWidth()
{
	char* columns = getenv("COLUMNS");
	int width = columns ? str2num<int>(columns) : 0;

	if (!width) {
		width = 80;
#if HAVE_STRUCT_WINSIZE
		struct winsize w;
		if (isatty(1) && (ioctl(1, TIOCGWINSZ, &w) != -1) && w.ws_col)
			width = w.ws_col;
#endif
	}
	
	return width;
}


void Out::vrb(string const& msg, int __errno /* = 0 */)
{
	if (mVerbosity > QUIET) {
		if (__errno)
			cerr << "paco: ";
		cerr << msg;
		if (__errno)
			cerr << ": " << strerror(__errno) << "\n";
	}
}


void Out::dbg(string const& msg, bool printProgName /* = true */)
{
	if (mVerbosity > VERBOSE)
		cerr << (printProgName ? "paco :: " : "") << msg;
}


void Out::dbgTitle(string const& title /* = "" */)
{
	if (mVerbosity < DEBUG)
		return;
	
	string head("paco :: ----");
	cerr << head;
	int cnt = head.size();

	if (title.size()) {
		cerr << "[ " + title + " ]";
		cnt += title.size() + 4;
	}
	
	cerr << string(screenWidth() - cnt, '-') << "\n";
}


Out::Silencer::Silencer()
:
	mOldVerbosity(gOut.verbosity())
{
	gOut.verbosity() = QUIET;
}


Out::Silencer::~Silencer()
{
	gOut.verbosity() = mOldVerbosity;
}


