/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.util;

import com.sourceforge.knecs.util.CMCSProperties;
import java.util.Hashtable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.exolab.jms.jndi.rmi.RmiJndiInitialContextFactory;

public class TopicConnectionSingleton
implements ExceptionListener {
    public static final String TCP = "tcp";
    public static final String RMI = "rmi";
    public static final String HTTP = "http";
    private int mAckMode = 1;
    private String mHost = null;
    private String mPort = null;
    protected TopicConnection mConnection = null;
    private static Hashtable mInstances = null;

    protected TopicConnectionSingleton(String mode) throws RuntimeException {
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        this.mHost = sysprops.getProperty("msgserver");
        this.mPort = sysprops.getProperty("msgport");
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (mode.equals(TCP)) {
            props.put("java.naming.provider.url", "tcp://" + this.mHost + ":" + this.mPort + "/");
            props.put("java.naming.factory.initial", "org.exolab.jms.jndi.mipc.IpcJndiInitialContextFactory");
        } else if (mode.equals(RMI)) {
            this.mPort = "1099";
            props.put("java.naming.factory.initial", RmiJndiInitialContextFactory.class.getName());
        } else if (mode.equals(HTTP)) {
            this.mPort = "28080";
            props.put("java.naming.factory.initial", "org.exolab.jms.jndi.http.HttpJndiInitialContextFactory");
            props.put("java.naming.provider.url", "http://" + this.mHost + ":" + this.mPort + "/" + "openjms/servlet/OpenJMSJndi");
        } else {
            throw new RuntimeException("Unsupported mode: " + mode);
        }
        try {
            InitialContext context = new InitialContext(props);
            TopicConnectionFactory factory = (TopicConnectionFactory)context.lookup("JmsTopicConnectionFactory");
            if (factory == null) {
                throw new RuntimeException("Failed to locate connection factory");
            }
            this.mConnection = factory.createTopicConnection();
            this.mConnection.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void onException(JMSException ex) {
        mInstances.clear();
    }

    public static TopicConnectionSingleton getInstance(String mode) {
        TopicConnectionSingleton tcs;
        if (mInstances == null) {
            mInstances = new Hashtable();
        }
        if ((tcs = (TopicConnectionSingleton)mInstances.get(mode)) == null) {
            tcs = new TopicConnectionSingleton(mode);
            mInstances.put(mode, tcs);
        }
        return tcs;
    }

    public TopicConnection getConnection() {
        return this.mConnection;
    }
}

