/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.AttachmentAction;
import org.chefproject.actions.PermissionsAction;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.DiscussionChannel;
import org.chefproject.core.DiscussionChannelEdit;
import org.chefproject.core.DiscussionMessage;
import org.chefproject.core.DiscussionMessageEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.service.DiscussionService;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.util.Indentor;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.SortedIterator;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;

public class DiscussionAction
extends VelocityPortletPaneledAction {
    private static final String CATEGORY_SEPERATOR_STRING = ",";
    private static final String FORM_THREAD_OR_NOT = "thread_or_not";
    private static final String ATTACHMENTS = "discussion.attachments";
    private static final String STATE_CHANNEL_REF = "discussion.channel_id";
    private static final String STATE_CURRENT_CATEGORY = "discussion.current_category";
    private static final String STATE_INITIALIZED_FLAG = "discussion.initialized_flag";
    private static final String STATE_MODE = "discussion.state_mode";
    private static final String STATE_CATEGORIES_SHOW_LIST = "discussion.state_category_show_list";
    private static final String STATE_SORTED_BY = "discussion.state_sorted_by";
    private static final String STATE_SORTED_BY_LASTPOSTEDDATE = "lastposteddate";
    private static final String STATE_SORTED_BY_LASTPOSTEDBY = "lastpostedby";
    private static final String STATE_SORTED_BY_TOPIC = "topic";
    private static final String STATE_SORTED_BY_SUBJECT = "subject";
    private static final String STATE_SORTED_BY_AUTHOR = "author";
    private static final String STATE_SORTED_BY_DATE = "date";
    private static final String STATE_SORTED_BY_CATEGORY_ALPHA = "category";
    private static final String STATE_SORTED_BY_CATEGORY_LASTPOSTEDBY = "category_lastpostedby";
    private static final String STATE_SORTED_BY_CATEGORY_LASTPOSTEDDATE = "category_lastposteddate";
    private static final String STATE_SORTED_ASC = "discussion.state_sorted_asc";
    private static final String STATE_EXPAND_ALL_TOPIC_FLAG = "discussion.state_expand_all_topic_flag";
    private static final String STATE_EXPAND_MESSAGE_LIST = "discussion.state_expand_message_list";
    private static final String STATE_EXPAND_CATEGORY_LIST = "discussion.state_expand_category_list";
    private static final String STATE_FROM_MODE = "discussion.state_from_mode";
    private static final String STATE_SHOW_MESSAGE_LIST = "discussion.state_show_message_list";
    private static final String STATE_CONTENT_TYPE_IMAGE_SERVICE = "attachment.content_type_image_service";
    private static final String NEW_TOPIC_CATEGORY = "discussion.new_topic_category";
    private static final String NEW_TOPIC_NEW_CATEGORY = "discussion.new_topic_new_category";
    private static final String NEW_TOPIC_DATE = "discussion.new_topic_date";
    private static final String NEW_TOPIC_CREATOR = "discussion.new_topic_creator";
    private static final String NEW_TOPIC_BODY = "discussion.new_topic_body";
    private static final String NEW_TOPIC_SUBJECT = "discussion.new_topic_subject";
    private static final String NORMAL_OUTLINE_VIEW_FLAG = "discussion.normal_outline_view_flag";
    private static final String ONE_TOPIC_OUTLINE_VIEW_FLAG = "discussion.one_topic_outline_view_flag";
    private static final String STATE_CURRENT_TOPIC_ID = "discussion.current_topic_id";
    private static final String STATE_CURRENT_MESSAGE_ID = "discussion.current_message_id";
    private static final String STATE_PREVIOUS_TOPIC_ID = "discussion.previous_topic_id";
    private static final String STATE_NEXT_TOPIC_ID = "discussion.next_topic_id";
    private static final String STATE_PREVIOUS_MESSAGE_ID = "discussion.previous_message_id";
    private static final String STATE_NEXT_MESSAGE_ID = "discussion.next_message_id";
    private static final String RESPOND_MESSAGE_CATEGORY = "discussion.respond_message_category";
    private static final String RESPOND_TO_TOPIC_ID = "discussion.respond_to_topic_id";
    private static final String RESPOND_CREATOR = "discussion.respond_creator";
    private static final String RESPOND_MESSAGE_BODY = "discussion.respond_message_body";
    private static final String RESPOND_MESSAGE_SUBJECT = "discussion.respond_subject";
    private static final String RESPOND_FROM = "discussion.respond_from";
    private static final String REVISE_MESSAGE_CATEGORY = "discussion.revise_message_category";
    private static final String REVISE_MESSAGE_ID = "discussion.revise_message_id";
    private static final String REVISE_MESSAGE_BODY = "discussion.revise_body";
    private static final String REVISE_MESSAGE_SUBJECT = "discussion.revise_subject";
    private static final String REVISE_RESPOND_TO_TOPIC_ID = "discussion.revise_respond_to_topic_id";
    private static final String NULL_STRING = "";
    private static final String INUSE_HEADER_STRING = "Someone else is editing this, so you may not ";
    private static final String PERMISSION_HEADER_STRING = "You are not allowed to ";
    private static final String DELETE_MESSAGE_ID = "discussion.delete_message_id";
    private static final String MODE_NORMAL_VIEW = "normalView";
    private static final String MODE_ONE_TOPIC_VIEW = "oneTopicView";
    private static final String MODE_ONE_MESSAGE_VIEW = "oneMessageView";
    private static final String MODE_DELETE_CONFIRM = "deleteConfirm";
    private static final String MODE_RESPOND = "respond";
    private static final String MODE_REVISE = "revise";
    private static final String MODE_NEW_TOPIC = "newTopic";
    private static final String MODE_NEW_CATEGORY = "newCategory";
    private static final String TEMPLATE_NORMAL_VIEW = "chef_discussions_normalView";
    private static final String TEMPLATE_ONE_TOPIC_VIEW = "chef_discussions_onetopicview";
    private static final String TEMPLATE_ONE_MESSAGE_VIEW = "chef_discussions_show";
    private static final String TEMPLATE_DELETE_CONFIRM = "chef_discussions_deleteConfirm";
    private static final String TEMPLATE_RESPOND = "chef_discussions_respond";
    private static final String TEMPLATE_REVISE = "chef_discussions_revise";
    private static final String TEMPLATE_NEW_TOPIC = "chef_discussions_newTopic";
    private static final String TEMPLATE_NEW_CATEGORY = "chef_discussions_newCategory";

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        String attachment_mode;
        String helperMode = (String)state.getAttribute("pemissions.mode");
        if (helperMode != null) {
            String template = PermissionsAction.buildHelperContext(portlet, context, data, state);
            if (template == null) {
                this.addAlert(state, "There is a problem setting Permissions at this time.");
            } else {
                return template;
            }
        }
        if ((attachment_mode = (String)state.getAttribute("attachment.mode")) != null) {
            if (!attachment_mode.equals("done")) {
                return AttachmentAction.buildHelperContext(portlet, context, data, state);
            }
            Vector attachments = (Vector)state.getAttribute("attachment.attachments");
            if (attachments != null) {
                state.setAttribute(ATTACHMENTS, (Object)attachments);
                context.put("attachments", attachments);
            }
            state.removeAttribute("attachment.mode");
            state.removeAttribute("attachment.attachments");
        }
        String template = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        String mode = (String)state.getAttribute(STATE_MODE);
        if (mode.equals(MODE_NORMAL_VIEW)) {
            template = this.buildNormalViewContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ONE_TOPIC_VIEW)) {
            template = this.buildOneTopicViewContext(portlet, context, data, state);
        } else if (mode.equals(MODE_ONE_MESSAGE_VIEW)) {
            template = this.buildShowContext(portlet, context, data, state);
        } else if (mode.equals(MODE_NEW_TOPIC)) {
            template = this.buildNewTopicContext(portlet, context, data, state);
        } else if (mode.equals(MODE_NEW_CATEGORY)) {
            template = this.buildNewCategoryContext(portlet, context, data, state);
        } else if (mode.equals(MODE_RESPOND)) {
            template = this.buildRespondContext(portlet, context, data, state);
        } else if (mode.equals(MODE_REVISE)) {
            template = this.buildReviseContext(portlet, context, data, state);
        } else if (mode.equals(MODE_DELETE_CONFIRM)) {
            template = this.buildDeleteConfirmContext(portlet, context, data, state);
        }
        return template;
    }

    public void doAttachments(RunData data, Context context) {
        String mode;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        state.setAttribute("attachment.mode", (Object)"main");
        state.setAttribute("attachment.from_text", (Object)("Discussion item \"" + params.getString(STATE_SORTED_BY_SUBJECT) + "\""));
        Vector attachments = (Vector)state.getAttribute(ATTACHMENTS);
        if (attachments != null) {
            state.setAttribute("attachment.attachments", attachments.clone());
        }
        if ((mode = (String)state.getAttribute(STATE_MODE)).equals(MODE_NEW_TOPIC)) {
            state.setAttribute(NEW_TOPIC_SUBJECT, (Object)params.getString(STATE_SORTED_BY_SUBJECT));
            state.setAttribute(NEW_TOPIC_BODY, (Object)params.getString("body"));
            boolean newCategory = true;
            String category = params.getString("newcategory");
            if (category.length() == 0) {
                category = params.getString(STATE_SORTED_BY_CATEGORY_ALPHA);
                newCategory = false;
            }
            state.setAttribute(NEW_TOPIC_NEW_CATEGORY, (Object)new Boolean(newCategory));
            state.setAttribute(NEW_TOPIC_CATEGORY, (Object)category);
        } else if (mode.equals(MODE_RESPOND)) {
            state.setAttribute(RESPOND_MESSAGE_SUBJECT, (Object)params.getString(STATE_SORTED_BY_SUBJECT));
            state.setAttribute(RESPOND_MESSAGE_BODY, (Object)params.getString("body"));
        } else if (mode.equals(MODE_REVISE)) {
            state.setAttribute(REVISE_MESSAGE_ID, (Object)params.getString("messageId"));
            state.setAttribute(REVISE_MESSAGE_SUBJECT, (Object)params.getString(STATE_SORTED_BY_SUBJECT));
            state.setAttribute(REVISE_MESSAGE_BODY, (Object)params.getString("body"));
        }
    }

    protected String buildNormalViewContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        String sortedBy = NULL_STRING;
        String sortedAsc = (String)state.getAttribute(STATE_SORTED_ASC);
        sortedBy = (String)state.getAttribute(STATE_SORTED_BY);
        if (!(sortedBy.equals(STATE_SORTED_BY_TOPIC) || sortedBy.equals(STATE_SORTED_BY_AUTHOR) || sortedBy.equals(STATE_SORTED_BY_DATE))) {
            sortedBy = STATE_SORTED_BY_DATE;
            state.setAttribute(STATE_SORTED_BY, (Object)sortedBy);
        }
        context.put("currentSortedBy", sortedBy);
        context.put("currentSortAsc", sortedAsc);
        boolean allowNewTopic = false;
        boolean allowViewContent = false;
        if (channel != null) {
            allowNewTopic = channel.allowAddTopicMessage();
            allowViewContent = channel.allowGetMessages();
            context.put("channel", channel);
            String[] categories = this.sortedCategories(channel, sortedBy, sortedAsc);
            if (categories != null) {
                context.put("categories", categories);
                HashSet expandCategories = (HashSet)state.getAttribute(STATE_EXPAND_CATEGORY_LIST);
                Hashtable categoriesShowList = new Hashtable();
                int i = 0;
                while (i < categories.length) {
                    String category = categories[i];
                    if (expandCategories.contains(category)) {
                        Vector topics = this.iterator_to_vector(channel.getTopics(category));
                        Vector<DiscussionMessage> drafts = new Vector<DiscussionMessage>();
                        Vector<DiscussionMessage> nonDrafts = new Vector<DiscussionMessage>();
                        Vector showMessagesList = new Vector();
                        int j = 0;
                        while (j < topics.size()) {
                            DiscussionMessage m = (DiscussionMessage)topics.get(j);
                            if (m.getDiscussionHeader().getDraft()) {
                                drafts.add(m);
                            } else {
                                nonDrafts.add(m);
                            }
                            ++j;
                        }
                        Vector sortedDraftVector = this.iterator_to_vector(new SortedIterator(drafts.iterator(), new DiscussionComparator(sortedBy, sortedAsc)));
                        Vector sortedNonDraftVector = this.iterator_to_vector(new SortedIterator(nonDrafts.iterator(), new DiscussionComparator(sortedBy, sortedAsc)));
                        Vector sortedNonDraftVectorClone = (Vector)sortedNonDraftVector.clone();
                        int k = 0;
                        while (k < sortedNonDraftVectorClone.size()) {
                            DiscussionMessage message = (DiscussionMessage)sortedNonDraftVectorClone.get(k);
                            HashSet s = (HashSet)state.getAttribute(STATE_EXPAND_MESSAGE_LIST);
                            if (s.contains(message)) {
                                int index = sortedNonDraftVector.indexOf(message);
                                Iterator mReplies = message.getReplies();
                                Vector draftReplies = new Vector();
                                Vector nonDraftReplies = new Vector();
                                while (mReplies.hasNext()) {
                                    DiscussionMessage reply = (DiscussionMessage)mReplies.next();
                                    if (reply.getDiscussionHeader().getDraft()) {
                                        draftReplies.add(reply);
                                        continue;
                                    }
                                    nonDraftReplies.add(reply);
                                }
                                draftReplies = this.iterator_to_vector(new SortedIterator(draftReplies.iterator(), new DiscussionComparator(sortedBy, sortedAsc)));
                                nonDraftReplies = this.iterator_to_vector(new SortedIterator(nonDraftReplies.iterator(), new DiscussionComparator(sortedBy, sortedAsc)));
                                if (sortedAsc.equals(Boolean.TRUE.toString())) {
                                    draftReplies.addAll(nonDraftReplies);
                                    sortedNonDraftVector.addAll(index + 1, draftReplies);
                                } else {
                                    nonDraftReplies.addAll(draftReplies);
                                    sortedNonDraftVector.addAll(index + 1, nonDraftReplies);
                                }
                            }
                            ++k;
                        }
                        if (sortedAsc.equals(Boolean.TRUE.toString())) {
                            showMessagesList.addAll(sortedDraftVector);
                            showMessagesList.addAll(sortedNonDraftVector);
                        } else {
                            showMessagesList.addAll(sortedDraftVector);
                            showMessagesList.addAll(sortedNonDraftVector);
                        }
                        this.setCategoryShowList(state, category, showMessagesList);
                    } else {
                        this.setCategoryShowList(state, category, new Vector());
                    }
                    ++i;
                }
            }
            context.put("expandedCategoryList", state.getAttribute(STATE_EXPAND_CATEGORY_LIST));
            context.put("categoriesShowList", state.getAttribute(STATE_CATEGORIES_SHOW_LIST));
            context.put("expandAllTopics", state.getAttribute(STATE_EXPAND_ALL_TOPIC_FLAG));
            context.put("expandedMessageList", state.getAttribute(STATE_EXPAND_MESSAGE_LIST));
        } else {
            allowNewTopic = DiscussionService.allowAddChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            allowViewContent = DiscussionService.allowGetChannel((String)state.getAttribute(STATE_CHANNEL_REF));
        }
        context.put("normalViewFlag", state.getAttribute(NORMAL_OUTLINE_VIEW_FLAG));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        DiscussionAction.buildMenu(portlet, context, data, state, allowNewTopic, allowViewContent, MODE_NORMAL_VIEW);
        context.put("allow_new_topic", new Boolean(allowNewTopic));
        context.put("allow_new_category", new Boolean(allowNewTopic));
        return TEMPLATE_NORMAL_VIEW;
    }

    /*
     * Unable to fully structure code
     */
    protected String buildOneTopicViewContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        block16: {
            channel = null;
            channelId = (String)state.getAttribute("discussion.channel_id");
            try {
                channel = DiscussionService.getDiscussionChannel(channelId);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Channel id " + channelId + " unused. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
            }
            if (channel == null) break block16;
            context.put("channel", channel);
            category = (String)state.getAttribute("discussion.current_category");
            context.put("category", category);
            messages = new Vector<DiscussionMessage>();
            try {
                block17: {
                    topic = channel.getDiscussionMessage((String)state.getAttribute("discussion.current_topic_id"));
                    context.put("topic", topic);
                    replies = channel.getThread(topic);
                    drafts = new Vector<DiscussionMessage>();
                    nonDrafts = new Vector<DiscussionMessage>();
                    if (topic.getDiscussionHeader().getDraft()) {
                        drafts.add(topic);
                    } else {
                        nonDrafts.add(topic);
                    }
                    while (replies.hasNext()) {
                        m = (DiscussionMessage)replies.next();
                        if (m.getDiscussionHeader().getDraft()) {
                            drafts.add(m);
                            continue;
                        }
                        nonDrafts.add(m);
                    }
                    sortedBy = (String)state.getAttribute("discussion.state_sorted_by");
                    if (!(sortedBy.equals("subject") || sortedBy.equals("date") || sortedBy.equals("author"))) {
                        sortedBy = "date";
                        state.setAttribute("discussion.state_sorted_by", (Object)sortedBy);
                    }
                    sortedAsc = (String)state.getAttribute("discussion.state_sorted_asc");
                    context.put("currentSortedBy", sortedBy);
                    context.put("currentSortAsc", sortedAsc);
                    sortedDraftIterator = new SortedIterator(drafts.iterator(), new DiscussionComparator(sortedBy, sortedAsc));
                    sortedNonDraftIterator = new SortedIterator(nonDrafts.iterator(), new DiscussionComparator(sortedBy, sortedAsc));
                    if (!sortedAsc.equals(Boolean.TRUE.toString())) ** GOTO lbl63
                    while (sortedDraftIterator.hasNext()) {
                        messages.add((DiscussionMessage)sortedDraftIterator.next());
                    }
                    while (sortedNonDraftIterator.hasNext()) {
                        messages.add((DiscussionMessage)sortedNonDraftIterator.next());
                    }
                    break block17;
lbl-1000:
                    // 1 sources

                    {
                        messages.add((DiscussionMessage)sortedNonDraftIterator.next());
lbl63:
                        // 2 sources

                        ** while (sortedNonDraftIterator.hasNext())
                    }
lbl64:
                    // 2 sources

                    while (sortedDraftIterator.hasNext()) {
                        messages.add((DiscussionMessage)sortedDraftIterator.next());
                    }
                }
                context.put("showList", messages);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Id has not been used. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to view this message.");
            }
            context.put("categories", channel.getCategories());
            context.put("expandedMessageList", state.getAttribute("discussion.state_expand_message_list"));
            allowNewTopic = channel.allowAddTopicMessage();
            allowViewContent = channel.allowGetMessages();
            DiscussionAction.buildMenu(portlet, context, data, state, allowNewTopic, allowViewContent, "oneTopicView");
            context.put("allow_new_topic", new Boolean(allowNewTopic));
            context.put("allow_new_category", new Boolean(allowNewTopic));
            context.put("normalViewFlag", state.getAttribute("discussion.one_topic_outline_view_flag"));
            context.put("contentTypeImageService", state.getAttribute("attachment.content_type_image_service"));
        }
        if (state.getAttribute("message") == null) {
            return "chef_discussions_onetopicview";
        }
        return "chef_discussions_normalView";
    }

    protected String buildShowContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("channel", channel);
            String topic = (String)state.getAttribute(STATE_CURRENT_TOPIC_ID);
            context.put(STATE_SORTED_BY_TOPIC, topic);
            context.put("from", state.getAttribute(STATE_FROM_MODE));
            context.put("mode_one_message", MODE_ONE_MESSAGE_VIEW);
            try {
                Iterator topicReplies = channel.getThread(channel.getDiscussionMessage(topic));
                context.put("topicReplies", topicReplies);
                topicReplies = channel.getThread(channel.getDiscussionMessage(topic));
                while (topicReplies.hasNext()) {
                    DiscussionMessage message = (DiscussionMessage)topicReplies.next();
                    String indentation = new Indentor(message.getReplyToDepth()).getIndentationString();
                }
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "There is no such message. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to view this message. ");
            }
            context.put(STATE_SORTED_BY_CATEGORY_ALPHA, state.getAttribute(STATE_CURRENT_CATEGORY));
            String currentMessageId = (String)state.getAttribute(STATE_CURRENT_MESSAGE_ID);
            try {
                context.put(STATE_SORTED_BY_TOPIC, channel.getDiscussionMessage(topic));
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Id= " + topic + " is unused. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to view the message with id = " + topic + ". ");
            }
            try {
                context.put("discussionMessage", channel.getMessage(currentMessageId));
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Id = " + currentMessageId + " is unused. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to view the message with id =" + currentMessageId + ". ");
            }
        }
        context.put("prevTopic", state.getAttribute(STATE_PREVIOUS_TOPIC_ID));
        context.put("nextTopic", state.getAttribute(STATE_NEXT_TOPIC_ID));
        context.put("prevMessage", state.getAttribute(STATE_PREVIOUS_MESSAGE_ID));
        context.put("nextMessage", state.getAttribute(STATE_NEXT_MESSAGE_ID));
        return TEMPLATE_ONE_MESSAGE_VIEW;
    }

    protected String buildReviseContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("channel", channel);
            String currentMessageId = (String)state.getAttribute(STATE_CURRENT_MESSAGE_ID);
            try {
                DiscussionMessage m = (DiscussionMessage)channel.getMessage(currentMessageId);
                context.put("discussionMessage", m);
                Vector attachments = (Vector)state.getAttribute(ATTACHMENTS);
                context.put("attachments", attachments);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "IdUnusedException");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to view this message");
            }
        }
        context.put(STATE_SORTED_BY_SUBJECT, state.getAttribute(REVISE_MESSAGE_SUBJECT));
        context.put("body", state.getAttribute(REVISE_MESSAGE_BODY));
        context.put("replyToTopicId", state.getAttribute(REVISE_RESPOND_TO_TOPIC_ID));
        context.put("from", state.getAttribute(STATE_FROM_MODE));
        context.put(STATE_SORTED_BY_SUBJECT, state.getAttribute(REVISE_MESSAGE_SUBJECT));
        context.put("body", state.getAttribute(REVISE_MESSAGE_BODY));
        return TEMPLATE_REVISE;
    }

    protected String buildNewTopicContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("channel", channel);
            context.put(STATE_SORTED_BY_DATE, new Time());
            context.put("categories", this.sortedCategories(channel, STATE_SORTED_BY_CATEGORY_ALPHA, Boolean.TRUE.toString()));
        }
        context.put(STATE_SORTED_BY_CATEGORY_ALPHA, state.getAttribute(NEW_TOPIC_CATEGORY));
        context.put("newcategory", state.getAttribute(NEW_TOPIC_NEW_CATEGORY));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        Vector attachments = (Vector)state.getAttribute(ATTACHMENTS);
        context.put("attachments", attachments);
        context.put(STATE_SORTED_BY_SUBJECT, state.getAttribute(NEW_TOPIC_SUBJECT));
        context.put("body", state.getAttribute(NEW_TOPIC_BODY));
        if (state.getAttribute("message") == null) {
            return TEMPLATE_NEW_TOPIC;
        }
        return TEMPLATE_NORMAL_VIEW;
    }

    protected String buildNewCategoryContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("channel", channel);
        }
        context.put("categories", this.sortedCategories(channel, STATE_SORTED_BY_CATEGORY_ALPHA, Boolean.TRUE.toString()));
        if (state.getAttribute("message") == null) {
            return TEMPLATE_NEW_CATEGORY;
        }
        return TEMPLATE_NORMAL_VIEW;
    }

    protected String buildRespondContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("channel", channel);
        }
        context.put(STATE_SORTED_BY_DATE, new Time());
        context.put(STATE_SORTED_BY_CATEGORY_ALPHA, state.getAttribute(RESPOND_MESSAGE_CATEGORY));
        context.put("replyToTopicId", state.getAttribute(RESPOND_TO_TOPIC_ID));
        context.put("from", state.getAttribute(STATE_FROM_MODE));
        context.put(STATE_SORTED_BY_SUBJECT, state.getAttribute(RESPOND_MESSAGE_SUBJECT));
        context.put("message", state.getAttribute(RESPOND_MESSAGE_BODY));
        Vector attachments = (Vector)state.getAttribute(ATTACHMENTS);
        context.put("attachments", attachments);
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        return TEMPLATE_RESPOND;
    }

    protected String buildDeleteConfirmContext(VelocityPortlet portlet, Context context, RunData data, SessionState state) {
        context.put("from", state.getAttribute(STATE_FROM_MODE));
        try {
            DiscussionChannel channel = null;
            String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
            try {
                channel = DiscussionService.getDiscussionChannel(channelId);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Channel id " + channelId + " unused. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
            }
            if (channel != null) {
                context.put("deleteMessage", channel.getDiscussionMessage((String)state.getAttribute(DELETE_MESSAGE_ID)));
            }
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "No such message. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to delete the message. ");
        }
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        return TEMPLATE_DELETE_CONFIRM;
    }

    protected void buildConfigureContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            context.put("discussion_channel", channel);
        }
        context.put(FORM_THREAD_OR_NOT, FORM_THREAD_OR_NOT);
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doUpdate");
        String template = (String)this.getContext(rundata).get("template");
        this.setTemplate(rundata, template + "-customize");
    }

    public void doDelete(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            boolean isTopic = false;
            try {
                DiscussionMessageEdit m = channel.editDiscussionMessage((String)state.getAttribute(DELETE_MESSAGE_ID));
                if (m.getReplyToDepth() == 0) {
                    isTopic = true;
                }
                channel.removeMessage(m);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "No such message. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to delete message. ");
            }
            catch (InUseException e) {
                this.addAlert(state, "Someone else is editing this, so you may not delete message. ");
            }
            if (state.getAttribute("message") == null) {
                String from = (String)state.getAttribute(STATE_FROM_MODE);
                if (from.equals(MODE_ONE_TOPIC_VIEW)) {
                    if (isTopic) {
                        state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
                        state.setAttribute(NORMAL_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.FALSE.toString()));
                    } else {
                        state.setAttribute(STATE_MODE, (Object)MODE_ONE_TOPIC_VIEW);
                    }
                } else if (from.equals(MODE_NORMAL_VIEW)) {
                    state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
                } else if (from.equals(MODE_ONE_MESSAGE_VIEW)) {
                    if (isTopic) {
                        state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
                        state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
                    } else {
                        state.setAttribute(STATE_CURRENT_MESSAGE_ID, state.getAttribute(STATE_CURRENT_TOPIC_ID));
                        state.setAttribute(STATE_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
                    }
                }
                state.setAttribute(DELETE_MESSAGE_ID, (Object)NULL_STRING);
            }
        }
    }

    public void doShow(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String category = params.getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        state.setAttribute(STATE_CURRENT_CATEGORY, (Object)category);
        String topic = params.getString(STATE_SORTED_BY_TOPIC);
        state.setAttribute(STATE_CURRENT_TOPIC_ID, (Object)topic);
        String from = params.getString("from");
        state.setAttribute(STATE_FROM_MODE, (Object)from);
        String messageId = params.getString("messageId");
        state.setAttribute(STATE_CURRENT_MESSAGE_ID, (Object)messageId);
        state.setAttribute(STATE_PREVIOUS_TOPIC_ID, (Object)NULL_STRING);
        state.setAttribute(STATE_NEXT_TOPIC_ID, (Object)NULL_STRING);
        state.setAttribute(STATE_PREVIOUS_MESSAGE_ID, (Object)NULL_STRING);
        state.setAttribute(STATE_NEXT_MESSAGE_ID, (Object)NULL_STRING);
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            Iterator topics = channel.getTopics(category);
            String prevTopic = NULL_STRING;
            String currentTopic = NULL_STRING;
            while (topics.hasNext() && (currentTopic = ((DiscussionMessage)topics.next()).getId()).length() > 0 && !topic.equals(currentTopic)) {
                prevTopic = currentTopic;
            }
            state.setAttribute(STATE_PREVIOUS_TOPIC_ID, (Object)prevTopic);
            if (topics.hasNext()) {
                state.setAttribute(STATE_NEXT_TOPIC_ID, (Object)((DiscussionMessage)topics.next()).getId());
            } else {
                state.setAttribute(STATE_NEXT_TOPIC_ID, (Object)NULL_STRING);
            }
            try {
                Iterator thread = channel.getThread(channel.getDiscussionMessage(topic));
                if (messageId.equals(topic)) {
                    state.setAttribute(STATE_PREVIOUS_MESSAGE_ID, (Object)NULL_STRING);
                    if (thread.hasNext()) {
                        String nextMessage = ((DiscussionMessage)thread.next()).getId();
                        state.setAttribute(STATE_NEXT_MESSAGE_ID, (Object)nextMessage);
                    } else {
                        state.setAttribute(STATE_NEXT_MESSAGE_ID, (Object)NULL_STRING);
                    }
                } else {
                    thread = channel.getThread(channel.getDiscussionMessage(topic));
                    String prevMessage = topic;
                    String currentMessage = NULL_STRING;
                    while (thread.hasNext() && (currentMessage = ((DiscussionMessage)thread.next()).getId()).length() > 0 && !messageId.equals(currentMessage)) {
                        prevMessage = currentMessage;
                    }
                    state.setAttribute(STATE_PREVIOUS_MESSAGE_ID, (Object)prevMessage);
                    if (thread.hasNext()) {
                        state.setAttribute(STATE_NEXT_MESSAGE_ID, (Object)((DiscussionMessage)thread.next()).getId());
                    } else {
                        state.setAttribute(STATE_NEXT_MESSAGE_ID, (Object)NULL_STRING);
                    }
                }
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "the id " + topic + "has not been used. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to  to access the discussion message. ");
            }
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute(STATE_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
        }
    }

    public void doNewtopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String subject = params.getString(STATE_SORTED_BY_SUBJECT).trim();
        state.setAttribute(NEW_TOPIC_SUBJECT, (Object)subject);
        String body = params.getString("body").trim();
        state.setAttribute(NEW_TOPIC_BODY, (Object)body);
        boolean newCategory = true;
        String category = params.getString("newcategory").trim();
        if (category.length() == 0) {
            state.setAttribute(NEW_TOPIC_NEW_CATEGORY, (Object)new Boolean("false"));
            category = params.getString(STATE_SORTED_BY_CATEGORY_ALPHA).trim();
            state.setAttribute(NEW_TOPIC_CATEGORY, (Object)category);
            if (category.length() == 0) {
                this.addAlert(state, "Please choose a category. ");
            }
            newCategory = false;
        } else {
            state.setAttribute(NEW_TOPIC_NEW_CATEGORY, (Object)new Boolean("true"));
            state.setAttribute(NEW_TOPIC_CATEGORY, (Object)category);
        }
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (state.getAttribute("message") == null) {
            try {
                boolean draft = false;
                String newTopic_option = params.getString("eventSubmit_doNewtopic");
                if (newTopic_option.equals("Save Draft")) {
                    draft = true;
                } else if (newTopic_option.equals("Post Topic")) {
                    draft = false;
                }
                if (subject.length() == 0) {
                    this.addAlert(state, "Please specify the topic. ");
                } else {
                    boolean sameTopic = false;
                    Iterator l = channel.getTopics(category);
                    while (l.hasNext()) {
                        if (!subject.equals(((DiscussionMessage)l.next()).getDiscussionHeader().getSubject())) continue;
                        this.addAlert(state, "Same topic has been posted. Please use a different topic. ");
                        sameTopic = true;
                    }
                    if (!sameTopic) {
                        DiscussionMessage addedMessage = channel.addDiscussionMessage(category, subject, draft, NULL_STRING, (ReferenceVector)state.getAttribute(ATTACHMENTS), body);
                        if (newCategory) {
                            this.addCategory(state, channel, category);
                            Vector<DiscussionMessage> v = new Vector<DiscussionMessage>();
                            v.add(addedMessage);
                            this.setShowMessagesList(state, category, v);
                        }
                    }
                }
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to start a new topic. ");
            }
        }
        if (state.getAttribute("message") != null) {
            state.setAttribute(STATE_MODE, (Object)MODE_NEW_TOPIC);
        } else {
            this.initNewTopicContext(state);
            state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
            state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
            state.setAttribute(ATTACHMENTS, null);
        }
    }

    public void doNewcategory(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String category = params.getString("newcategory").trim();
        if (category.length() == 0) {
            this.addAlert(state, "Please enter the category name.");
        } else {
            DiscussionChannel channel = null;
            String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
            try {
                channel = DiscussionService.getDiscussionChannel(channelId);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Channel id " + channelId + " unused. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
            }
            if (channel != null) {
                this.addCategory(state, channel, category);
                state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
            }
        }
    }

    public void doRespond(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            String from = (String)state.getAttribute(RESPOND_FROM);
            ParameterParser params = data.getParameters();
            try {
                boolean draft = false;
                String respond_option = params.getString("eventSubmit_doRespond");
                if (respond_option.equals("Save Draft")) {
                    draft = true;
                } else if (respond_option.equals("Send Response")) {
                    draft = false;
                }
                String category = params.getString(STATE_SORTED_BY_CATEGORY_ALPHA);
                String replyToTopicId = params.getString("replyToTopicId");
                state.setAttribute(RESPOND_TO_TOPIC_ID, (Object)replyToTopicId);
                String body = params.getString("body").trim();
                String subject = params.getString(STATE_SORTED_BY_SUBJECT).trim();
                if (subject.length() > 0) {
                    state.setAttribute(RESPOND_MESSAGE_SUBJECT, (Object)subject);
                }
                if (body.length() > 0) {
                    state.setAttribute(RESPOND_MESSAGE_BODY, (Object)body);
                }
                if (subject.length() == 0) {
                    this.addAlert(state, "Please specify the subject for the message. ");
                } else {
                    DiscussionMessage originalMessage;
                    Vector replies;
                    DiscussionMessage addedMessage = channel.addDiscussionMessage(category, subject, draft, replyToTopicId, (ReferenceVector)state.getAttribute(ATTACHMENTS), body);
                    Vector v = (Vector)((Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST)).get(category);
                    int index = v.indexOf(replyToTopicId);
                    if (index + 1 >= (replies = this.iterator_to_vector((originalMessage = channel.getDiscussionMessage(replyToTopicId)).getReplies())).size()) {
                        replies.add(addedMessage);
                    } else {
                        replies.add(index + 1, addedMessage);
                    }
                    this.setCategoryShowList(state, category, replies);
                    state.setAttribute(STATE_CURRENT_MESSAGE_ID, (Object)addedMessage.getId());
                    if (!from.equals(MODE_ONE_MESSAGE_VIEW) && from.equals(MODE_NORMAL_VIEW)) {
                        this.setMessageExpanded(state, addedMessage, true);
                    }
                }
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to respond. ");
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "The message id has not been used. ");
            }
            if (state.getAttribute("message") == null) {
                this.initRespondContext(state);
                if (((String)state.getAttribute(STATE_MODE)).equals(MODE_REVISE)) {
                    this.initReviseContext(state);
                }
                if (from.equals(MODE_ONE_TOPIC_VIEW)) {
                    state.setAttribute(STATE_MODE, (Object)MODE_ONE_TOPIC_VIEW);
                } else if (from.equals(MODE_ONE_MESSAGE_VIEW)) {
                    state.setAttribute(STATE_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
                } else if (from.equals(MODE_NORMAL_VIEW)) {
                    state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
                }
                state.setAttribute(ATTACHMENTS, null);
            }
        }
    }

    public void doPrepnewtopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(ATTACHMENTS, null);
        state.setAttribute(STATE_MODE, (Object)MODE_NEW_TOPIC);
        this.initNewTopicContext(state);
    }

    public void doPrepnewcategory(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(ATTACHMENTS, null);
        state.setAttribute(STATE_MODE, (Object)MODE_NEW_CATEGORY);
    }

    public void doPrerespond(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        state.setAttribute(RESPOND_TO_TOPIC_ID, (Object)params.getString("topicId"));
        state.setAttribute(RESPOND_MESSAGE_CATEGORY, (Object)params.getString(STATE_SORTED_BY_CATEGORY_ALPHA));
        state.setAttribute(RESPOND_MESSAGE_SUBJECT, (Object)NULL_STRING);
        state.setAttribute(RESPOND_MESSAGE_BODY, (Object)NULL_STRING);
        state.setAttribute(STATE_FROM_MODE, (Object)params.getString("from"));
        String mode = (String)state.getAttribute(STATE_MODE);
        if (mode.equals(MODE_ONE_TOPIC_VIEW)) {
            state.setAttribute(RESPOND_FROM, (Object)MODE_ONE_TOPIC_VIEW);
        } else if (mode.equals(MODE_NORMAL_VIEW)) {
            state.setAttribute(RESPOND_FROM, (Object)MODE_NORMAL_VIEW);
        } else if (mode.equals(MODE_ONE_MESSAGE_VIEW)) {
            state.setAttribute(RESPOND_FROM, (Object)MODE_ONE_MESSAGE_VIEW);
        }
        state.setAttribute(STATE_MODE, (Object)MODE_RESPOND);
    }

    public void doContent(RunData data, Context context) {
        String[] categories;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null && (categories = this.sortedCategories(channel, (String)state.getAttribute(STATE_SORTED_BY), (String)state.getAttribute(STATE_SORTED_ASC))) != null) {
            HashSet<String> expandedCategories = new HashSet<String>();
            HashSet expandedMessages = new HashSet();
            int index = 0;
            while (index < categories.length) {
                String category = categories[index];
                expandedCategories.add(category);
                Vector topics = this.iterator_to_vector(channel.getTopics(category));
                int i = 0;
                while (i < topics.size()) {
                    expandedMessages.add(topics.get(i));
                    Vector replies = this.iterator_to_vector(((DiscussionMessage)topics.get(i)).getReplies());
                    int j = 0;
                    while (j < replies.size()) {
                        expandedMessages.add(replies.get(j));
                        ++j;
                    }
                    ++i;
                }
                ++index;
            }
            state.setAttribute(STATE_EXPAND_MESSAGE_LIST, expandedMessages);
            state.setAttribute(STATE_EXPAND_CATEGORY_LIST, expandedCategories);
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute(NORMAL_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.FALSE.toString()));
            state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
        }
    }

    public void doContenttopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(ONE_TOPIC_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.FALSE.toString()));
    }

    public void doOutlinetopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(ONE_TOPIC_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.TRUE.toString()));
    }

    public void doOutline(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_EXPAND_MESSAGE_LIST, new HashSet());
        state.setAttribute(NORMAL_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.TRUE.toString()));
    }

    public void doOnetopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String category = params.getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        state.setAttribute(STATE_CURRENT_CATEGORY, (Object)category);
        String topicId = params.getString(STATE_SORTED_BY_TOPIC);
        state.setAttribute(STATE_CURRENT_TOPIC_ID, (Object)topicId);
        state.setAttribute(STATE_MODE, (Object)MODE_ONE_TOPIC_VIEW);
        state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_DATE);
        state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
    }

    public void doExpandcategory(RunData data, Context context) {
        String category = data.getParameters().getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        this.setCategoryExpanded(state, category, true);
    }

    public void doCollapsecategory(RunData data, Context context) {
        String category = data.getParameters().getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        this.setCategoryExpanded(state, category, false);
    }

    public void doExpandmessage(RunData data, Context context) {
        String messageId = data.getParameters().getString("messageId");
        String category = data.getParameters().getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            try {
                this.setMessageExpanded(state, channel.getDiscussionMessage(messageId), true);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Can not find the message. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to to view the topic. ");
            }
        }
    }

    public void doCollapsemessage(RunData data, Context context) {
        String messageId = data.getParameters().getString("messageId");
        String category = data.getParameters().getString(STATE_SORTED_BY_CATEGORY_ALPHA);
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            try {
                DiscussionMessage message = channel.getDiscussionMessage(messageId);
                this.setMessageExpanded(state, message, false);
                Iterator replies = message.getReplies();
                while (replies.hasNext()) {
                    this.setMessageExpanded(state, (DiscussionMessage)replies.next(), false);
                }
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Can not find the message. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to to view the topic. ");
            }
        }
    }

    public void doCancel(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String from = params.getString("from");
        String fromRevise = params.getString("fromRevise");
        String mode = (String)state.getAttribute(STATE_MODE);
        if (mode.equals(MODE_RESPOND)) {
            this.initRespondContext(state);
        } else if (mode.equals(MODE_NEW_TOPIC)) {
            this.initNewTopicContext(state);
        }
        if (from.equals(MODE_NORMAL_VIEW)) {
            state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
            if (fromRevise != null && fromRevise.equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
            }
        } else if (from.equals(MODE_ONE_TOPIC_VIEW)) {
            state.setAttribute(STATE_MODE, (Object)MODE_ONE_TOPIC_VIEW);
            if (fromRevise != null && fromRevise.equals(Boolean.TRUE.toString())) {
                state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
            }
        } else if (from.equals(MODE_ONE_MESSAGE_VIEW)) {
            state.setAttribute(STATE_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
        }
    }

    public void doPost(RunData data, Context context) {
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String messageId = params.getString("messageId");
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (state.getAttribute("message") == null) {
            try {
                DiscussionMessageEdit postMessage = channel.editDiscussionMessage(messageId);
                postMessage.getDiscussionHeaderEdit().setDraft(false);
                String fromRevise = params.getString("fromRevise");
                if (fromRevise.equals(Boolean.TRUE.toString())) {
                    String subject = params.getString(STATE_SORTED_BY_SUBJECT).trim();
                    String body = params.getString("body").trim();
                    String category = postMessage.getDiscussionHeader().getCategory();
                    String replyToMessageId = params.getString("replyToMessageId");
                    postMessage.getDiscussionHeaderEdit().setSubject(subject);
                    postMessage.setBody(body);
                    String saveOrPost = params.getString("eventSubmit_doPost");
                    if (saveOrPost.equals("Post")) {
                        postMessage.getDiscussionHeaderEdit().setDraft(false);
                    } else if (saveOrPost.equals("Save Draft")) {
                        postMessage.getDiscussionHeaderEdit().setDraft(true);
                    }
                    postMessage.getDiscussionHeaderEdit().replaceAttachments((ReferenceVector)state.getAttribute(ATTACHMENTS));
                    state.setAttribute(STATE_CURRENT_MESSAGE_ID, (Object)postMessage.getId());
                    if (postMessage.getReplyToDepth() == 0) {
                        state.setAttribute(STATE_CURRENT_TOPIC_ID, (Object)postMessage.getId());
                    }
                }
                channel.commitMessage(postMessage);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "The id " + messageId + " has not been used. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to view the message. ");
            }
            catch (InUseException e) {
                this.addAlert(state, "Someone else is editing this, so you may not view the message. ");
            }
        }
        if (state.getAttribute("message") == null) {
            state.setAttribute(ATTACHMENTS, null);
            String from = params.getString("from");
            if (from.equals(MODE_ONE_TOPIC_VIEW)) {
                state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
                state.setAttribute(STATE_MODE, (Object)MODE_ONE_TOPIC_VIEW);
            } else if (from.equals(MODE_NORMAL_VIEW)) {
                state.setAttribute(STATE_CURRENT_MESSAGE_ID, null);
                state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
            } else if (from.equals(MODE_ONE_MESSAGE_VIEW)) {
                state.setAttribute(STATE_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
            }
        }
    }

    public void doRevise(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String from = params.getString("from");
        if (from.equals(MODE_ONE_TOPIC_VIEW)) {
            state.setAttribute(STATE_FROM_MODE, (Object)MODE_ONE_TOPIC_VIEW);
        } else if (from.equals(MODE_NORMAL_VIEW)) {
            state.setAttribute(STATE_FROM_MODE, (Object)MODE_NORMAL_VIEW);
        } else if (from.equals(MODE_ONE_MESSAGE_VIEW)) {
            state.setAttribute(STATE_FROM_MODE, (Object)MODE_ONE_MESSAGE_VIEW);
        }
        String messageId = params.getString("messageId");
        state.setAttribute(STATE_CURRENT_MESSAGE_ID, (Object)messageId);
        ReferenceVector existAttachments = new ReferenceVector();
        DiscussionChannel channel = null;
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            this.addAlert(state, "Channel id " + channelId + " unused. ");
        }
        catch (PermissionException e) {
            this.addAlert(state, "You are not allowed to access channel " + channelId + ". ");
        }
        if (channel != null) {
            try {
                DiscussionMessage m = channel.getDiscussionMessage(messageId);
                existAttachments = m.getDiscussionHeader().getAttachments();
                String subject = m.getDiscussionHeader().getSubject();
                String body = m.getBody();
                state.setAttribute(REVISE_MESSAGE_ID, (Object)messageId);
                state.setAttribute(REVISE_MESSAGE_SUBJECT, (Object)subject);
                state.setAttribute(REVISE_MESSAGE_BODY, (Object)body);
                state.setAttribute(REVISE_RESPOND_TO_TOPIC_ID, (Object)m.getDiscussionHeader().getReplyTo());
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "Messasge does not exist. ");
            }
            catch (PermissionException e) {
                this.addAlert(state, "You are not allowed to view the message. ");
            }
        }
        state.setAttribute(ATTACHMENTS, (Object)existAttachments);
        if (state.getAttribute("message") == null) {
            state.setAttribute(STATE_MODE, (Object)MODE_REVISE);
        }
    }

    public void doSortbytopic(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_TOPIC)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_TOPIC);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doSortbysubject(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_SUBJECT)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_SUBJECT);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doSortbylastpostedby(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_LASTPOSTEDBY)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_LASTPOSTEDBY);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doSortbylastposteddate(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_LASTPOSTEDDATE)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_LASTPOSTEDDATE);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doSortbyauthor(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_AUTHOR)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_AUTHOR);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doSortbydate(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (state.getAttribute(STATE_SORTED_BY).equals(STATE_SORTED_BY_DATE)) {
            String asc = (String)state.getAttribute(STATE_SORTED_ASC);
            asc = asc.equals(Boolean.TRUE.toString()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state.setAttribute(STATE_SORTED_ASC, (Object)asc);
        } else {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_DATE);
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
    }

    public void doDeleteconfirm(RunData data, Context context) {
        ParameterParser params = data.getParameters();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String deleteId = params.getString("messageId");
        state.setAttribute(STATE_FROM_MODE, (Object)params.getString("from"));
        state.setAttribute(DELETE_MESSAGE_ID, (Object)deleteId);
        state.setAttribute(STATE_MODE, (Object)MODE_DELETE_CONFIRM);
    }

    private static void buildMenu(VelocityPortlet portlet, Context context, RunData data, SessionState state, boolean allowNewTopic, boolean allowViewContent, String mode) {
        String form = NULL_STRING;
        boolean outlineFlag = true;
        String expandFunction = NULL_STRING;
        String collapseFunction = NULL_STRING;
        if (mode.equals(MODE_NORMAL_VIEW)) {
            outlineFlag = (Boolean)state.getAttribute(NORMAL_OUTLINE_VIEW_FLAG);
            expandFunction = "doContent";
            collapseFunction = "doOutline";
            form = "normalviewform";
        } else {
            outlineFlag = (Boolean)state.getAttribute(ONE_TOPIC_OUTLINE_VIEW_FLAG);
            expandFunction = "doContenttopic";
            collapseFunction = "doOutlinetopic";
            form = "onetopicform";
        }
        Menu bar = new Menu((Portlet)portlet, data, "DiscussionAction");
        bar.add(new MenuEntry("New Topic...", null, allowNewTopic, 0, "doPrepnewtopic", form));
        bar.add(new MenuEntry("New Category", null, allowNewTopic, 0, "doPrepnewcategory", form));
        if (allowViewContent) {
            bar.add(new MenuEntry("View Content", null, outlineFlag, 0, expandFunction, form));
            bar.add(new MenuEntry("View Outline", null, !outlineFlag, 0, collapseFunction, form));
        } else {
            bar.add(new MenuEntry("View Content", null, false, 0, expandFunction, form));
            bar.add(new MenuEntry("View Outline", null, false, 0, collapseFunction, form));
        }
        if (SiteService.allowUpdateSite(PortalService.getCurrentSiteId())) {
            bar.add(new MenuEntry("Permissions...", "doPermissions"));
        }
        SessionState stateForMenus = ((JetspeedRunData)data).getPortletSessionState(portlet.getID());
        stateForMenus.setAttribute("menu", (Object)bar);
        context.put("menu", bar);
        context.put("action", "DiscussionAction");
    }

    private void initNewTopicContext(SessionState state) {
        state.setAttribute(NEW_TOPIC_BODY, (Object)NULL_STRING);
        state.setAttribute(NEW_TOPIC_CATEGORY, (Object)NULL_STRING);
        state.setAttribute(NEW_TOPIC_NEW_CATEGORY, (Object)new Boolean(true));
        state.setAttribute(NEW_TOPIC_CREATOR, (Object)NULL_STRING);
        state.setAttribute(NEW_TOPIC_DATE, (Object)NULL_STRING);
        state.setAttribute(NEW_TOPIC_SUBJECT, (Object)NULL_STRING);
        state.setAttribute(ATTACHMENTS, (Object)new ReferenceVector());
    }

    private void initRespondContext(SessionState state) {
        state.setAttribute(RESPOND_MESSAGE_BODY, (Object)NULL_STRING);
        state.setAttribute(RESPOND_MESSAGE_CATEGORY, (Object)NULL_STRING);
        state.setAttribute(RESPOND_MESSAGE_SUBJECT, (Object)NULL_STRING);
        state.setAttribute(RESPOND_TO_TOPIC_ID, (Object)NULL_STRING);
    }

    private void initReviseContext(SessionState state) {
        state.setAttribute(REVISE_MESSAGE_BODY, (Object)NULL_STRING);
        state.setAttribute(REVISE_MESSAGE_CATEGORY, (Object)NULL_STRING);
        state.setAttribute(REVISE_MESSAGE_ID, (Object)NULL_STRING);
        state.setAttribute(REVISE_MESSAGE_SUBJECT, (Object)NULL_STRING);
        state.setAttribute(REVISE_RESPOND_TO_TOPIC_ID, (Object)NULL_STRING);
    }

    private void setShowMessagesList(SessionState state, String category, Vector showMessagesList) {
        Hashtable t = (Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST);
        t.put(category, showMessagesList);
        state.setAttribute(STATE_CATEGORIES_SHOW_LIST, (Object)t);
    }

    private boolean isMessageExpanded(SessionState state, DiscussionMessage message) {
        HashSet s = (HashSet)state.getAttribute(STATE_EXPAND_MESSAGE_LIST);
        return s.contains(message);
    }

    private void setMessageExpanded(SessionState state, DiscussionMessage message, boolean expand) {
        HashSet s = (HashSet)state.getAttribute(STATE_EXPAND_MESSAGE_LIST);
        if (expand) {
            s.add(message);
        } else {
            s.remove(message);
        }
        state.setAttribute(STATE_EXPAND_MESSAGE_LIST, (Object)s);
    }

    private void setCategoryExpanded(SessionState state, String category, boolean expand) {
        HashSet s = (HashSet)state.getAttribute(STATE_EXPAND_CATEGORY_LIST);
        if (expand) {
            s.add(category);
        } else {
            s.remove(category);
        }
        state.setAttribute(STATE_EXPAND_CATEGORY_LIST, (Object)s);
    }

    public void removeShowListMessages(SessionState state, String category, Iterator messages) {
        Hashtable s = (Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST);
        while (messages.hasNext()) {
            Object nextObject = messages.next();
            Vector messageList = (Vector)s.get(category);
            int index = messageList.indexOf((DiscussionMessage)nextObject);
            if (index <= -1) continue;
            messageList.removeElementAt(index);
        }
        state.setAttribute(STATE_CATEGORIES_SHOW_LIST, (Object)s);
    }

    private int getMessageIndexInShowList(SessionState state, String category, String messageId) {
        Vector messageList = (Vector)((Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST)).get(category);
        return messageList.indexOf(messageId);
    }

    public void insertExpandedMessages(SessionState state, String category, Iterator messages, int index) {
        Vector messageList = (Vector)((Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST)).get(category);
        while (messages.hasNext()) {
            messageList.insertElementAt(messages.next(), index);
            ++index;
        }
        this.setShowMessagesList(state, category, messageList);
    }

    private void setCategoryShowList(SessionState state, String category, Vector showList) {
        Hashtable t = (Hashtable)state.getAttribute(STATE_CATEGORIES_SHOW_LIST);
        t.put(category, showList);
        state.setAttribute(STATE_CATEGORIES_SHOW_LIST, (Object)t);
    }

    private void addCategory(SessionState state, DiscussionChannel channel, String category) {
        try {
            DiscussionChannelEdit edit = (DiscussionChannelEdit)DiscussionService.editChannel(channel.getReference());
            edit.addCategory(category);
            DiscussionService.commitChannel(edit);
            HashSet expandedCategories = (HashSet)state.getAttribute(STATE_EXPAND_CATEGORY_LIST);
            expandedCategories.add(category);
            state.setAttribute(STATE_EXPAND_CATEGORY_LIST, (Object)expandedCategories);
        }
        catch (PermissionException ignore) {
        }
        catch (IdUnusedException ignore) {
        }
        catch (InUseException ignore) {
            // empty catch block
        }
    }

    private Vector iterator_to_vector(Iterator l) {
        Vector v = new Vector();
        while (l.hasNext()) {
            v.add(l.next());
        }
        return v;
    }

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        ContentTypeImageService iService;
        DiscussionChannelEdit edit;
        super.initState(state, portlet, rundata);
        PortletConfig config = portlet.getPortletConfig();
        String pageSessionId = rundata.getPageSessionId();
        String elementId = portlet.getID();
        String channelId = (String)state.getAttribute(STATE_CHANNEL_REF);
        if (channelId == null) {
            channelId = StringUtil.trimToNull(config.getInitParameter("channel"));
            if (channelId == null) {
                channelId = DiscussionService.channelReference(PortalService.getCurrentSiteId(), "main");
            }
            state.setAttribute(STATE_CHANNEL_REF, (Object)channelId);
        }
        DiscussionChannel channel = null;
        try {
            channel = DiscussionService.getDiscussionChannel(channelId);
        }
        catch (IdUnusedException e) {
            try {
                edit = DiscussionService.addDiscussionChannel(channelId);
                DiscussionService.commitChannel(edit);
            }
            catch (IdUsedException ee) {
                Log.warn("chef", (Object)((Object)this) + NULL_STRING + ee);
            }
            catch (IdInvalidException ee) {
                Log.warn("chef", (Object)((Object)this) + NULL_STRING + ee);
            }
            catch (PermissionException ee) {
                Log.warn("chef", (Object)((Object)this) + "no permission");
            }
        }
        catch (PermissionException e) {
            // empty catch block
        }
        if (channel != null) {
            String[] configCategories = this.parseCategoryString(StringUtil.trimToNull(config.getInitParameter("categories")));
            if (configCategories != null) {
                try {
                    edit = (DiscussionChannelEdit)DiscussionService.editChannel(channel.getReference());
                    int i = 0;
                    while (i < configCategories.length) {
                        try {
                            edit.addCategory(configCategories[i]);
                        }
                        catch (PermissionException ignore) {
                            // empty catch block
                        }
                        ++i;
                    }
                    DiscussionService.commitChannel(edit);
                }
                catch (InUseException e) {
                }
                catch (IdUnusedException e) {
                }
                catch (PermissionException e) {
                    // empty catch block
                }
            }
            if (state.getAttribute(STATE_CATEGORIES_SHOW_LIST) == null) {
                Hashtable<String, Vector> h = new Hashtable<String, Vector>();
                String[] categories = channel.getCategories();
                if (categories != null) {
                    int i = 0;
                    while (i < categories.length) {
                        h.put(categories[i], this.iterator_to_vector(channel.getTopics(categories[i])));
                        ++i;
                    }
                }
                state.setAttribute(STATE_CATEGORIES_SHOW_LIST, h);
            }
            if (state.getAttribute(STATE_EXPAND_CATEGORY_LIST) == null) {
                HashSet<String> s = new HashSet<String>();
                String[] categories = channel.getCategories();
                if (categories != null) {
                    int i = 0;
                    while (i < categories.length) {
                        s.add(categories[i]);
                        ++i;
                    }
                }
                state.setAttribute(STATE_EXPAND_CATEGORY_LIST, s);
            }
        }
        if ((iService = (ContentTypeImageService)state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE)) == null) {
            iService = (ContentTypeImageService)((Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
            state.setAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE, (Object)iService);
        }
        if (state.getAttribute(STATE_MODE) == null) {
            state.setAttribute(STATE_MODE, (Object)MODE_NORMAL_VIEW);
        }
        if (state.getAttribute(NORMAL_OUTLINE_VIEW_FLAG) == null) {
            state.setAttribute(NORMAL_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.TRUE.toString()));
        }
        if (state.getAttribute(ONE_TOPIC_OUTLINE_VIEW_FLAG) == null) {
            state.setAttribute(ONE_TOPIC_OUTLINE_VIEW_FLAG, (Object)new Boolean(Boolean.TRUE.toString()));
        }
        if (state.getAttribute(STATE_SORTED_BY) == null) {
            state.setAttribute(STATE_SORTED_BY, (Object)STATE_SORTED_BY_DATE);
        }
        if (state.getAttribute(STATE_SORTED_ASC) == null) {
            state.setAttribute(STATE_SORTED_ASC, (Object)Boolean.TRUE.toString());
        }
        if (state.getAttribute(ATTACHMENTS) == null) {
            state.setAttribute(ATTACHMENTS, (Object)new ReferenceVector());
        }
        if (state.getAttribute(STATE_EXPAND_MESSAGE_LIST) == null) {
            state.setAttribute(STATE_EXPAND_MESSAGE_LIST, new HashSet());
        }
    }

    private String[] parseCategoryString(String categories) {
        if (categories == null || categories.trim().length() == 0) {
            return null;
        }
        if (categories.indexOf(CATEGORY_SEPERATOR_STRING) == -1) {
            String[] rv = new String[]{categories};
            return rv;
        }
        return StringUtil.split(categories, CATEGORY_SEPERATOR_STRING);
    }

    private Vector getLastestRepliedTopicInCategory(DiscussionChannel channel, Vector categories) {
        Vector<CategoryLastReply> v = new Vector<CategoryLastReply>();
        int i = 0;
        while (i < categories.size()) {
            String category = (String)categories.get(i);
            Iterator topics = channel.getTopics(category);
            DiscussionMessage mostLatestReplyMessage = null;
            while (topics.hasNext()) {
                DiscussionMessage topic = (DiscussionMessage)topics.next();
                DiscussionMessage lastReplyOfTopic = topic.getLatestReply();
                if (lastReplyOfTopic == null) {
                    lastReplyOfTopic = topic;
                }
                if (mostLatestReplyMessage == null) {
                    mostLatestReplyMessage = lastReplyOfTopic;
                    continue;
                }
                if (!mostLatestReplyMessage.getDiscussionHeader().getDate().before(lastReplyOfTopic.getDiscussionHeader().getDate())) continue;
                mostLatestReplyMessage = lastReplyOfTopic;
            }
            CategoryLastReply cR = new CategoryLastReply(category, mostLatestReplyMessage);
            v.add(cR);
            ++i;
        }
        return v;
    }

    private String[] sortedCategories(DiscussionChannel channel, String sortedBy, String sortedAsc) {
        Object[] categories = channel.getCategories();
        if (categories == null) {
            return null;
        }
        Arrays.sort(categories);
        return categories;
    }

    public void doPermissions(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String channelRefStr = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference channelRef = new Reference(channelRefStr);
        String siteRef = SiteService.siteReference(channelRef.getContext());
        state.setAttribute("permission.realmId", (Object)siteRef);
        state.setAttribute("permission.realmRolesId", (Object)siteRef);
        state.setAttribute("permission.description", (Object)("Set permissions for Discussion in worksite " + SiteService.getSiteDisplay(channelRef.getContext())));
        state.setAttribute("permission.prefix", (Object)"disc.");
        state.setAttribute("pemissions.mode", (Object)"main");
    }

    static {
        CATEGORY_SEPERATOR_STRING = CATEGORY_SEPERATOR_STRING;
        FORM_THREAD_OR_NOT = FORM_THREAD_OR_NOT;
        ATTACHMENTS = ATTACHMENTS;
        STATE_CHANNEL_REF = STATE_CHANNEL_REF;
        STATE_CURRENT_CATEGORY = STATE_CURRENT_CATEGORY;
        STATE_INITIALIZED_FLAG = STATE_INITIALIZED_FLAG;
        STATE_MODE = STATE_MODE;
        STATE_CATEGORIES_SHOW_LIST = STATE_CATEGORIES_SHOW_LIST;
        STATE_SORTED_BY = STATE_SORTED_BY;
        STATE_SORTED_BY_LASTPOSTEDDATE = STATE_SORTED_BY_LASTPOSTEDDATE;
        STATE_SORTED_BY_LASTPOSTEDBY = STATE_SORTED_BY_LASTPOSTEDBY;
        STATE_SORTED_BY_TOPIC = STATE_SORTED_BY_TOPIC;
        STATE_SORTED_BY_SUBJECT = STATE_SORTED_BY_SUBJECT;
        STATE_SORTED_BY_AUTHOR = STATE_SORTED_BY_AUTHOR;
        STATE_SORTED_BY_DATE = STATE_SORTED_BY_DATE;
        STATE_SORTED_BY_CATEGORY_ALPHA = STATE_SORTED_BY_CATEGORY_ALPHA;
        STATE_SORTED_BY_CATEGORY_LASTPOSTEDBY = STATE_SORTED_BY_CATEGORY_LASTPOSTEDBY;
        STATE_SORTED_BY_CATEGORY_LASTPOSTEDDATE = STATE_SORTED_BY_CATEGORY_LASTPOSTEDDATE;
        STATE_SORTED_ASC = STATE_SORTED_ASC;
        STATE_EXPAND_ALL_TOPIC_FLAG = STATE_EXPAND_ALL_TOPIC_FLAG;
        STATE_EXPAND_MESSAGE_LIST = STATE_EXPAND_MESSAGE_LIST;
        STATE_EXPAND_CATEGORY_LIST = STATE_EXPAND_CATEGORY_LIST;
        STATE_FROM_MODE = STATE_FROM_MODE;
        STATE_SHOW_MESSAGE_LIST = STATE_SHOW_MESSAGE_LIST;
        STATE_CONTENT_TYPE_IMAGE_SERVICE = STATE_CONTENT_TYPE_IMAGE_SERVICE;
        NEW_TOPIC_CATEGORY = NEW_TOPIC_CATEGORY;
        NEW_TOPIC_NEW_CATEGORY = NEW_TOPIC_NEW_CATEGORY;
        NEW_TOPIC_DATE = NEW_TOPIC_DATE;
        NEW_TOPIC_CREATOR = NEW_TOPIC_CREATOR;
        NEW_TOPIC_BODY = NEW_TOPIC_BODY;
        NEW_TOPIC_SUBJECT = NEW_TOPIC_SUBJECT;
        NORMAL_OUTLINE_VIEW_FLAG = NORMAL_OUTLINE_VIEW_FLAG;
        ONE_TOPIC_OUTLINE_VIEW_FLAG = ONE_TOPIC_OUTLINE_VIEW_FLAG;
        STATE_CURRENT_TOPIC_ID = STATE_CURRENT_TOPIC_ID;
        STATE_CURRENT_MESSAGE_ID = STATE_CURRENT_MESSAGE_ID;
        STATE_PREVIOUS_TOPIC_ID = STATE_PREVIOUS_TOPIC_ID;
        STATE_NEXT_TOPIC_ID = STATE_NEXT_TOPIC_ID;
        STATE_PREVIOUS_MESSAGE_ID = STATE_PREVIOUS_MESSAGE_ID;
        STATE_NEXT_MESSAGE_ID = STATE_NEXT_MESSAGE_ID;
        RESPOND_MESSAGE_CATEGORY = RESPOND_MESSAGE_CATEGORY;
        RESPOND_TO_TOPIC_ID = RESPOND_TO_TOPIC_ID;
        RESPOND_CREATOR = RESPOND_CREATOR;
        RESPOND_MESSAGE_BODY = RESPOND_MESSAGE_BODY;
        RESPOND_MESSAGE_SUBJECT = RESPOND_MESSAGE_SUBJECT;
        RESPOND_FROM = RESPOND_FROM;
        REVISE_MESSAGE_CATEGORY = REVISE_MESSAGE_CATEGORY;
        REVISE_MESSAGE_ID = REVISE_MESSAGE_ID;
        REVISE_MESSAGE_BODY = REVISE_MESSAGE_BODY;
        REVISE_MESSAGE_SUBJECT = REVISE_MESSAGE_SUBJECT;
        REVISE_RESPOND_TO_TOPIC_ID = REVISE_RESPOND_TO_TOPIC_ID;
        NULL_STRING = NULL_STRING;
        INUSE_HEADER_STRING = INUSE_HEADER_STRING;
        PERMISSION_HEADER_STRING = PERMISSION_HEADER_STRING;
        DELETE_MESSAGE_ID = DELETE_MESSAGE_ID;
        MODE_NORMAL_VIEW = MODE_NORMAL_VIEW;
        MODE_ONE_TOPIC_VIEW = MODE_ONE_TOPIC_VIEW;
        MODE_ONE_MESSAGE_VIEW = MODE_ONE_MESSAGE_VIEW;
        MODE_DELETE_CONFIRM = MODE_DELETE_CONFIRM;
        MODE_RESPOND = MODE_RESPOND;
        MODE_REVISE = MODE_REVISE;
        MODE_NEW_TOPIC = MODE_NEW_TOPIC;
        MODE_NEW_CATEGORY = MODE_NEW_CATEGORY;
        TEMPLATE_NORMAL_VIEW = TEMPLATE_NORMAL_VIEW;
        TEMPLATE_ONE_TOPIC_VIEW = TEMPLATE_ONE_TOPIC_VIEW;
        TEMPLATE_ONE_MESSAGE_VIEW = TEMPLATE_ONE_MESSAGE_VIEW;
        TEMPLATE_DELETE_CONFIRM = TEMPLATE_DELETE_CONFIRM;
        TEMPLATE_RESPOND = TEMPLATE_RESPOND;
        TEMPLATE_REVISE = TEMPLATE_REVISE;
        TEMPLATE_NEW_TOPIC = TEMPLATE_NEW_TOPIC;
        TEMPLATE_NEW_CATEGORY = TEMPLATE_NEW_CATEGORY;
    }

    private class CategoryLastReply {
        String m_category;
        DiscussionMessage m_lastReply;

        public CategoryLastReply(String category, DiscussionMessage lastReply) {
            this.m_category = category;
            this.m_lastReply = lastReply;
        }

        public String getCategory() {
            return this.m_category;
        }

        public void setCategory(String category) {
            this.m_category = category;
        }

        public DiscussionMessage getLastReply() {
            return this.m_lastReply;
        }

        public void setLastReply(DiscussionMessage lastReply) {
            this.m_lastReply = lastReply;
        }
    }

    private class DiscussionComparator
    implements Comparator {
        String m_criteria = null;
        String m_asc = null;

        public DiscussionComparator(String criteria, String asc) {
            this.m_criteria = criteria;
            this.m_asc = asc;
        }

        public int compare(Object o1, Object o2) {
            int result = -1;
            if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_TOPIC) || this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_SUBJECT)) {
                result = ((DiscussionMessage)o1).getDiscussionHeader().getSubject().compareToIgnoreCase(((DiscussionMessage)o2).getDiscussionHeader().getSubject());
            } else if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_DATE)) {
                result = ((DiscussionMessage)o1).getDiscussionHeader().getDate().before(((DiscussionMessage)o2).getDiscussionHeader().getDate()) ? -1 : 1;
            } else if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_LASTPOSTEDDATE)) {
                DiscussionMessage m1 = null;
                DiscussionMessage m2 = null;
                m1 = ((DiscussionMessage)o1).getLatestReply() != null ? ((DiscussionMessage)o1).getLatestReply() : (DiscussionMessage)o1;
                m2 = ((DiscussionMessage)o2).getLatestReply() != null ? ((DiscussionMessage)o2).getLatestReply() : (DiscussionMessage)o2;
                result = m1.getDiscussionHeader().getDate().before(m2.getDiscussionHeader().getDate()) ? -1 : 1;
            } else if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_LASTPOSTEDBY)) {
                DiscussionMessage m1 = null;
                DiscussionMessage m2 = null;
                m1 = ((DiscussionMessage)o1).getLatestReply() != null ? ((DiscussionMessage)o1).getLatestReply() : (DiscussionMessage)o1;
                m2 = ((DiscussionMessage)o2).getLatestReply() != null ? ((DiscussionMessage)o2).getLatestReply() : (DiscussionMessage)o2;
                result = m1.getDiscussionHeader().getFrom().getSortName().compareToIgnoreCase(m2.getDiscussionHeader().getFrom().getSortName());
            } else if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_AUTHOR)) {
                result = ((DiscussionMessage)o1).getDiscussionHeader().getFrom().getSortName().compareToIgnoreCase(((DiscussionMessage)o2).getDiscussionHeader().getFrom().getSortName());
            } else {
                if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_CATEGORY_ALPHA)) {
                    result = ((String)o1).compareToIgnoreCase((String)o2);
                    return result;
                }
                if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_CATEGORY_LASTPOSTEDBY)) {
                    DiscussionMessage m1 = ((CategoryLastReply)o1).getLastReply();
                    DiscussionMessage m2 = ((CategoryLastReply)o2).getLastReply();
                    result = m1 == null ? -1 : (m2 == null ? 1 : m1.getDiscussionHeader().getFrom().getSortName().compareToIgnoreCase(m2.getDiscussionHeader().getFrom().getSortName()));
                } else if (this.m_criteria.equals(DiscussionAction.STATE_SORTED_BY_CATEGORY_LASTPOSTEDDATE)) {
                    DiscussionMessage m1 = ((CategoryLastReply)o1).getLastReply();
                    DiscussionMessage m2 = ((CategoryLastReply)o2).getLastReply();
                    result = m1 == null ? -1 : (m2 == null ? 1 : (m1.getDiscussionHeader().getDate().before(m2.getDiscussionHeader().getDate()) ? -1 : 1));
                }
            }
            if (this.m_asc.equals(Boolean.FALSE.toString())) {
                result = -result;
            }
            return result;
        }
    }
}

