/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class MethodMap {
    Map methodByNameMap = new Hashtable();

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = (ArrayList<Method>)this.methodByNameMap.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] params) throws AmbiguousException {
        List methodList = (List)this.methodByNameMap.get(methodName);
        if (methodList == null) {
            return null;
        }
        Class[] parameterTypes = null;
        Method method = null;
        int numMethods = methodList.size();
        int bestDistance = -2;
        Method bestMethod = null;
        Twonk bestTwonk = null;
        boolean ambiguous = false;
        int i = 0;
        while (i < numMethods) {
            Twonk twonk;
            method = (Method)methodList.get(i);
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == params.length && (twonk = this.calcDistance(params, parameterTypes)) != null) {
                if (bestTwonk == null) {
                    bestTwonk = twonk;
                    bestMethod = method;
                } else {
                    int val = twonk.moreSpecific(bestTwonk);
                    if (val == 0) {
                        ambiguous = true;
                    } else if (val == 1) {
                        ambiguous = false;
                        bestTwonk = twonk;
                        bestMethod = method;
                    }
                }
            }
            ++i;
        }
        if (ambiguous) {
            throw new AmbiguousException();
        }
        return bestMethod;
    }

    private Twonk calcDistance(Object[] set, Class[] base) {
        if (set.length != base.length) {
            return null;
        }
        Twonk twonk = new Twonk(set.length);
        boolean distance = false;
        int i = 0;
        while (i < set.length) {
            Class<?> setclass = set[i].getClass();
            if (!base[i].isAssignableFrom(set[i].getClass())) {
                return null;
            }
            Class<?> c = setclass;
            while (c != null) {
                if (!base[i].isAssignableFrom(c) || base[i].equals(c)) break;
                c = c.getSuperclass();
                ++twonk.distance;
                int n = i;
                twonk.vec[n] = twonk.vec[n] + 1;
            }
            ++i;
        }
        return twonk;
    }

    private class Twonk {
        public int distance;
        public int[] vec;

        public Twonk(int size) {
            this.vec = new int[size];
        }

        public int moreSpecific(Twonk other) {
            if (other.vec.length != this.vec.length) {
                return -1;
            }
            boolean low = false;
            boolean high = false;
            int i = 0;
            while (i < this.vec.length) {
                if (this.vec[i] > other.vec[i]) {
                    high = true;
                } else if (this.vec[i] < other.vec[i]) {
                    low = true;
                }
                ++i;
            }
            if (high && low) {
                return 0;
            }
            if (high && !low) {
                return -1;
            }
            if (!high && low) {
                return 1;
            }
            return 1;
        }
    }

    public class AmbiguousException
    extends Exception {
    }
}

