
/* Linux only, for port access ... see mmio.h */
#include <sys/io.h>

#include "local.h"
#include "tv_i2c.h"
#include "backend.h"

#include "tester.h"
#include "test_record.h"

CardPtr mmio_card = NULL;

void 
mmio_port_perm (unsigned long from, unsigned long num, int turn_on)
{
  printf ("perm %04X - %04X %s\n", from, from+num, turn_on ? "on" : "off");
}

CARD32 mmio_phys (void *base)
{
  if (mmio_card && mmio_card->reg_mapped) {
    return (CARD32) (base - mmio_card->reg_mapped);
  } else {
    return (CARD32) base;
  }
}

CARD8 
mmio_in8 (void* base, unsigned offset)
{
  register CARD8 tmp;

  if (testopt_snoop) {
    tmp = *(volatile CARD8 *)(((CARD8*)(base)) + (offset));
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT8, "in ");
  } else {
    tmp = recordRead (ZONE_MMIO, (CARD32) base + offset, BIT8, "in ");
  }
  return tmp;
}

CARD16
mmio_in16 (void* base, unsigned offset)
{
  register CARD16 tmp;

  if (testopt_snoop) {
    tmp = *(volatile CARD16 *)(void *)(((CARD8*)(base)) + (offset));
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT16, "in ");
  } else {
    tmp = recordRead (ZONE_MMIO, (CARD32) base + offset, BIT16, "in ");
  }
  return tmp;
}

CARD32
mmio_in32 (void* base, unsigned offset)
{
  register CARD32 tmp;

  if (testopt_snoop) {
    tmp = *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset));
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT32, "in ");
  } else {
    tmp =recordRead (ZONE_MMIO, (CARD32) base + offset, BIT32, "in ");
  }
  return tmp;
}

void
mmio_out8 (void* base, unsigned offset, CARD8 val)
{
  if (testopt_snoop) {
    *(volatile CARD8 *)(((CARD8*)(base)) + (offset)) = (val);
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, val, BIT8, "out");
  } else {
    recordWrite (ZONE_MMIO, (CARD32) base + offset, val, BIT8, "out");
  }
}

void
mmio_out16 (void* base, unsigned offset, CARD16 val)
{
  if (testopt_snoop) {
    *(volatile CARD16 *)(void *)(((CARD8*)(base)) + (offset)) = (val);
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, val, BIT16, "out");
  } else {
    recordWrite (ZONE_MMIO, (CARD32) base + offset, val, BIT16, "out");
  }
}

void
mmio_out32 (void* base, unsigned offset, CARD32 val)
{
  if (testopt_snoop) {
    *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset)) = (val);
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, val, BIT32, "out");
  } else {
    recordWrite (ZONE_MMIO, (CARD32) base + offset, val, BIT32, "out");
  } 
}


void
mmio_and32 (void* base, unsigned offset, CARD32 val)
{
  register CARD32 tmp;

  if (testopt_snoop) {
    tmp = *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset));
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT32, "== ");
    tmp &= val;
    *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset)) = tmp;
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT32, "and");
  } else {
    tmp = recordRead (ZONE_MMIO, (CARD32) base + offset, BIT32, "== ");
    recordWrite (ZONE_MMIO, (CARD32) base + offset, tmp & val, BIT32, "and");
  }
}

void
mmio_or32 (void* base, unsigned offset, CARD32 val)
{
  register CARD32 tmp;

  if (testopt_snoop) {
    tmp = *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset));
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT32, "== ");
    tmp |= val;
    *(volatile CARD32 *)(void *)(((CARD8*)(base)) + (offset)) = tmp;
    recordWrite (ZONE_MMIO, mmio_phys (base) + offset, tmp, BIT32, "or ");
  } else {
    tmp = recordRead (ZONE_MMIO, (CARD32) base + offset, BIT32, "== ");
    recordWrite (ZONE_MMIO, (CARD32) base + offset, tmp | val, BIT32, "or ");
  }
}

CARD8 
port_inb (CARD16 port)
{
  register CARD8 tmp;

  if (testopt_snoop) {
    tmp = inb(port);
    recordWrite (ZONE_PORT, port, tmp, BIT8, "in ");
  } else {
    tmp = recordRead (ZONE_PORT, port, BIT8, "in ");
  }
  return tmp;
}

CARD16 
port_inw (CARD16 port)
{
  register CARD16 tmp;

  if (testopt_snoop) {
    tmp = inw(port);
    recordWrite (ZONE_PORT, (CARD32) port, tmp, BIT16, "in ");
  } else {
    tmp = recordRead (ZONE_PORT, (CARD32) port, BIT16, "in ");
  }
  return tmp;
}

void 
port_outb (CARD16 port, CARD8 val)
{
  if (testopt_snoop) outb (val, port);
  recordWrite (ZONE_PORT, (CARD32) port, val, BIT8, "out");
}

void 
port_outw (CARD16 port, CARD16 val)
{
  if (testopt_snoop) outw (val, port);
  recordWrite (ZONE_PORT, (CARD32) port, val, BIT16, "out");
}

