//------------------------------------------------------------------------------
// Author: Alexey Costroma
// Generated by rpcgen with minor compatibility fixes 
// Description: All RFC3530 declared structures.
// Copyright (c) 2014 EPAM Systems
//------------------------------------------------------------------------------
/*
    This file is part of Nfstrace.

    Nfstrace is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 2 of the License.

    Nfstrace is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Nfstrace.  If not, see <http://www.gnu.org/licenses/>.
*/
//------------------------------------------------------------------------------
#ifndef NFS4_TYPES_RPCGEN_H
#define NFS4_TYPES_RPCGEN_H
//------------------------------------------------------------------------------
#include <rpc/rpc.h>
//------------------------------------------------------------------------------
namespace NST
{
namespace API
{
namespace NFS4
{

#ifndef RPCSEC_GSS
#define RPCSEC_GSS 6
#endif

const uint32_t NFS4_FHSIZE        {128};
const uint32_t NFS4_VERIFIER_SIZE {8};
const uint32_t NFS4_OPAQUE_LIMIT  {1024};

typedef int int32_t;

typedef u_int uint32_t;

typedef quad_t int64_t;

typedef u_quad_t uint64_t;

enum nfs_ftype4 {
    NF4REG = 1,
    NF4DIR = 2,
    NF4BLK = 3,
    NF4CHR = 4,
    NF4LNK = 5,
    NF4SOCK = 6,
    NF4FIFO = 7,
    NF4ATTRDIR = 8,
    NF4NAMEDATTR = 9,
};
typedef enum nfs_ftype4 nfs_ftype4;

enum nfsstat4 {
    NFS4_OK = 0,
    NFS4ERR_PERM = 1,
    NFS4ERR_NOENT = 2,
    NFS4ERR_IO = 5,
    NFS4ERR_NXIO = 6,
    NFS4ERR_ACCESS = 13,
    NFS4ERR_EXIST = 17,
    NFS4ERR_XDEV = 18,
    NFS4ERR_NOTDIR = 20,
    NFS4ERR_ISDIR = 21,
    NFS4ERR_INVAL = 22,
    NFS4ERR_FBIG = 27,
    NFS4ERR_NOSPC = 28,
    NFS4ERR_ROFS = 30,
    NFS4ERR_MLINK = 31,
    NFS4ERR_NAMETOOLONG = 63,
    NFS4ERR_NOTEMPTY = 66,
    NFS4ERR_DQUOT = 69,
    NFS4ERR_STALE = 70,
    NFS4ERR_BADHANDLE = 10001,
    NFS4ERR_BAD_COOKIE = 10003,
    NFS4ERR_NOTSUPP = 10004,
    NFS4ERR_TOOSMALL = 10005,
    NFS4ERR_SERVERFAULT = 10006,
    NFS4ERR_BADTYPE = 10007,
    NFS4ERR_DELAY = 10008,
    NFS4ERR_SAME = 10009,
    NFS4ERR_DENIED = 10010,
    NFS4ERR_EXPIRED = 10011,
    NFS4ERR_LOCKED = 10012,
    NFS4ERR_GRACE = 10013,
    NFS4ERR_FHEXPIRED = 10014,
    NFS4ERR_SHARE_DENIED = 10015,
    NFS4ERR_WRONGSEC = 10016,
    NFS4ERR_CLID_INUSE = 10017,
    NFS4ERR_RESOURCE = 10018,
    NFS4ERR_MOVED = 10019,
    NFS4ERR_NOFILEHANDLE = 10020,
    NFS4ERR_MINOR_VERS_MISMATCH = 10021,
    NFS4ERR_STALE_CLIENTID = 10022,
    NFS4ERR_STALE_STATEID = 10023,
    NFS4ERR_OLD_STATEID = 10024,
    NFS4ERR_BAD_STATEID = 10025,
    NFS4ERR_BAD_SEQID = 10026,
    NFS4ERR_NOT_SAME = 10027,
    NFS4ERR_LOCK_RANGE = 10028,
    NFS4ERR_SYMLINK = 10029,
    NFS4ERR_RESTOREFH = 10030,
    NFS4ERR_LEASE_MOVED = 10031,
    NFS4ERR_ATTRNOTSUPP = 10032,
    NFS4ERR_NO_GRACE = 10033,
    NFS4ERR_RECLAIM_BAD = 10034,
    NFS4ERR_RECLAIM_CONFLICT = 10035,
    NFS4ERR_BADXDR = 10036,
    NFS4ERR_LOCKS_HELD = 10037,
    NFS4ERR_OPENMODE = 10038,
    NFS4ERR_BADOWNER = 10039,
    NFS4ERR_BADCHAR = 10040,
    NFS4ERR_BADNAME = 10041,
    NFS4ERR_BAD_RANGE = 10042,
    NFS4ERR_LOCK_NOTSUPP = 10043,
    NFS4ERR_OP_ILLEGAL = 10044,
    NFS4ERR_DEADLOCK = 10045,
    NFS4ERR_FILE_OPEN = 10046,
    NFS4ERR_ADMIN_REVOKED = 10047,
    NFS4ERR_CB_PATH_DOWN = 10048,
};
typedef enum nfsstat4 nfsstat4;

typedef struct {
    u_int bitmap4_len;
    uint32_t *bitmap4_val;
} bitmap4;

typedef uint64_t offset4;

typedef uint32_t count4;

typedef uint64_t length4;

typedef uint64_t clientid4;

typedef uint32_t seqid4;

typedef struct {
    u_int utf8string_len;
    char *utf8string_val;
} utf8string;

typedef utf8string utf8str_cis;

typedef utf8string utf8str_cs;

typedef utf8string utf8str_mixed;

typedef utf8str_cs component4;

typedef struct {
    u_int pathname4_len;
    component4 *pathname4_val;
} pathname4;

typedef uint64_t nfs_lockid4;

typedef uint64_t nfs_cookie4;

typedef utf8str_cs linktext4;

typedef struct {
    u_int sec_oid4_len;
    char *sec_oid4_val;
} sec_oid4;

typedef uint32_t qop4;

typedef uint32_t mode4;

typedef uint64_t changeid4;

typedef char verifier4[NFS4_VERIFIER_SIZE];

struct nfstime4 {
    int64_t seconds;
    uint32_t nseconds;
};
typedef struct nfstime4 nfstime4;

enum time_how4 {
    SET_TO_SERVER_TIME4 = 0,
    SET_TO_CLIENT_TIME4 = 1,
};
typedef enum time_how4 time_how4;

struct settime4 {
    time_how4 set_it;
    union {
        nfstime4 time;
    } settime4_u;
};
typedef struct settime4 settime4;

typedef struct {
    u_int nfs_fh4_len;
    char *nfs_fh4_val;
} nfs_fh4;

struct fsid4 {
    uint64_t major;
    uint64_t minor;
};
typedef struct fsid4 fsid4;

struct fs_location4 {
    struct {
        u_int server_len;
        utf8str_cis *server_val;
    } server;
    pathname4 rootpath;
};
typedef struct fs_location4 fs_location4;

struct fs_locations4 {
    pathname4 fs_root;
    struct {
        u_int locations_len;
        fs_location4 *locations_val;
    } locations;
};
typedef struct fs_locations4 fs_locations4;

typedef uint32_t fattr4_aclsupport;
const fattr4_aclsupport ACL4_SUPPORT_ALLOW_ACL {0x00000001};
const fattr4_aclsupport ACL4_SUPPORT_DENY_ACL {0x00000002};
const fattr4_aclsupport ACL4_SUPPORT_AUDIT_ACL {0x00000004};
const fattr4_aclsupport ACL4_SUPPORT_ALARM_ACL {0x00000008};

typedef uint32_t acetype4;
const acetype4 ACE4_ACCESS_ALLOWED_ACE_TYPE {0x00000000};
const acetype4 ACE4_ACCESS_DENIED_ACE_TYPE {0x00000001};
const acetype4 ACE4_SYSTEM_AUDIT_ACE_TYPE {0x00000002};
const acetype4 ACE4_SYSTEM_ALARM_ACE_TYPE {0x00000003};

typedef uint32_t aceflag4;
const aceflag4 ACE4_FILE_INHERIT_ACE {0x00000001};
const aceflag4 ACE4_DIRECTORY_INHERIT_ACE {0x00000002};
const aceflag4 ACE4_NO_PROPAGATE_INHERIT_ACE {0x00000004};
const aceflag4 ACE4_INHERIT_ONLY_ACE {0x00000008};
const aceflag4 ACE4_SUCCESSFUL_ACCESS_ACE_FLAG {0x00000010};
const aceflag4 ACE4_FAILED_ACCESS_ACE_FLAG {0x00000020};
const aceflag4 ACE4_IDENTIFIER_GROUP {0x00000040};
const aceflag4 ACE4_INHERITED_ACE {0x00000080};

typedef uint32_t acemask4;
const acemask4 ACE4_READ_DATA {0x00000001};
const acemask4 ACE4_LIST_DIRECTORY {0x00000001};
const acemask4 ACE4_WRITE_DATA {0x00000002};
const acemask4 ACE4_ADD_FILE {0x00000002};
const acemask4 ACE4_APPEND_DATA {0x00000004};
const acemask4 ACE4_ADD_SUBDIRECTORY {0x00000004};
const acemask4 ACE4_READ_NAMED_ATTRS {0x00000008};
const acemask4 ACE4_WRITE_NAMED_ATTRS {0x00000010};
const acemask4 ACE4_EXECUTE {0x00000020};
const acemask4 ACE4_DELETE_CHILD {0x00000040};
const acemask4 ACE4_READ_ATTRIBUTES {0x00000080};
const acemask4 ACE4_WRITE_ATTRIBUTES {0x00000100};
const acemask4 ACE4_WRITE_RETENTION {0x00000200};
const acemask4 ACE4_WRITE_RETENTION_HOLD {0x00000400};
const acemask4 ACE4_DELETE {0x00010000};
const acemask4 ACE4_READ_ACL {0x00020000};
const acemask4 ACE4_WRITE_ACL {0x00040000};
const acemask4 ACE4_WRITE_OWNER {0x00080000};
const acemask4 ACE4_SYNCHRONIZE {0x00100000};
const acemask4 ACE4_GENERIC_READ {0x00120081};
const acemask4 ACE4_GENERIC_WRITE {0x00160106};
const acemask4 ACE4_GENERIC_EXECUTE {0x001200A0};

struct nfsace4 {
    acetype4 type;
    aceflag4 flag;
    acemask4 access_mask;
    utf8str_mixed who;
};
typedef struct nfsace4 nfsace4;
const mode4 MODE4_SUID {0x800};
const mode4 MODE4_SGID {0x400};
const mode4 MODE4_SVTX {0x200};
const mode4 MODE4_RUSR {0x100};
const mode4 MODE4_WUSR {0x080};
const mode4 MODE4_XUSR {0x040};
const mode4 MODE4_RGRP {0x020};
const mode4 MODE4_WGRP {0x010};
const mode4 MODE4_XGRP {0x008};
const mode4 MODE4_ROTH {0x004};
const mode4 MODE4_WOTH {0x002};
const mode4 MODE4_XOTH {0x001};

struct specdata4 {
    uint32_t specdata1;
    uint32_t specdata2;
};
typedef struct specdata4 specdata4;
const uint32_t FH4_PERSISTENT {0x00000000};
const uint32_t FH4_NOEXPIRE_WITH_OPEN {0x00000001};
const uint32_t FH4_VOLATILE_ANY {0x00000002};
const uint32_t FH4_VOL_MIGRATION {0x00000004};
const uint32_t FH4_VOL_RENAME {0x00000008};

typedef bitmap4 fattr4_supported_attrs;

typedef nfs_ftype4 fattr4_type;

typedef uint32_t fattr4_fh_expire_type;

typedef changeid4 fattr4_change;

typedef uint64_t fattr4_size;

typedef bool_t fattr4_link_support;

typedef bool_t fattr4_symlink_support;

typedef bool_t fattr4_named_attr;

typedef fsid4 fattr4_fsid;

typedef bool_t fattr4_unique_handles;

typedef uint32_t fattr4_lease_time;

typedef nfsstat4 fattr4_rdattr_error;

typedef struct {
    u_int fattr4_acl_len;
    nfsace4 *fattr4_acl_val;
} fattr4_acl;

typedef bool_t fattr4_archive;

typedef bool_t fattr4_cansettime;

typedef bool_t fattr4_case_insensitive;

typedef bool_t fattr4_case_preserving;

typedef bool_t fattr4_chown_restricted;

typedef uint64_t fattr4_fileid;

typedef uint64_t fattr4_files_avail;

typedef nfs_fh4 fattr4_filehandle;

typedef uint64_t fattr4_files_free;

typedef uint64_t fattr4_files_total;

typedef fs_locations4 fattr4_fs_locations;

typedef bool_t fattr4_hidden;

typedef bool_t fattr4_homogeneous;

typedef uint64_t fattr4_maxfilesize;

typedef uint32_t fattr4_maxlink;

typedef uint32_t fattr4_maxname;

typedef uint64_t fattr4_maxread;

typedef uint64_t fattr4_maxwrite;

typedef utf8str_cs fattr4_mimetype;

typedef mode4 fattr4_mode;

typedef uint64_t fattr4_mounted_on_fileid;

typedef bool_t fattr4_no_trunc;

typedef uint32_t fattr4_numlinks;

typedef utf8str_mixed fattr4_owner;

typedef utf8str_mixed fattr4_owner_group;

typedef uint64_t fattr4_quota_avail_hard;

typedef uint64_t fattr4_quota_avail_soft;

typedef uint64_t fattr4_quota_used;

typedef specdata4 fattr4_rawdev;

typedef uint64_t fattr4_space_avail;

typedef uint64_t fattr4_space_free;

typedef uint64_t fattr4_space_total;

typedef uint64_t fattr4_space_used;

typedef bool_t fattr4_system;

typedef nfstime4 fattr4_time_access;

typedef settime4 fattr4_time_access_set;

typedef nfstime4 fattr4_time_backup;

typedef nfstime4 fattr4_time_create;

typedef nfstime4 fattr4_time_delta;

typedef nfstime4 fattr4_time_metadata;

typedef nfstime4 fattr4_time_modify;

typedef settime4 fattr4_time_modify_set;
const uint32_t FATTR4_SUPPORTED_ATTRS {0};
const uint32_t FATTR4_TYPE {1};
const uint32_t FATTR4_FH_EXPIRE_TYPE {2};
const uint32_t FATTR4_CHANGE {3};
const uint32_t FATTR4_SIZE {4};
const uint32_t FATTR4_LINK_SUPPORT {5};
const uint32_t FATTR4_SYMLINK_SUPPORT {6};
const uint32_t FATTR4_NAMED_ATTR {7};
const uint32_t FATTR4_FSID {8};
const uint32_t FATTR4_UNIQUE_HANDLES {9};
const uint32_t FATTR4_LEASE_TIME {10};
const uint32_t FATTR4_RDATTR_ERROR {11};
const uint32_t FATTR4_FILEHANDLE {19};
const uint32_t FATTR4_ACL {12};
const uint32_t FATTR4_ACLSUPPORT {13};
const uint32_t FATTR4_ARCHIVE {14};
const uint32_t FATTR4_CANSETTIME {15};
const uint32_t FATTR4_CASE_INSENSITIVE {16};
const uint32_t FATTR4_CASE_PRESERVING {17};
const uint32_t FATTR4_CHOWN_RESTRICTED {18};
const uint32_t FATTR4_FILEID {20};
const uint32_t FATTR4_FILES_AVAIL {21};
const uint32_t FATTR4_FILES_FREE {22};
const uint32_t FATTR4_FILES_TOTAL {23};
const uint32_t FATTR4_FS_LOCATIONS {24};
const uint32_t FATTR4_HIDDEN {25};
const uint32_t FATTR4_HOMOGENEOUS {26};
const uint32_t FATTR4_MAXFILESIZE {27};
const uint32_t FATTR4_MAXLINK {28};
const uint32_t FATTR4_MAXNAME {29};
const uint32_t FATTR4_MAXREAD {30};
const uint32_t FATTR4_MAXWRITE {31};
const uint32_t FATTR4_MIMETYPE {32};
const uint32_t FATTR4_MODE {33};
const uint32_t FATTR4_NO_TRUNC {34};
const uint32_t FATTR4_NUMLINKS {35};
const uint32_t FATTR4_OWNER {36};
const uint32_t FATTR4_OWNER_GROUP {37};
const uint32_t FATTR4_QUOTA_AVAIL_HARD {38};
const uint32_t FATTR4_QUOTA_AVAIL_SOFT {39};
const uint32_t FATTR4_QUOTA_USED {40};
const uint32_t FATTR4_RAWDEV {41};
const uint32_t FATTR4_SPACE_AVAIL {42};
const uint32_t FATTR4_SPACE_FREE {43};
const uint32_t FATTR4_SPACE_TOTAL {44};
const uint32_t FATTR4_SPACE_USED {45};
const uint32_t FATTR4_SYSTEM {46};
const uint32_t FATTR4_TIME_ACCESS {47};
const uint32_t FATTR4_TIME_ACCESS_SET {48};
const uint32_t FATTR4_TIME_BACKUP {49};
const uint32_t FATTR4_TIME_CREATE {50};
const uint32_t FATTR4_TIME_DELTA {51};
const uint32_t FATTR4_TIME_METADATA {52};
const uint32_t FATTR4_TIME_MODIFY {53};
const uint32_t FATTR4_TIME_MODIFY_SET {54};
const uint32_t FATTR4_MOUNTED_ON_FILEID {55};

typedef struct {
    u_int attrlist4_len;
    char *attrlist4_val;
} attrlist4;

struct fattr4 {
    bitmap4 attrmask;
    attrlist4 attr_vals;
};
typedef struct fattr4 fattr4;

struct change_info4 {
    bool_t atomic;
    changeid4 before;
    changeid4 after;
};
typedef struct change_info4 change_info4;

struct clientaddr4 {
    char *r_netid;
    char *r_addr;
};
typedef struct clientaddr4 clientaddr4;

struct cb_client4 {
    uint32_t cb_program;
    clientaddr4 cb_location;
};
typedef struct cb_client4 cb_client4;

struct stateid4 {
    uint32_t seqid;
    char other[12];
};
typedef struct stateid4 stateid4;

struct nfs_client_id4 {
    verifier4 verifier;
    struct {
        u_int id_len;
        char *id_val;
    } id;
};
typedef struct nfs_client_id4 nfs_client_id4;

struct open_owner4 {
    clientid4 clientid;
    struct {
        u_int owner_len;
        char *owner_val;
    } owner;
};
typedef struct open_owner4 open_owner4;

struct lock_owner4 {
    clientid4 clientid;
    struct {
        u_int owner_len;
        char *owner_val;
    } owner;
};
typedef struct lock_owner4 lock_owner4;

enum nfs_lock_type4 {
    READ_LT = 1,
    WRITE_LT = 2,
    READW_LT = 3,
    WRITEW_LT = 4,
};
typedef enum nfs_lock_type4 nfs_lock_type4;
const uint32_t ACCESS4_READ {0x00000001};
const uint32_t ACCESS4_LOOKUP {0x00000002};
const uint32_t ACCESS4_MODIFY {0x00000004};
const uint32_t ACCESS4_EXTEND {0x00000008};
const uint32_t ACCESS4_DELETE {0x00000010};
const uint32_t ACCESS4_EXECUTE {0x00000020};

// for compatibility
struct NULL4args
{
    bool t {};
};
typedef struct NULL4args NULL4args;

// for compatibility
struct NULL4res
{
    bool t {};
};
typedef struct NULL4res NULL4res;

struct ACCESS4args {
    uint32_t access;
};
typedef struct ACCESS4args ACCESS4args;

struct ACCESS4resok {
    uint32_t supported;
    uint32_t access;
};
typedef struct ACCESS4resok ACCESS4resok;

struct ACCESS4res {
    nfsstat4 status;
    union {
        ACCESS4resok resok4;
    } ACCESS4res_u;
};
typedef struct ACCESS4res ACCESS4res;

struct CLOSE4args {
    seqid4 seqid;
    stateid4 open_stateid;
};
typedef struct CLOSE4args CLOSE4args;

struct CLOSE4res {
    nfsstat4 status;
    union {
        stateid4 open_stateid;
    } CLOSE4res_u;
};
typedef struct CLOSE4res CLOSE4res;

struct COMMIT4args {
    offset4 offset;
    count4 count;
};
typedef struct COMMIT4args COMMIT4args;

struct COMMIT4resok {
    verifier4 writeverf;
};
typedef struct COMMIT4resok COMMIT4resok;

struct COMMIT4res {
    nfsstat4 status;
    union {
        COMMIT4resok resok4;
    } COMMIT4res_u;
};
typedef struct COMMIT4res COMMIT4res;

struct createtype4 {
    nfs_ftype4 type;
    union {
        linktext4 linkdata;
        specdata4 devdata;
    } createtype4_u;
};
typedef struct createtype4 createtype4;

struct CREATE4args {
    createtype4 objtype;
    component4 objname;
    fattr4 createattrs;
};
typedef struct CREATE4args CREATE4args;

struct CREATE4resok {
    change_info4 cinfo;
    bitmap4 attrset;
};
typedef struct CREATE4resok CREATE4resok;

struct CREATE4res {
    nfsstat4 status;
    union {
        CREATE4resok resok4;
    } CREATE4res_u;
};
typedef struct CREATE4res CREATE4res;

struct DELEGPURGE4args {
    clientid4 clientid;
};
typedef struct DELEGPURGE4args DELEGPURGE4args;

struct DELEGPURGE4res {
    nfsstat4 status;
};
typedef struct DELEGPURGE4res DELEGPURGE4res;

struct DELEGRETURN4args {
    stateid4 deleg_stateid;
};
typedef struct DELEGRETURN4args DELEGRETURN4args;

struct DELEGRETURN4res {
    nfsstat4 status;
};
typedef struct DELEGRETURN4res DELEGRETURN4res;

struct GETATTR4args {
    bitmap4 attr_request;
};
typedef struct GETATTR4args GETATTR4args;

struct GETATTR4resok {
    fattr4 obj_attributes;
};
typedef struct GETATTR4resok GETATTR4resok;

struct GETATTR4res {
    nfsstat4 status;
    union {
        GETATTR4resok resok4;
    } GETATTR4res_u;
};
typedef struct GETATTR4res GETATTR4res;
const uint32_t DIR_NOTIFICATION_NONE {0x00000000};
const uint32_t DIR_NOTIFICATION_CHANGE_ENTRY_ATTRIBUTES {0x00000001};
const uint32_t DIR_NOTIFICATION_CHANGE_DIR_ATTRIBUTES {0x00000002};
const uint32_t DIR_NOTIFICATION_REMOVE_ENTRY {0x00000004};
const uint32_t DIR_NOTIFICATION_ADD_ENTRY {0x00000008};
const uint32_t DIR_NOTIFICATION_RENAME_ENTRY {0x00000010};
const uint32_t DIR_NOTIFICATION_CHANGE_COOKIE_VERIFIER {0x00000020};

typedef bitmap4 notification_types4;

typedef nfstime4 notification_delay4;

enum dir_delegation_status4 {
    NFS4_DIR_DELEGATION_NONE = 0,
    NFS4_DIR_DELEGATION_READ = 1,
    NFS4_DIR_DELEGATION_DENIED = 2,
    NFS4_DIR_DELEGATION_UNAVAIL = 3,
};
typedef enum dir_delegation_status4 dir_delegation_status4;

struct GET_DIR_DELEGATION4args {
    clientid4 clientid;
    notification_types4 notif_types;
    notification_delay4 dir_notif_delay;
    notification_delay4 dir_entry_notif_delay;
};
typedef struct GET_DIR_DELEGATION4args GET_DIR_DELEGATION4args;

struct GET_DIR_DELEGATION4resok {
    stateid4 stateid;
    dir_delegation_status4 status;
    notification_types4 notif_types;
    bitmap4 dir_notif_attrs;
    bitmap4 dir_entry_notif_attrs;
};
typedef struct GET_DIR_DELEGATION4resok GET_DIR_DELEGATION4resok;

struct GET_DIR_DELEGATION4res {
    nfsstat4 status;
    union {
        GET_DIR_DELEGATION4resok resok4;
    } GET_DIR_DELEGATION4res_u;
};
typedef struct GET_DIR_DELEGATION4res GET_DIR_DELEGATION4res;

struct GETFH4resok {
    nfs_fh4 object;
};
typedef struct GETFH4resok GETFH4resok;

struct GETFH4res {
    nfsstat4 status;
    union {
        GETFH4resok resok4;
    } GETFH4res_u;
};
typedef struct GETFH4res GETFH4res;

struct LINK4args {
    component4 newname;
};
typedef struct LINK4args LINK4args;

struct LINK4resok {
    change_info4 cinfo;
};
typedef struct LINK4resok LINK4resok;

struct LINK4res {
    nfsstat4 status;
    union {
        LINK4resok resok4;
    } LINK4res_u;
};
typedef struct LINK4res LINK4res;

struct open_to_lock_owner4 {
    seqid4 open_seqid;
    stateid4 open_stateid;
    seqid4 lock_seqid;
    lock_owner4 lock_owner;
};
typedef struct open_to_lock_owner4 open_to_lock_owner4;

struct exist_lock_owner4 {
    stateid4 lock_stateid;
    seqid4 lock_seqid;
};
typedef struct exist_lock_owner4 exist_lock_owner4;

struct locker4 {
    bool_t new_lock_owner;
    union {
        open_to_lock_owner4 open_owner;
        exist_lock_owner4 lock_owner;
    } locker4_u;
};
typedef struct locker4 locker4;

struct LOCK4args {
    nfs_lock_type4 locktype;
    bool_t reclaim;
    offset4 offset;
    length4 length;
    locker4 locker;
};
typedef struct LOCK4args LOCK4args;

struct LOCK4denied {
    offset4 offset;
    length4 length;
    nfs_lock_type4 locktype;
    lock_owner4 owner;
};
typedef struct LOCK4denied LOCK4denied;

struct LOCK4resok {
    stateid4 lock_stateid;
};
typedef struct LOCK4resok LOCK4resok;

struct LOCK4res {
    nfsstat4 status;
    union {
        LOCK4resok resok4;
        LOCK4denied denied;
    } LOCK4res_u;
};
typedef struct LOCK4res LOCK4res;

struct LOCKT4args {
    nfs_lock_type4 locktype;
    offset4 offset;
    length4 length;
    lock_owner4 owner;
};
typedef struct LOCKT4args LOCKT4args;

struct LOCKT4res {
    nfsstat4 status;
    union {
        LOCK4denied denied;
    } LOCKT4res_u;
};
typedef struct LOCKT4res LOCKT4res;

struct LOCKU4args {
    nfs_lock_type4 locktype;
    seqid4 seqid;
    stateid4 lock_stateid;
    offset4 offset;
    length4 length;
};
typedef struct LOCKU4args LOCKU4args;

struct LOCKU4res {
    nfsstat4 status;
    union {
        stateid4 lock_stateid;
    } LOCKU4res_u;
};
typedef struct LOCKU4res LOCKU4res;

struct LOOKUP4args {
    component4 objname;
};
typedef struct LOOKUP4args LOOKUP4args;

struct LOOKUP4res {
    nfsstat4 status;
};
typedef struct LOOKUP4res LOOKUP4res;

struct LOOKUPP4res {
    nfsstat4 status;
};
typedef struct LOOKUPP4res LOOKUPP4res;

struct NVERIFY4args {
    fattr4 obj_attributes;
};
typedef struct NVERIFY4args NVERIFY4args;

struct NVERIFY4res {
    nfsstat4 status;
};
typedef struct NVERIFY4res NVERIFY4res;

enum createmode4 {
    UNCHECKED4 = 0,
    GUARDED4 = 1,
    EXCLUSIVE4 = 2,
};
typedef enum createmode4 createmode4;

struct createhow4 {
    createmode4 mode;
    union {
        fattr4 createattrs;
        verifier4 createverf;
    } createhow4_u;
};
typedef struct createhow4 createhow4;

enum opentype4 {
    OPEN4_NOCREATE = 0,
    OPEN4_CREATE = 1,
};
typedef enum opentype4 opentype4;

struct openflag4 {
    opentype4 opentype;
    union {
        createhow4 how;
    } openflag4_u;
};
typedef struct openflag4 openflag4;

enum limit_by4 {
    NFS_LIMIT_SIZE = 1,
    NFS_LIMIT_BLOCKS = 2,
};
typedef enum limit_by4 limit_by4;

struct nfs_modified_limit4 {
    uint32_t num_blocks;
    uint32_t bytes_per_block;
};
typedef struct nfs_modified_limit4 nfs_modified_limit4;

struct nfs_space_limit4 {
    limit_by4 limitby;
    union {
        uint64_t filesize;
        nfs_modified_limit4 mod_blocks;
    } nfs_space_limit4_u;
};
typedef struct nfs_space_limit4 nfs_space_limit4;
const uint32_t OPEN4_SHARE_ACCESS_READ {0x00000001};
const uint32_t OPEN4_SHARE_ACCESS_WRITE {0x00000002};
const uint32_t OPEN4_SHARE_ACCESS_BOTH {0x00000003};
const uint32_t OPEN4_SHARE_DENY_NONE {0x00000000};
const uint32_t OPEN4_SHARE_DENY_READ {0x00000001};
const uint32_t OPEN4_SHARE_DENY_WRITE {0x00000002};
const uint32_t OPEN4_SHARE_DENY_BOTH {0x00000003};

enum open_delegation_type4 {
    OPEN_DELEGATE_NONE = 0,
    OPEN_DELEGATE_READ = 1,
    OPEN_DELEGATE_WRITE = 2,
};
typedef enum open_delegation_type4 open_delegation_type4;

enum open_claim_type4 {
    CLAIM_NULL = 0,
    CLAIM_PREVIOUS = 1,
    CLAIM_DELEGATE_CUR = 2,
    CLAIM_DELEGATE_PREV = 3,
};
typedef enum open_claim_type4 open_claim_type4;

struct open_claim_delegate_cur4 {
    stateid4 delegate_stateid;
    component4 file;
};
typedef struct open_claim_delegate_cur4 open_claim_delegate_cur4;

struct open_claim4 {
    open_claim_type4 claim;
    union {
        component4 file;
        open_delegation_type4 delegate_type;
        open_claim_delegate_cur4 delegate_cur_info;
        component4 file_delegate_prev;
    } open_claim4_u;
};
typedef struct open_claim4 open_claim4;

struct OPEN4args {
    seqid4 seqid;
    uint32_t share_access;
    uint32_t share_deny;
    open_owner4 owner;
    openflag4 openhow;
    open_claim4 claim;
};
typedef struct OPEN4args OPEN4args;

struct open_read_delegation4 {
    stateid4 stateid;
    bool_t recall;
    nfsace4 permissions;
};
typedef struct open_read_delegation4 open_read_delegation4;

struct open_write_delegation4 {
    stateid4 stateid;
    bool_t recall;
    nfs_space_limit4 space_limit;
    nfsace4 permissions;
};
typedef struct open_write_delegation4 open_write_delegation4;

struct open_delegation4 {
    open_delegation_type4 delegation_type;
    union {
        open_read_delegation4 read;
        open_write_delegation4 write;
    } open_delegation4_u;
};
typedef struct open_delegation4 open_delegation4;

const uint32_t OPEN4_RESULT_CONFIRM        {0x00000002};
const uint32_t OPEN4_RESULT_LOCKTYPE_POSIX {0x00000004};

struct OPEN4resok {
    stateid4 stateid;
    change_info4 cinfo;
    uint32_t rflags;
    bitmap4 attrset;
    open_delegation4 delegation;
};
typedef struct OPEN4resok OPEN4resok;

struct OPEN4res {
    nfsstat4 status;
    union {
        OPEN4resok resok4;
    } OPEN4res_u;
};
typedef struct OPEN4res OPEN4res;

struct OPENATTR4args {
    bool_t createdir;
};
typedef struct OPENATTR4args OPENATTR4args;

struct OPENATTR4res {
    nfsstat4 status;
};
typedef struct OPENATTR4res OPENATTR4res;

struct OPEN_CONFIRM4args {
    stateid4 open_stateid;
    seqid4 seqid;
};
typedef struct OPEN_CONFIRM4args OPEN_CONFIRM4args;

struct OPEN_CONFIRM4resok {
    stateid4 open_stateid;
};
typedef struct OPEN_CONFIRM4resok OPEN_CONFIRM4resok;

struct OPEN_CONFIRM4res {
    nfsstat4 status;
    union {
        OPEN_CONFIRM4resok resok4;
    } OPEN_CONFIRM4res_u;
};
typedef struct OPEN_CONFIRM4res OPEN_CONFIRM4res;

struct OPEN_DOWNGRADE4args {
    stateid4 open_stateid;
    seqid4 seqid;
    uint32_t share_access;
    uint32_t share_deny;
};
typedef struct OPEN_DOWNGRADE4args OPEN_DOWNGRADE4args;

struct OPEN_DOWNGRADE4resok {
    stateid4 open_stateid;
};
typedef struct OPEN_DOWNGRADE4resok OPEN_DOWNGRADE4resok;

struct OPEN_DOWNGRADE4res {
    nfsstat4 status;
    union {
        OPEN_DOWNGRADE4resok resok4;
    } OPEN_DOWNGRADE4res_u;
};
typedef struct OPEN_DOWNGRADE4res OPEN_DOWNGRADE4res;

struct PUTFH4args {
    nfs_fh4 object;
};
typedef struct PUTFH4args PUTFH4args;

struct PUTFH4res {
    nfsstat4 status;
};
typedef struct PUTFH4res PUTFH4res;

struct PUTPUBFH4res {
    nfsstat4 status;
};
typedef struct PUTPUBFH4res PUTPUBFH4res;

struct PUTROOTFH4res {
    nfsstat4 status;
};
typedef struct PUTROOTFH4res PUTROOTFH4res;

struct READ4args {
    stateid4 stateid;
    offset4 offset;
    count4 count;
};
typedef struct READ4args READ4args;

struct READ4resok {
    bool_t eof;
    struct {
        u_int data_len;
        char *data_val;
    } data;
};
typedef struct READ4resok READ4resok;

struct READ4res {
    nfsstat4 status;
    union {
        READ4resok resok4;
    } READ4res_u;
};
typedef struct READ4res READ4res;

struct READDIR4args {
    nfs_cookie4 cookie;
    verifier4 cookieverf;
    count4 dircount;
    count4 maxcount;
    bitmap4 attr_request;
};
typedef struct READDIR4args READDIR4args;

struct entry4 {
    nfs_cookie4 cookie;
    component4 name;
    fattr4 attrs;
    struct entry4 *nextentry;
};
typedef struct entry4 entry4;

struct dirlist4 {
    entry4 *entries;
    bool_t eof;
};
typedef struct dirlist4 dirlist4;

struct READDIR4resok {
    verifier4 cookieverf;
    dirlist4 reply;
};
typedef struct READDIR4resok READDIR4resok;

struct READDIR4res {
    nfsstat4 status;
    union {
        READDIR4resok resok4;
    } READDIR4res_u;
};
typedef struct READDIR4res READDIR4res;

struct READLINK4resok {
    linktext4 link;
};
typedef struct READLINK4resok READLINK4resok;

struct READLINK4res {
    nfsstat4 status;
    union {
        READLINK4resok resok4;
    } READLINK4res_u;
};
typedef struct READLINK4res READLINK4res;

struct REMOVE4args {
    component4 target;
};
typedef struct REMOVE4args REMOVE4args;

struct REMOVE4resok {
    change_info4 cinfo;
};
typedef struct REMOVE4resok REMOVE4resok;

struct REMOVE4res {
    nfsstat4 status;
    union {
        REMOVE4resok resok4;
    } REMOVE4res_u;
};
typedef struct REMOVE4res REMOVE4res;

struct RENAME4args {
    component4 oldname;
    component4 newname;
};
typedef struct RENAME4args RENAME4args;

struct RENAME4resok {
    change_info4 source_cinfo;
    change_info4 target_cinfo;
};
typedef struct RENAME4resok RENAME4resok;

struct RENAME4res {
    nfsstat4 status;
    union {
        RENAME4resok resok4;
    } RENAME4res_u;
};
typedef struct RENAME4res RENAME4res;

struct RENEW4args {
    clientid4 clientid;
};
typedef struct RENEW4args RENEW4args;

struct RENEW4res {
    nfsstat4 status;
};
typedef struct RENEW4res RENEW4res;

struct RESTOREFH4res {
    nfsstat4 status;
};
typedef struct RESTOREFH4res RESTOREFH4res;

struct SAVEFH4res {
    nfsstat4 status;
};
typedef struct SAVEFH4res SAVEFH4res;

struct SECINFO4args {
    component4 name;
};
typedef struct SECINFO4args SECINFO4args;

enum rpc_gss_svc_t {
    RPC_GSS_SVC_NONE = 1,
    RPC_GSS_SVC_INTEGRITY = 2,
    RPC_GSS_SVC_PRIVACY = 3,
};
typedef enum rpc_gss_svc_t rpc_gss_svc_t;

struct rpcsec_gss_info {
    sec_oid4 oid;
    qop4 qop;
    rpc_gss_svc_t service;
};
typedef struct rpcsec_gss_info rpcsec_gss_info;

struct secinfo4 {
    uint32_t flavor;
    union {
        rpcsec_gss_info flavor_info;
    } secinfo4_u;
};
typedef struct secinfo4 secinfo4;

typedef struct {
    u_int SECINFO4resok_len;
    secinfo4 *SECINFO4resok_val;
} SECINFO4resok;

struct SECINFO4res {
    nfsstat4 status;
    union {
        SECINFO4resok resok4;
    } SECINFO4res_u;
};
typedef struct SECINFO4res SECINFO4res;

struct SETATTR4args {
    stateid4 stateid;
    fattr4 obj_attributes;
};
typedef struct SETATTR4args SETATTR4args;

struct SETATTR4res {
    nfsstat4 status;
    bitmap4 attrsset;
};
typedef struct SETATTR4res SETATTR4res;

struct SETCLIENTID4args {
    nfs_client_id4 client;
    cb_client4 callback;
    uint32_t callback_ident;
};
typedef struct SETCLIENTID4args SETCLIENTID4args;

struct SETCLIENTID4resok {
    clientid4 clientid;
    verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID4resok SETCLIENTID4resok;

struct SETCLIENTID4res {
    nfsstat4 status;
    union {
        SETCLIENTID4resok resok4;
        clientaddr4 client_using;
    } SETCLIENTID4res_u;
};
typedef struct SETCLIENTID4res SETCLIENTID4res;

struct SETCLIENTID_CONFIRM4args {
    clientid4 clientid;
    verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID_CONFIRM4args SETCLIENTID_CONFIRM4args;

struct SETCLIENTID_CONFIRM4res {
    nfsstat4 status;
};
typedef struct SETCLIENTID_CONFIRM4res SETCLIENTID_CONFIRM4res;

struct VERIFY4args {
    fattr4 obj_attributes;
};
typedef struct VERIFY4args VERIFY4args;

struct VERIFY4res {
    nfsstat4 status;
};
typedef struct VERIFY4res VERIFY4res;

enum stable_how4 {
    UNSTABLE4 = 0,
    DATA_SYNC4 = 1,
    FILE_SYNC4 = 2,
};
typedef enum stable_how4 stable_how4;

struct WRITE4args {
    stateid4 stateid;
    offset4 offset;
    stable_how4 stable;
    struct {
        u_int data_len;
        char *data_val;
    } data;
};
typedef struct WRITE4args WRITE4args;

struct WRITE4resok {
    count4 count;
    stable_how4 committed;
    verifier4 writeverf;
};
typedef struct WRITE4resok WRITE4resok;

struct WRITE4res {
    nfsstat4 status;
    union {
        WRITE4resok resok4;
    } WRITE4res_u;
};
typedef struct WRITE4res WRITE4res;

struct RELEASE_LOCKOWNER4args {
    lock_owner4 lock_owner;
};
typedef struct RELEASE_LOCKOWNER4args RELEASE_LOCKOWNER4args;

struct RELEASE_LOCKOWNER4res {
    nfsstat4 status;
};
typedef struct RELEASE_LOCKOWNER4res RELEASE_LOCKOWNER4res;

struct ILLEGAL4res {
    nfsstat4 status;
};
typedef struct ILLEGAL4res ILLEGAL4res;

enum nfs_opnum4 {
    OP_ACCESS = 3,
    OP_CLOSE = 4,
    OP_COMMIT = 5,
    OP_CREATE = 6,
    OP_DELEGPURGE = 7,
    OP_DELEGRETURN = 8,
    OP_GETATTR = 9,
    OP_GETFH = 10,
    OP_LINK = 11,
    OP_LOCK = 12,
    OP_LOCKT = 13,
    OP_LOCKU = 14,
    OP_LOOKUP = 15,
    OP_LOOKUPP = 16,
    OP_NVERIFY = 17,
    OP_OPEN = 18,
    OP_OPENATTR = 19,
    OP_OPEN_CONFIRM = 20,
    OP_OPEN_DOWNGRADE = 21,
    OP_PUTFH = 22,
    OP_PUTPUBFH = 23,
    OP_PUTROOTFH = 24,
    OP_READ = 25,
    OP_READDIR = 26,
    OP_READLINK = 27,
    OP_REMOVE = 28,
    OP_RENAME = 29,
    OP_RENEW = 30,
    OP_RESTOREFH = 31,
    OP_SAVEFH = 32,
    OP_SECINFO = 33,
    OP_SETATTR = 34,
    OP_SETCLIENTID = 35,
    OP_SETCLIENTID_CONFIRM = 36,
    OP_VERIFY = 37,
    OP_WRITE = 38,
    OP_RELEASE_LOCKOWNER = 39,
    OP_GET_DIR_DELEGATION = 40,
    OP_ILLEGAL = 10044,
};
typedef enum nfs_opnum4 nfs_opnum4;

union nfs_argop4_u_t {
    ACCESS4args opaccess;
    CLOSE4args opclose;
    COMMIT4args opcommit;
    CREATE4args opcreate;
    DELEGPURGE4args opdelegpurge;
    DELEGRETURN4args opdelegreturn;
    GETATTR4args opgetattr;
    LINK4args oplink;
    LOCK4args oplock;
    LOCKT4args oplockt;
    LOCKU4args oplocku;
    LOOKUP4args oplookup;
    NVERIFY4args opnverify;
    OPEN4args opopen;
    OPENATTR4args opopenattr;
    OPEN_CONFIRM4args opopen_confirm;
    OPEN_DOWNGRADE4args opopen_downgrade;
    PUTFH4args opputfh;
    READ4args opread;
    READDIR4args opreaddir;
    REMOVE4args opremove;
    RENAME4args oprename;
    RENEW4args oprenew;
    SECINFO4args opsecinfo;
    SETATTR4args opsetattr;
    SETCLIENTID4args opsetclientid;
    SETCLIENTID_CONFIRM4args opsetclientid_confirm;
    VERIFY4args opverify;
    WRITE4args opwrite;
    RELEASE_LOCKOWNER4args oprelease_lockowner;
    GET_DIR_DELEGATION4args opget_dir_delegation;
};

struct nfs_argop4 {
    nfs_opnum4 argop;
    nfs_argop4_u_t nfs_argop4_u;
};
typedef struct nfs_argop4 nfs_argop4;

union nfs_resop4_u_t {
    ACCESS4res opaccess;
    CLOSE4res opclose;
    COMMIT4res opcommit;
    CREATE4res opcreate;
    DELEGPURGE4res opdelegpurge;
    DELEGRETURN4res opdelegreturn;
    GETATTR4res opgetattr;
    GETFH4res opgetfh;
    LINK4res oplink;
    LOCK4res oplock;
    LOCKT4res oplockt;
    LOCKU4res oplocku;
    LOOKUP4res oplookup;
    LOOKUPP4res oplookupp;
    NVERIFY4res opnverify;
    OPEN4res opopen;
    OPENATTR4res opopenattr;
    OPEN_CONFIRM4res opopen_confirm;
    OPEN_DOWNGRADE4res opopen_downgrade;
    PUTFH4res opputfh;
    PUTPUBFH4res opputpubfh;
    PUTROOTFH4res opputrootfh;
    READ4res opread;
    READDIR4res opreaddir;
    READLINK4res opreadlink;
    REMOVE4res opremove;
    RENAME4res oprename;
    RENEW4res oprenew;
    RESTOREFH4res oprestorefh;
    SAVEFH4res opsavefh;
    SECINFO4res opsecinfo;
    SETATTR4res opsetattr;
    SETCLIENTID4res opsetclientid;
    SETCLIENTID_CONFIRM4res opsetclientid_confirm;
    VERIFY4res opverify;
    WRITE4res opwrite;
    RELEASE_LOCKOWNER4res oprelease_lockowner;
    GET_DIR_DELEGATION4res opget_dir_delegation;
    ILLEGAL4res opillegal;
};

struct nfs_resop4 {
    nfs_opnum4 resop;
    nfs_resop4_u_t nfs_resop4_u;
};
typedef struct nfs_resop4 nfs_resop4;

struct COMPOUND4args {
    utf8str_cs tag;
    uint32_t minorversion;
    struct {
        u_int argarray_len;
        nfs_argop4 *argarray_val;
    } argarray;
};
typedef struct COMPOUND4args COMPOUND4args;

struct COMPOUND4res {
    nfsstat4 status;
    utf8str_cs tag;
    struct {
        u_int resarray_len;
        nfs_resop4 *resarray_val;
    } resarray;
};
typedef struct COMPOUND4res COMPOUND4res;

struct CB_GETATTR4args {
    nfs_fh4 fh;
    bitmap4 attr_request;
};
typedef struct CB_GETATTR4args CB_GETATTR4args;

struct CB_GETATTR4resok {
    fattr4 obj_attributes;
};
typedef struct CB_GETATTR4resok CB_GETATTR4resok;

struct CB_GETATTR4res {
    nfsstat4 status;
    union {
        CB_GETATTR4resok resok4;
    } CB_GETATTR4res_u;
};
typedef struct CB_GETATTR4res CB_GETATTR4res;

struct CB_RECALL4args {
    stateid4 stateid;
    bool_t truncate;
    nfs_fh4 fh;
};
typedef struct CB_RECALL4args CB_RECALL4args;

struct CB_RECALL4res {
    nfsstat4 status;
};
typedef struct CB_RECALL4res CB_RECALL4res;

struct CB_ILLEGAL4res {
    nfsstat4 status;
};
typedef struct CB_ILLEGAL4res CB_ILLEGAL4res;

enum nfs_cb_opnum4 {
    OP_CB_GETATTR = 3,
    OP_CB_RECALL = 4,
    OP_CB_ILLEGAL = 10044,
};
typedef enum nfs_cb_opnum4 nfs_cb_opnum4;

struct nfs_cb_argop4 {
    u_int argop;
    union {
        CB_GETATTR4args opcbgetattr;
        CB_RECALL4args opcbrecall;
    } nfs_cb_argop4_u;
};
typedef struct nfs_cb_argop4 nfs_cb_argop4;

struct nfs_cb_resop4 {
    u_int resop;
    union {
        CB_GETATTR4res opcbgetattr;
        CB_RECALL4res opcbrecall;
        CB_ILLEGAL4res opcbillegal;
    } nfs_cb_resop4_u;
};
typedef struct nfs_cb_resop4 nfs_cb_resop4;

struct CB_COMPOUND4args {
    utf8str_cs tag;
    uint32_t minorversion;
    uint32_t callback_ident;
    struct {
        u_int argarray_len;
        nfs_cb_argop4 *argarray_val;
    } argarray;
};
typedef struct CB_COMPOUND4args CB_COMPOUND4args;

struct CB_COMPOUND4res {
    nfsstat4 status;
    utf8str_cs tag;
    struct {
        u_int resarray_len;
        nfs_cb_resop4 *resarray_val;
    } resarray;
};
typedef struct CB_COMPOUND4res CB_COMPOUND4res;

const uint32_t NFS4_PROGRAM {100003};
#define NFS_V4  4

const uint32_t NFSPROC4_NULL {0};
const uint32_t NFSPROC4_COMPOUND {1};

const uint32_t NFS4_CALLBACK {0x40000000};
const uint32_t NFS_CB {1};

const uint32_t CB_NULL {0};
const uint32_t CB_COMPOUND {1};

} // namespace NFS4
} // namespace API
} // namespace NST
//------------------------------------------------------------------------------
#endif//NFS4_TYPES_RPCGEN_H
//------------------------------------------------------------------------------
