/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.web.clientproject.api.network.ui;

import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/**
 * UI for network errors.
 */
public class NetworkErrorPanel extends JPanel {

    private static final long serialVersionUID = 783521567875L;

    public static final int MAX_REQUEST_LENGTH = 80;

    private final List<String> failedRequests;


    public NetworkErrorPanel(List<String> failedRequests) {
        this.failedRequests = failedRequests;
        initComponents();

        init();
    }

    private void init() {
        String text = infoTextPane.getText();
        infoTextPane.setText(text.replace("%FAILED_REQUESTS%", joinRequests(failedRequests))); // NOI18N
        // listeners
        infoTextPane.addHyperlinkListener(new HyperlinkListener() {
            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
    }

    // unit tests
    static String joinRequests(List<String> failedRequests) {
        StringBuilder sb = new StringBuilder(200);
        for (String request : failedRequests) {
            if (request == null) {
                throw new NullPointerException("Request cannot be null");
            }
            if (sb.length() > 0) {
                sb.append("<br>"); // NOI18N
            }
            sb.append(decorateRequest(request));
        }
        return sb.toString();
    }

    // unit tests
    static String decorateRequest(String request) {
        String original = request;
        if (request.length() > MAX_REQUEST_LENGTH) {
            request = request.substring(0, MAX_REQUEST_LENGTH) + "..."; // NOI18N
        }
        if (request.startsWith("http://") // NOI18N
                || request.startsWith("https://")) { // NOI18N
            return "<a href=\"" + original + "\">" + request + "</a>"; // NOI18N
        }
        return request;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        infoScrollPane = new JScrollPane();
        infoTextPane = new JTextPane();

        infoScrollPane.setBorder(null);

        infoTextPane.setEditable(false);
        infoTextPane.setBorder(null);
        infoTextPane.setContentType("text/html"); // NOI18N
        infoTextPane.setText(NbBundle.getMessage(NetworkErrorPanel.class, "NetworkErrorPanel.infoTextPane.text")); // NOI18N
        infoTextPane.setOpaque(false);
        infoScrollPane.setViewportView(infoTextPane);

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(infoScrollPane)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(infoScrollPane)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JScrollPane infoScrollPane;
    private JTextPane infoTextPane;
    // End of variables declaration//GEN-END:variables
}
