/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Adamek, Andrei Badea
 */
public class ProgressPanel extends javax.swing.JPanel {

    private Dialog dialog;

    /** Creates new form ProgressPanel */
    public ProgressPanel() {
        initComponents();
    }

    public void open(JComponent progressComponent) {
        holder.add(progressComponent, BorderLayout.CENTER);
        DialogDescriptor dd = new DialogDescriptor(
                this,
                NbBundle.getMessage(ProgressPanel.class, "MSG_PleaseWait"),
                true,
                new Object[0],
                DialogDescriptor.NO_OPTION,
                DialogDescriptor.DEFAULT_ALIGN,
                null,
                null
                );
        dialog = DialogDisplayer.getDefault().createDialog(dd);
        if (dialog instanceof JDialog) {
            ((JDialog)dialog).setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        }
        dialog.setResizable(false);
        dialog.setVisible(true);
    }
    
    public void close() {
	if (dialog != null) {
	    dialog.setVisible(false);
	    dialog.dispose();
	}
    }
    
    public void setText(String text) {
        info.setText(text);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        info = new javax.swing.JLabel();
        holder = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        info.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 11);
        add(info, gridBagConstraints);

        holder.setLayout(new java.awt.BorderLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 11, 11);
        add(holder, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel holder;
    private javax.swing.JLabel info;
    // End of variables declaration//GEN-END:variables
    
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(500, orig.height);
    }
    
}
