/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.schema2beansdev;

import java.beans.*;
import java.io.*;

public class TestListener implements PropertyChangeListener {
    public PrintStream out;
    public boolean printStackTrace;

    public TestListener(PrintStream out) {
        this.out = out;
    }

    public void propertyChange(PropertyChangeEvent e) {
        out.print("oldValue=");
        printValue(e.getOldValue());
        out.println();
        out.print("newValue=");
        printValue(e.getNewValue());
        out.println();
        out.println("propertyName="+e.getPropertyName());
        out.println("source="+e.getSource());
        if (printStackTrace) {
            new Exception().printStackTrace();
        }
    }

    public void printValue(Object v) {
        if (v == null) {
            out.print("null");
            return;
        }
        Class cls = v.getClass();
        if (cls.isArray()) {
            out.print("{");
            Object[] arr = (Object[]) v;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0)
                    out.print(", ");
                printValue(arr[i]);
            }
            out.print("}");
        } else {
            out.print(""+v);
        }
    }
}
