/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.project.ui;

import java.net.URL;
import javax.swing.Icon;

import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;

/**
 * Accessor for UnloadedProjectInformation class
 * @author Milan Kubec
 */
public abstract class ProjectInfoAccessor {

    public static ProjectInfoAccessor DEFAULT;

    static {
        Class c = UnloadedProjectInformation.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        } catch (ClassNotFoundException cnfe) {
            assert false : cnfe;
        }
        assert DEFAULT != null;
    }
    
    public abstract UnloadedProjectInformation getProjectInfo(String dn, Icon ic, URL ur);
    
}
