/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;

/**
 *
 * @author  Martin Grebac
 */
public class ServiceProviderSelectorPanel extends javax.swing.JPanel {

    private boolean inSync = false;
    
    /**
     * Creates new form ServiceProviderSelectorPanel
     */
    public ServiceProviderSelectorPanel(String spUrl, String certAlias, String tokenType, String keyType) {
        super();
        
        initComponents();
        
        /* issue 232988: the background color issues with dark metal L&F
        certAliasTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        certAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        spUrlLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        spUrlTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        tokenTypeCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        tokenTypeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        tokenTypeCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        tokenTypeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        */
        
        inSync = true;
        tokenTypeCombo.removeAllItems();
        tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML10);
        tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML11);
        tokenTypeCombo.addItem(ComboConstants.ISSUED_TOKENTYPE_SAML20);
        tokenTypeCombo.setSelectedIndex(1); //saml11
        
        keyTypeCombo.removeAllItems();
        keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_PUBLIC);
        keyTypeCombo.addItem(ComboConstants.ISSUED_KEYTYPE_SYMMETRIC);
        
        this.setSpUrl(spUrl);
        this.setCertAlias(certAlias);
        this.setTokenType(tokenType);
        this.setKeyType(keyType);

        inSync = false;
    }

    public String getSpUrl() {
        return spUrlTextField.getText();
    }

    public void setSpUrl(String spUrl) {
        this.spUrlTextField.setText(spUrl);
    }

    public String getCertAlias() {
        return certAliasTextField.getText();
    }

    public void setCertAlias(String certAlias) {
        this.certAliasTextField.setText(certAlias);
    }

    public String getTokenType() {
        return (String)tokenTypeCombo.getSelectedItem();
    }

    public void setTokenType(String tokenType) {
        if (tokenType != null) {
            this.tokenTypeCombo.setSelectedItem(tokenType);
        }
    }

    public String getKeyType() {
        return (String)keyTypeCombo.getSelectedItem();
    }

    public void setKeyType(String keyType) {
        if (keyType != null) {
            this.keyTypeCombo.setSelectedItem(keyType);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        spUrlLabel = new javax.swing.JLabel();
        certAliasLabel = new javax.swing.JLabel();
        tokenTypeLabel = new javax.swing.JLabel();
        spUrlTextField = new javax.swing.JTextField();
        certAliasTextField = new javax.swing.JTextField();
        tokenTypeCombo = new javax.swing.JComboBox();
        keyTypeLabel = new javax.swing.JLabel();
        keyTypeCombo = new javax.swing.JComboBox();

        spUrlLabel.setText(org.openide.util.NbBundle.getMessage(ServiceProviderSelectorPanel.class, "LBL_STSConfig_ProviderURL")); // NOI18N

        certAliasLabel.setText(org.openide.util.NbBundle.getMessage(ServiceProviderSelectorPanel.class, "LBL_STSConfig_Alias")); // NOI18N

        tokenTypeLabel.setText(org.openide.util.NbBundle.getMessage(ServiceProviderSelectorPanel.class, "LBL_STSConfig_TokenType")); // NOI18N

        keyTypeLabel.setText(org.openide.util.NbBundle.getMessage(ServiceProviderSelectorPanel.class, "LBL_STSConfig_KeyType")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(spUrlLabel)
                    .addComponent(certAliasLabel)
                    .addComponent(tokenTypeLabel)
                    .addComponent(keyTypeLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(spUrlTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 288, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(certAliasTextField, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 126, Short.MAX_VALUE)
                            .addComponent(keyTypeCombo, javax.swing.GroupLayout.Alignment.LEADING, 0, 126, Short.MAX_VALUE)
                            .addComponent(tokenTypeCombo, javax.swing.GroupLayout.Alignment.LEADING, 0, 126, Short.MAX_VALUE))
                        .addGap(174, 174, 174)))
                .addGap(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(spUrlLabel)
                    .addComponent(spUrlTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(certAliasLabel)
                    .addComponent(certAliasTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tokenTypeLabel)
                    .addComponent(tokenTypeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(keyTypeLabel)
                    .addComponent(keyTypeCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel certAliasLabel;
    private javax.swing.JTextField certAliasTextField;
    private javax.swing.JComboBox keyTypeCombo;
    private javax.swing.JLabel keyTypeLabel;
    private javax.swing.JLabel spUrlLabel;
    private javax.swing.JTextField spUrlTextField;
    private javax.swing.JComboBox tokenTypeCombo;
    private javax.swing.JLabel tokenTypeLabel;
    // End of variables declaration//GEN-END:variables
    
}
