/* $Id: Sparse_seg.hpp 205909 2010-09-23 12:14:41Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Kamen Todorov
 *
 * File Description:
 *   Sparse-seg
 *
 */

/// @file Sparse_seg.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Sparse_seg_.hpp


#ifndef OBJECTS_SEQALIGN_SPARSE_SEG_HPP
#define OBJECTS_SEQALIGN_SPARSE_SEG_HPP


#include <objects/seqalign/Sparse_seg_.hpp>
#include <objects/seqalign/seqalign_exception.hpp>


BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSparse_seg : public CSparse_seg_Base
{
    typedef CSparse_seg_Base Tparent;
public:
    // constructor
    CSparse_seg(void);
    // destructor
    ~CSparse_seg(void);

    /// types
    typedef int TDim;

    /// Validators
    void Validate    (bool full_test = false) const;
    TDim CheckNumRows(void)                   const;


    // GetSeqRange
    CRange<TSeqPos> GetSeqRange(TDim row) const;
    TSeqPos         GetSeqStart(TDim row) const;
    TSeqPos         GetSeqStop(TDim row) const;

    // Get Seq_id (the first one if segments have different strands).
    const CSeq_id& GetSeq_id(TDim row) const;

    // Get strand (the first one if segments have different strands).
    ENa_strand      GetSeqStrand(TDim row) const;

private:
    // Prohibit copy constructor and assignment operator
    CSparse_seg(const CSparse_seg& value);
    CSparse_seg& operator=(const CSparse_seg& value);

};

/////////////////// CSparse_seg inline methods

// constructor
inline
CSparse_seg::CSparse_seg(void)
{
}


/////////////////// end of CSparse_seg inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPARSE_SEG_HPP
/* Original file checksum: lines: 86, chars: 2441, CRC32: 95d9afeb */
